/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.fabric.mixin;

import java.util.ArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import owmii.losttrinkets.fabric.mixin.ArmorCalculationInvokerMixin;
import owmii.losttrinkets.handler.CommonEventHandler;
import owmii.losttrinkets.handler.DataManager;
import owmii.losttrinkets.handler.TargetHandler;
import owmii.losttrinkets.item.trinkets.ButchersCleaverTrinket;
import owmii.losttrinkets.item.trinkets.CoffeeBeanTrinket;
import owmii.losttrinkets.item.trinkets.FireMindTrinket;
import owmii.losttrinkets.item.trinkets.GoldenMelonTrinket;
import owmii.losttrinkets.item.trinkets.GoldenSkullTrinket;
import owmii.losttrinkets.item.trinkets.LunchBagTrinket;
import owmii.losttrinkets.item.trinkets.MagicalHerbsTrinket;
import owmii.losttrinkets.item.trinkets.OxalisTrinket;
import owmii.losttrinkets.item.trinkets.TeaLeafTrinket;
import owmii.losttrinkets.item.trinkets.TreasureRingTrinket;

@Mixin(value={class_1309.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        FireMindTrinket.onLivingUpdate(entity);
        TargetHandler.onLivingUpdate(entity);
        DataManager.update(entity);
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    public void drop(class_1282 damageSourceIn, CallbackInfo ci) {
        ArrayList<class_1542> drops = new ArrayList<class_1542>();
        class_1309 entity = (class_1309)this;
        ButchersCleaverTrinket.dropExtra(damageSourceIn, entity, drops);
        TreasureRingTrinket.onDrops(damageSourceIn, entity, drops);
        GoldenSkullTrinket.onDrops(damageSourceIn, entity, drops);
        drops.forEach(e -> entity.field_6002.method_8649((class_1297)e));
    }

    @Inject(method={"canHaveStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void canHaveStatusEffect(class_1293 potionEffect, CallbackInfoReturnable<Boolean> cir) {
        Runnable denyResult = () -> {
            cir.setReturnValue((Object)false);
            cir.cancel();
        };
        class_1309 entity = (class_1309)this;
        CoffeeBeanTrinket.onPotion(entity, potionEffect.method_5579(), denyResult);
        MagicalHerbsTrinket.onPotion(entity, potionEffect.method_5579(), denyResult);
        OxalisTrinket.onPotion(entity, potionEffect.method_5579(), denyResult);
        TeaLeafTrinket.onPotion(entity, potionEffect.method_5579(), denyResult);
    }

    @Inject(method={"consumeItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;spawnConsumptionEffects(Lnet/minecraft/item/ItemStack;I)V", shift=At.Shift.AFTER)})
    public void consumeItem(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        class_1799 item = entity.method_6030();
        GoldenMelonTrinket.onUseFinish(entity, item);
        LunchBagTrinket.onUseFinish(entity, item);
    }

    @Redirect(method={"applyDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"))
    private float applyDamage(class_1309 self, class_1282 source, float damageAmount) {
        damageAmount = CommonEventHandler.onHurt(source, self, damageAmount);
        return ((ArmorCalculationInvokerMixin)self).invokeApplyArmorToDamage(source, damageAmount);
    }
}

