/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import java.util.concurrent.atomic.AtomicReference;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.ExplosionEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.handler.DataManager;
import owmii.losttrinkets.handler.UnlockHandler;
import owmii.losttrinkets.item.Itms;
import owmii.losttrinkets.item.trinkets.BigFootTrinket;
import owmii.losttrinkets.item.trinkets.BlazeHeartTrinket;
import owmii.losttrinkets.item.trinkets.DarkDaggerTrinket;
import owmii.losttrinkets.item.trinkets.DarkEggTrinket;
import owmii.losttrinkets.item.trinkets.DropSpindleTrinket;
import owmii.losttrinkets.item.trinkets.EmberTrinket;
import owmii.losttrinkets.item.trinkets.GoldenSwatterTrinket;
import owmii.losttrinkets.item.trinkets.MadAuraTrinket;
import owmii.losttrinkets.item.trinkets.MadPiggyTrinket;
import owmii.losttrinkets.item.trinkets.MirrorShardTrinket;
import owmii.losttrinkets.item.trinkets.OctopickTrinket;
import owmii.losttrinkets.item.trinkets.OctopusLegTrinket;
import owmii.losttrinkets.item.trinkets.RubyHeartTrinket;
import owmii.losttrinkets.item.trinkets.SerpentToothTrinket;
import owmii.losttrinkets.item.trinkets.SlingshotTrinket;
import owmii.losttrinkets.item.trinkets.StarfishTrinket;
import owmii.losttrinkets.item.trinkets.WitherNailTrinket;

public class CommonEventHandler {
    public static void register() {
        TickEvent.PLAYER_POST.register(player -> {
            PlayerData data = LostTrinketsAPI.getData(player);
            if (data.unlockDelay > 0L) {
                --data.unlockDelay;
            }
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            trinkets.getTickable().forEach(trinket -> trinket.tick(player.field_6002, player.method_24515(), (class_1657)player));
            if (player instanceof class_3222) {
                UnlockHandler.tickPlayerOnServer(player);
            }
        });
        TickEvent.SERVER_PRE.register(server -> RubyHeartTrinket.saveHealthTickStart(server));
        ExplosionEvent.PRE.register((world, explosion) -> {
            class_1657 player;
            Trinkets trinkets;
            class_1548 creeper;
            class_1309 target;
            class_1297 entity = explosion.field_9185;
            if (entity instanceof class_1548 && (target = (creeper = (class_1548)entity).method_5968()) instanceof class_1657 && (trinkets = LostTrinketsAPI.getTrinkets(player = (class_1657)target)).isActive(Itms.CREEPO)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        EntityEvent.ADD.register((entity, world) -> {
            AtomicReference<class_1269> result = new AtomicReference<class_1269>(class_1269.field_5811);
            OctopickTrinket.collectDrops(entity, cancel -> result.set(cancel != false ? class_1269.field_5814 : class_1269.field_5811));
            BigFootTrinket.addAvoidGoal(entity);
            return result.get();
        });
        EntityEvent.LIVING_ATTACK.register((entity, source, amount) -> {
            if (source == null) {
                return class_1269.field_5811;
            }
            AtomicReference<class_1269> result = new AtomicReference<class_1269>(class_1269.field_5811);
            if (BlazeHeartTrinket.isImmuneToFire(entity, source)) {
                result.set(class_1269.field_5814);
            }
            MadAuraTrinket.onAttack(entity, source, cancel -> result.set(cancel != false ? class_1269.field_5814 : class_1269.field_5811));
            OctopusLegTrinket.onAttack(entity, source);
            return result.get();
        });
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            if (source == null) {
                return class_1269.field_5811;
            }
            AtomicReference<class_1269> result = new AtomicReference<class_1269>(class_1269.field_5811);
            RubyHeartTrinket.onDeath(source, entity, cancel -> result.set(cancel != false ? class_1269.field_5814 : class_1269.field_5811));
            return result.get();
        });
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            UnlockHandler.kill(source, entity);
            return class_1269.field_5811;
        });
        BlockEvent.BREAK.register((world, pos, state, player, xp) -> {
            AtomicReference<class_1269> result = new AtomicReference<class_1269>(class_1269.field_5811);
            OctopickTrinket.onBreak((class_1657)player, pos, state, cancel -> result.set(cancel != false ? class_1269.field_5814 : class_1269.field_5811));
            return result.get();
        });
        PlayerEvent.PLAYER_CLONE.register((oldPlayer, newPlayer, wonGame) -> DataManager.clone((class_1657)oldPlayer, (class_1657)newPlayer, !wonGame));
        PlayerEvent.PLAYER_JOIN.register(player -> DataManager.loggedIn((class_1657)player));
        PlayerEvent.PLAYER_QUIT.register(player -> DataManager.loggedOut((class_1657)player));
        PlayerEvent.CHANGE_DIMENSION.register((player, oldLevel, newLevel) -> DataManager.sync((class_1657)player));
        PlayerEvent.PLAYER_RESPAWN.register((player, conqueredEnd) -> DataManager.sync((class_1657)player));
    }

    public static float onHurt(class_1282 source, class_1309 entityLiving, float amount) {
        if (source == null) {
            return amount;
        }
        DarkDaggerTrinket.onHurt(source, amount, entityLiving);
        DarkEggTrinket.onHurt(entityLiving, source);
        DropSpindleTrinket.onHurt(source);
        EmberTrinket.onHurt(entityLiving, source);
        GoldenSwatterTrinket.onHurt(entityLiving, source);
        MadPiggyTrinket.onHurt(entityLiving, source);
        MirrorShardTrinket.onHurt(entityLiving, source, amount);
        SerpentToothTrinket.onHurt(source, entityLiving);
        StarfishTrinket.onHurt(source, amount);
        SlingshotTrinket.onHurt(source, entityLiving);
        WitherNailTrinket.onHurt(source, entityLiving);
        if (source.method_5529() instanceof class_1657) {
            class_1657 player = (class_1657)source.method_5529();
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            if (trinkets.isActive(Itms.SILVER_NAIL)) {
                amount *= 1.1f;
            }
            if (trinkets.isActive(Itms.GLORY_SHARDS)) {
                amount *= 1.2f;
            }
        }
        return amount;
    }
}

