/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.Trinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.core.IPlayerEntityExtended;
import owmii.losttrinkets.network.Network;
import owmii.losttrinkets.network.packet.SyncDataPacket;

public class DataManager {
    public static void clone(class_1657 oldPlayer, class_1657 newPlayer, boolean wasDeath) {
        PlayerData oldData = LostTrinketsAPI.getData(oldPlayer);
        PlayerData newData = LostTrinketsAPI.getData(newPlayer);
        newData.deserializeNBT(oldData.serializeNBT());
        Trinkets trinkets = LostTrinketsAPI.getTrinkets(newPlayer);
        trinkets.getActiveTrinkets().forEach(trinket -> {
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).applyAttributes(newPlayer);
            }
        });
        if (!wasDeath) {
            newPlayer.method_6033(oldPlayer.method_6032());
        }
    }

    public static void update(class_1309 entity) {
        class_3222 player;
        PlayerData data;
        if (entity instanceof class_3222 && (data = LostTrinketsAPI.getData((class_1657)(player = (class_3222)entity))).isSync()) {
            Network.toTrackingAndSelf(new SyncDataPacket((class_1657)player), (class_1297)player);
            data.setSync(false);
        }
    }

    public static void loggedIn(class_1657 player) {
        Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
        trinkets.initSlots(LostTrinkets.config().startSlots);
        trinkets.removeDisabled(player);
        DataManager.sync(player);
    }

    public static void loggedOut(class_1657 player) {
        PlayerData data = LostTrinketsAPI.getData(player);
        data.wasFlying = player.field_7503.field_7479;
    }

    public static void trackPlayer(class_1297 target, class_1657 player) {
        if (target instanceof class_3222) {
            Network.toClient(new SyncDataPacket((class_1657)((class_3222)target)), player);
        }
    }

    static void sync(class_1657 player) {
        if (player instanceof class_3222) {
            Network.toClient(new SyncDataPacket(player), player);
        }
    }

    public static PlayerData getPlayerData(class_1657 player) {
        return ((IPlayerEntityExtended)player).sunkentrinkets_getPlayerData();
    }
}

