/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import owmii.losttrinkets.EnvHandler;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.entity.Entities;
import owmii.losttrinkets.handler.UnlockManager;
import owmii.losttrinkets.impl.LostTrinketsAPIImpl;
import owmii.losttrinkets.lib.util.Ticker;

public class UnlockHandler {
    private static final Map<UUID, Type> MAP = new HashMap<UUID, Type>();
    private static final Ticker DELAY = new Ticker(10.0);
    private static boolean flag;

    public static void tickPlayerOnServer(class_1657 player) {
        List<ITrinket> trinkets = LostTrinketsAPIImpl.UNLOCK_QUEUE.get(player.method_5667());
        if (trinkets != null) {
            trinkets.forEach(trinket -> UnlockManager.unlock(player, trinket, false));
        }
        LostTrinketsAPIImpl.UNLOCK_QUEUE.remove(player.method_5667());
        Iterator<UUID> itr = LostTrinketsAPIImpl.WEIGHTED_UNLOCK_QUEUE.iterator();
        while (itr.hasNext()) {
            if (!itr.next().equals(player.method_5667())) continue;
            UnlockManager.unlock(player, false);
            itr.remove();
        }
        UnlockHandler.checkUnlocks(player);
    }

    private static void checkUnlocks(class_1657 player) {
        if (LostTrinkets.config().unlockEnabled) {
            UUID id = player.method_5667();
            if (DELAY.isEmpty() && MAP.containsKey(id)) {
                if (player.field_6002.field_9229.nextInt(MAP.get(id).getRandom()) == 0) {
                    UnlockManager.unlock(player, true);
                }
                flag = true;
            }
            if (flag) {
                DELAY.onward();
                MAP.remove(id);
                if (DELAY.ended()) {
                    DELAY.reset();
                    flag = false;
                }
            }
        }
    }

    private static void queueUnlock(class_1657 player, Type type) {
        if (!player.field_6002.field_9236 && !PlayerHooks.isFake((class_1657)player)) {
            MAP.put(player.method_5667(), type);
        }
    }

    public static void trade(class_1657 player) {
        if (LostTrinkets.config().unlockEnabled && LostTrinkets.config().tradingUnlockEnabled && !player.field_6002.field_9236) {
            UnlockHandler.queueUnlock(player, Type.TRADING);
        }
    }

    public static void kill(class_1282 source, class_1309 target) {
        class_1297 entity;
        if (LostTrinkets.config().unlockEnabled && (entity = source.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!player.field_6002.field_9236) {
                if (Entities.isNonBossEntity((class_1297)target)) {
                    if (LostTrinkets.config().killingUnlockEnabled) {
                        UnlockHandler.queueUnlock(player, Type.KILL);
                    }
                } else if (LostTrinkets.config().bossKillingUnlockEnabled) {
                    UnlockHandler.queueUnlock(player, Type.BOSS_KILL);
                }
            }
        }
    }

    public static void checkBlockHarvest(class_1657 player, class_1937 world, class_2338 pos, class_2680 state) {
        if (LostTrinkets.config().unlockEnabled && !player.field_6002.field_9236) {
            if (EnvHandler.INSTANCE.isOreBlock(state.method_26204())) {
                if (LostTrinkets.config().oresMiningUnlockEnabled) {
                    UnlockHandler.queueUnlock(player, Type.ORE_MINE);
                }
            } else if (class_3481.field_20341.method_15141((Object)state.method_26204())) {
                if (LostTrinkets.config().farmingUnlockEnabled) {
                    UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
                }
            } else if (class_3481.field_15475.method_15141((Object)state.method_26204()) && LostTrinkets.config().woodCuttingUnlockEnabled) {
                UnlockHandler.queueUnlock(player, Type.WOOD_CUTTING);
            }
        }
    }

    public static void useHoe(class_1657 player) {
        if (LostTrinkets.config().unlockEnabled && LostTrinkets.config().farmingUnlockEnabled && !player.field_6002.field_9236) {
            UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
        }
    }

    public static void bonemeal(class_1657 player) {
        if (LostTrinkets.config().unlockEnabled && LostTrinkets.config().farmingUnlockEnabled && !player.field_6002.field_9236) {
            UnlockHandler.queueUnlock(player, Type.FARM_HARVEST);
        }
    }

    static enum Type {
        KILL,
        BOSS_KILL,
        ORE_MINE,
        WOOD_CUTTING,
        FARM_HARVEST,
        TRADING;


        public int getRandom() {
            if (this == KILL) {
                return LostTrinkets.config().killing;
            }
            if (this == BOSS_KILL) {
                return LostTrinkets.config().bossKilling;
            }
            if (this == ORE_MINE) {
                return LostTrinkets.config().oresMining;
            }
            if (this == TRADING) {
                return LostTrinkets.config().trading;
            }
            if (this == FARM_HARVEST) {
                return LostTrinkets.config().farming;
            }
            if (this == WOOD_CUTTING) {
                return LostTrinkets.config().woodCutting;
            }
            return Integer.MAX_VALUE;
        }
    }
}

