/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.architectury.utils.GameInstance;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3549;
import net.minecraft.class_5250;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.config.SunkenTrinketsConfig;
import owmii.losttrinkets.network.Network;
import owmii.losttrinkets.network.packet.TrinketUnlockedPacket;

public class UnlockManager {
    private static final Set<ITrinket> ALL_TRINKETS = class_2378.field_11142.method_10220().filter(item -> item instanceof ITrinket).map(item -> (ITrinket)item).collect(Collectors.toCollection(LinkedHashSet::new));
    private static final Set<ITrinket> TRINKETS = Sets.newLinkedHashSet(ALL_TRINKETS);
    private static final Set<ITrinket> RANDOM_TRINKETS = Sets.newLinkedHashSet(ALL_TRINKETS);
    private static final List<WeightedTrinket> WEIGHTED_TRINKETS = new ArrayList<WeightedTrinket>();

    @Nullable
    public static ITrinket unlock(class_1657 player, boolean checkDelay) {
        if (player instanceof class_3222) {
            PlayerData data = LostTrinketsAPI.getData(player);
            if (!checkDelay || data.unlockDelay <= 0L) {
                Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
                WEIGHTED_TRINKETS.clear();
                WEIGHTED_TRINKETS.addAll(RANDOM_TRINKETS.stream().filter(trinket -> !trinkets.has((ITrinket)trinket)).map(WeightedTrinket::new).collect(Collectors.toList()));
                if (!WEIGHTED_TRINKETS.isEmpty()) {
                    WeightedTrinket item = (WeightedTrinket)class_3549.method_15446((Random)player.field_6002.field_9229, WEIGHTED_TRINKETS);
                    UnlockManager.unlock(player, item.trinket, checkDelay);
                }
            }
        }
        return null;
    }

    public static boolean unlock(class_1657 player, ITrinket trinket, boolean checkDelay) {
        return UnlockManager.unlock(player, trinket, checkDelay, true);
    }

    public static boolean unlock(class_1657 player, ITrinket trinket, boolean checkDelay, boolean doNotification) {
        PlayerData data = LostTrinketsAPI.getData(player);
        if (!checkDelay || data.unlockDelay <= 0L) {
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            if (LostTrinketsAPI.get().isEnabled(trinket) && trinkets.give(trinket)) {
                if (checkDelay) {
                    data.unlockDelay = LostTrinkets.config().unlockCooldown;
                }
                if (doNotification) {
                    Network.toClient(new TrinketUnlockedPacket(Objects.requireNonNull(class_2378.field_11142.method_10221((Object)trinket.method_8389())).toString()), player);
                    class_1799 stack = new class_1799((class_1935)trinket);
                    class_5250 trinketName = stack.method_7964().method_27661().method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack))));
                    GameInstance.getServer().method_3760().method_14616((class_2561)new class_2588("chat.losttrinkets.unlocked.trinket", new Object[]{player.method_5476(), trinketName}).method_27692(class_124.field_1062), class_2556.field_11735, class_156.field_25140);
                }
                return true;
            }
        }
        return false;
    }

    public static void refresh() {
        Set banned = LostTrinkets.config().blackList.stream().map(class_2960::new).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set nonRandom = LostTrinkets.config().nonRandom.stream().map(class_2960::new).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        LinkedHashSet seen = Sets.newLinkedHashSet();
        LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "Gathering Trinkets...");
        ALL_TRINKETS.forEach(trinket -> {
            class_2960 rl = class_2378.field_11142.method_10221((Object)trinket.method_8389());
            seen.add(rl);
            if (banned.contains(rl)) {
                TRINKETS.remove(trinket);
                RANDOM_TRINKETS.remove(trinket);
                LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "Banned: " + rl);
            } else {
                TRINKETS.add((ITrinket)trinket);
                if (trinket.isUnlockable() && !nonRandom.contains(rl)) {
                    RANDOM_TRINKETS.add((ITrinket)trinket);
                    LostTrinkets.LOGGER.debug(SunkenTrinketsConfig.MARKER, "Enabled: " + rl);
                } else {
                    RANDOM_TRINKETS.remove(trinket);
                    LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "Non-Random: " + rl);
                }
            }
        });
        LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "All: " + ALL_TRINKETS.size());
        LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "Enabled: " + TRINKETS.size() + " Disabled: " + (ALL_TRINKETS.size() - TRINKETS.size()));
        LostTrinkets.LOGGER.info(SunkenTrinketsConfig.MARKER, "Random: " + RANDOM_TRINKETS.size() + " Non-Random: " + (TRINKETS.size() - RANDOM_TRINKETS.size()));
        banned.stream().filter(rl -> !seen.contains(rl)).forEach(rl -> LostTrinkets.LOGGER.warn(SunkenTrinketsConfig.MARKER, "Unknown Banned Trinket: " + rl));
        nonRandom.stream().filter(rl -> !seen.contains(rl)).forEach(rl -> LostTrinkets.LOGGER.warn(SunkenTrinketsConfig.MARKER, "Unknown Non-Random Trinket: " + rl));
        nonRandom.stream().filter(banned::contains).forEach(rl -> LostTrinkets.LOGGER.warn(SunkenTrinketsConfig.MARKER, "Redundant Non-Random Trinket (already banned): " + rl));
    }

    public static Set<ITrinket> getTrinkets() {
        return Collections.unmodifiableSet(TRINKETS);
    }

    public static Set<ITrinket> getRandomTrinkets() {
        return Collections.unmodifiableSet(RANDOM_TRINKETS);
    }

    static class WeightedTrinket
    extends class_3549.class_3550 {
        private final ITrinket trinket;

        public WeightedTrinket(ITrinket trinket) {
            super(trinket.getRarity().getWeight());
            this.trinket = trinket;
        }

        public ITrinket getTrinket() {
            return this.trinket;
        }
    }
}

