/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.network;

import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import owmii.losttrinkets.EnvHandler;
import owmii.losttrinkets.network.IPacket;
import owmii.losttrinkets.network.packet.MagnetoPacket;
import owmii.losttrinkets.network.packet.SetActivePacket;
import owmii.losttrinkets.network.packet.SetInactivePacket;
import owmii.losttrinkets.network.packet.SyncDataPacket;
import owmii.losttrinkets.network.packet.SyncFlyPacket;
import owmii.losttrinkets.network.packet.TrinketUnlockedPacket;
import owmii.losttrinkets.network.packet.UnlockSlotPacket;

public final class Network {
    private static final class_2960 PACKET_ID = new class_2960("losttrinkets", "packet");
    private static int nextId = 0;
    private static List<Constructor<? extends IPacket>> decoders = new ArrayList<Constructor<? extends IPacket>>();
    private static IdentityHashMap<Class<?>, Integer> packetIds = new IdentityHashMap();

    public static <T extends IPacket> void register(Class<T> packetClass) {
        Constructor<T> constructor = null;
        try {
            constructor = packetClass.getConstructor(class_2540.class);
            decoders.add(constructor);
            packetIds.put(packetClass, nextId);
            ++nextId;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to register packet", e);
        }
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)PACKET_ID, Network::handlePacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)PACKET_ID, Network::handlePacket);
        Network.register(SyncDataPacket.class);
        Network.register(SetActivePacket.class);
        Network.register(SetInactivePacket.class);
        Network.register(UnlockSlotPacket.class);
        Network.register(TrinketUnlockedPacket.class);
        Network.register(SyncFlyPacket.class);
        Network.register(MagnetoPacket.class);
    }

    private static void handlePacket(class_2540 buf, NetworkManager.PacketContext ctx) {
        int packetId = buf.method_10816();
        try {
            IPacket packet = decoders.get(packetId).newInstance(buf);
            ctx.queue(() -> packet.handle(ctx.getPlayer()));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to construct packet of type " + packetId, e);
        }
    }

    private static class_2540 encodePacket(IPacket packet) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(packetIds.get(packet.getClass()).intValue());
        packet.encode(buf);
        return buf;
    }

    public static void toServer(IPacket msg) {
        NetworkManager.sendToServer((class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
    }

    public static void toClient(IPacket msg, class_1657 player) {
        if (player instanceof class_3222) {
            NetworkManager.sendToPlayer((class_3222)((class_3222)player), (class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
        }
    }

    public static void toTrackingAndSelf(IPacket msg, class_1297 entity) {
        Collection<class_3222> trackingPlayers = EnvHandler.INSTANCE.getTrackingPlayers(entity);
        if (!trackingPlayers.isEmpty()) {
            NetworkManager.sendToPlayers(trackingPlayers, (class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
        }
        if (entity instanceof class_3222) {
            NetworkManager.sendToPlayer((class_3222)((class_3222)entity), (class_2960)PACKET_ID, (class_2540)Network.encodePacket(msg));
        }
    }
}

