/*
 * Decompiled with CFR 0.152.
 */
package net.eligibbs.and.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.eligibbs.and.block.ModBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        List<DeferredBlock<Block>> FOSSIL_SMELTABLES = List.of(ModBlocks.LOW_QUALITY_FOSSIL_ORE);
        ModRecipeProvider.oreSmelting(pRecipeOutput, FOSSIL_SMELTABLES, RecipeCategory.MISC, (ItemLike)Blocks.BONE_BLOCK, 0.25f, 200, "and_fossil");
        ModRecipeProvider.oreBlasting(pRecipeOutput, FOSSIL_SMELTABLES, RecipeCategory.MISC, (ItemLike)Blocks.BONE_BLOCK, 0.25f, 100, "and_fossil");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COLOR_CUBE.get())).pattern(" A ").pattern("BCD").pattern(" E ").define(Character.valueOf('A'), (ItemLike)Items.WHITE_DYE).define(Character.valueOf('B'), (ItemLike)Items.GREEN_DYE).define(Character.valueOf('C'), (ItemLike)Items.BLUE_DYE).define(Character.valueOf('D'), (ItemLike)Items.RED_DYE).define(Character.valueOf('E'), (ItemLike)Items.YELLOW_DYE).unlockedBy("has_dyes", ModRecipeProvider.has((TagKey)Tags.Items.DYES)).save(pRecipeOutput);
    }

    protected static void oreSmelting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput pRecipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(pRecipeOutput, "and:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

