/*
 * Decompiled with CFR 0.152.
 */
package net.eligibbs.and.block;

import java.util.function.Supplier;
import net.eligibbs.and.item.ModItems;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"and");
    public static final DeferredBlock<Block> COLOR_CUBE = ModBlocks.registerBlock("color_cube", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> LOW_QUALITY_FOSSIL_ORE = ModBlocks.registerBlock("low_quality_fossil_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)5), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MEDIUM_QUALITY_FOSSIL_ORE = ModBlocks.registerBlock("medium_quality_fossil_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)5), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> HIGH_QUALITY_FOSSIL_ORE = ModBlocks.registerBlock("high_quality_fossil_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)5), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK = ModBlocks.registerBlock("fossil_block", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_STAIRS = ModBlocks.registerBlock("fossil_block_stairs", () -> new StairBlock(((Block)FOSSIL_BLOCK.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_SLAB = ModBlocks.registerBlock("fossil_block_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_PRESSURE_PLATE = ModBlocks.registerBlock("fossil_block_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_BUTTON = ModBlocks.registerBlock("fossil_block_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_FENCE = ModBlocks.registerBlock("fossil_block_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_FENCE_GATE = ModBlocks.registerBlock("fossil_block_fence_gate", () -> new FenceGateBlock(WoodType.ACACIA, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_WALL = ModBlocks.registerBlock("fossil_block_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_DOOR = ModBlocks.registerBlock("fossil_block_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noOcclusion()));
    public static final DeferredBlock<Block> FOSSIL_BLOCK_TRAPDOOR = ModBlocks.registerBlock("fossil_block_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noOcclusion()));

    public static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

