/*
 * Decompiled with CFR 0.152.
 */
package net.eligibbs.and.worldgen;

import java.util.List;
import net.eligibbs.and.worldgen.ModAquaticPlacements;
import net.eligibbs.and.worldgen.ModConfiguredFeatures;
import net.eligibbs.and.worldgen.ModOrePlacements;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> LOW_QUALITY_FOSSIL_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("low_quality_fossil_ore_placed");
    public static final ResourceKey<PlacedFeature> MEDIUM_QUALITY_FOSSIL_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("medium_quality_fossil_ore_placed");
    public static final ResourceKey<PlacedFeature> HIGH_QUALITY_FOSSIL_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("high_quality_fossil_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, LOW_QUALITY_FOSSIL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_LOW_QUALITY_FOSSIL_ORE_KEY), ModOrePlacements.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, MEDIUM_QUALITY_FOSSIL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_MEDIUM_QUALITY_FOSSIL_ORE_KEY), ModOrePlacements.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)8))));
        ModPlacedFeatures.register(context, HIGH_QUALITY_FOSSIL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_HIGH_QUALITY_FOSSIL_ORE_KEY), ModAquaticPlacements.fossilPlacement(4));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"and", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

