/*
 * Decompiled with CFR 0.152.
 */
package commandScheduler.plugincommandrunner;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.pokeskies.fabricpluginmessaging.PluginMessageEvent;
import com.pokeskies.fabricpluginmessaging.PluginMessagePacket;
import commandScheduler.plugincommandrunner.configs.ConfigManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"LcommandScheduler/plugincommandrunner/Plugincommandrunner;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "registerCommandRunner", "Lnet/minecraft/server/MinecraftServer;", "server", "", "command", "executeCommand", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)V", "Companion", "PluginCommandRunner"})
public final class Plugincommandrunner
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MOD_ID = "PluginCommandRunner";
    @NotNull
    private static final Logger LOGGER;

    public void onInitialize() {
        try {
            ConfigManager.INSTANCE.loadConfig();
            this.registerCommandRunner();
            LOGGER.info("PluginCommandRunner loaded correctly.");
            LOGGER.info("Listening for plugin messages and commands to run on: " + ConfigManager.INSTANCE.getConfig().getServer());
        }
        catch (Exception e) {
            LOGGER.warn(e.toString());
        }
    }

    public final void registerCommandRunner() {
        String mainMessagingChannel = MOD_ID;
        String secondaryMessagingChannel = ConfigManager.INSTANCE.getConfig().getServer();
        PluginMessageEvent.EVENT.register((arg_0, arg_1) -> Plugincommandrunner.registerCommandRunner$lambda$0(mainMessagingChannel, secondaryMessagingChannel, this, arg_0, arg_1));
    }

    public final void executeCommand(@NotNull MinecraftServer server, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        server.method_3734().method_44252(server.method_3739(), command);
    }

    private static final void registerCommandRunner$lambda$0(String $mainMessagingChannel, String $secondaryMessagingChannel, Plugincommandrunner this$0, PluginMessagePacket payload, ServerPlayNetworking.Context context) {
        LOGGER.info("Received something.");
        byte[] byArray = payload.getData();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
        if (!(byArray.length == 0)) {
            ByteArrayDataInput inputStream = ByteStreams.newDataInput((byte[])payload.getData());
            String channel = inputStream.readUTF();
            LOGGER.info("current channel: " + channel);
            if (Intrinsics.areEqual((Object)channel, (Object)$mainMessagingChannel)) {
                String currentServer = inputStream.readUTF();
                LOGGER.info("current server: " + currentServer);
                if (Intrinsics.areEqual((Object)currentServer, (Object)$secondaryMessagingChannel)) {
                    MinecraftServer server = context.server();
                    if (server != null) {
                        String command = inputStream.readUTF();
                        LOGGER.info("command to run: " + command);
                        Intrinsics.checkNotNull((Object)command);
                        this$0.executeCommand(server, command);
                    } else {
                        LOGGER.warn("Had problems getting the server instance.");
                    }
                }
            }
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"LcommandScheduler/plugincommandrunner/Plugincommandrunner$Companion;", "", "<init>", "()V", "", "MOD_ID", "Ljava/lang/String;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "PluginCommandRunner"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

