/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.gui.screen;

import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.Config;
import me.axieum.mcmod.authme.api.gui.screen.AuthScreen;
import me.axieum.mcmod.authme.api.util.SessionUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class OfflineAuthScreen
extends AuthScreen {
    private EditBox usernameField;
    private Button loginBtn;

    public OfflineAuthScreen(Screen parentScreen, Screen successScreen) {
        super((Component)Component.translatable((String)"gui.authme.offline.title"), parentScreen, successScreen);
        this.closeOnSuccess = true;
    }

    @Override
    protected void init() {
        super.init();
        assert (this.minecraft != null);
        StringWidget titleWidget = (StringWidget)this.addRenderableWidget((GuiEventListener)new StringWidget(this.title, this.font));
        titleWidget.setColor(0xFFFFFF);
        AuthScreen.centerPosition((LayoutElement)titleWidget, this, 0, -40);
        this.usernameField = new EditBox(this.font, this.width / 2 - 100, this.height / 2 - 6, 200, 20, (Component)Component.translatable((String)"gui.authme.offline.field.username"));
        this.addRenderableWidget((GuiEventListener)this.usernameField);
        this.usernameField.setMaxLength(128);
        if (Config.LoginMethods.Offline.lastUsername != null) {
            this.usernameField.setValue(Config.LoginMethods.Offline.lastUsername);
        }
        this.usernameField.setResponder(value -> {
            this.loginBtn.active = this.isFormValid();
        });
        StringWidget labelWidget = (StringWidget)this.addRenderableWidget((GuiEventListener)new StringWidget(this.usernameField.getMessage(), this.font));
        labelWidget.setColor(0xDDDDDD);
        AuthScreen.centerPosition((LayoutElement)labelWidget, this, -51, -17);
        this.loginBtn = Button.builder((Component)Component.translatable((String)"gui.authme.offline.button.login"), button -> this.login()).bounds(this.width / 2 - 100 - 2, this.height / 2 + 26, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.loginBtn);
        this.loginBtn.active = this.isFormValid();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 + 2, this.height / 2 + 26, 100, 20).build());
    }

    public void login() {
        assert (this.minecraft != null);
        if (!this.isFormValid()) {
            return;
        }
        this.usernameField.active = false;
        this.loginBtn.active = false;
        SessionUtils.setUser(SessionUtils.offline(this.usernameField.getValue()));
        Config.LoginMethods.Offline.lastUsername = this.usernameField.getValue();
        SystemToast.add((ToastManager)this.minecraft.getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"gui.authme.toast.greeting", (Object[])new Object[]{Component.literal((String)this.usernameField.getValue())}), null);
        AuthMe.LOGGER.info("Successfully logged in offline-mode!");
        this.success = true;
    }

    public boolean isFormValid() {
        return !this.usernameField.getValue().isBlank();
    }
}

