/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.mixin.MinecraftAccessor;
import me.axieum.mcmod.authme.mixin.RealmsAvailabilityAccessor;
import me.axieum.mcmod.authme.mixin.ReportingContextAccessor;
import me.axieum.mcmod.authme.mixin.SplashManagerAccessor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static User getUser() {
        return Minecraft.getInstance().getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUser(User user) {
        Minecraft client = Minecraft.getInstance();
        ((MinecraftAccessor)client).setUser(user);
        ((SplashManagerAccessor)client.getSplashManager()).setUser(user);
        ((MinecraftAccessor)client).setProfileFuture(CompletableFuture.supplyAsync(() -> client.services().sessionService().fetchProfile(user.getProfileId(), true), (Executor)Util.nonCriticalIoPool()));
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(user.getAccessToken())) {
            userApiService = SessionUtils.getAuthService().createUserApiService(user.getAccessToken());
        }
        ((MinecraftAccessor)client).setUserApiService(userApiService);
        ((MinecraftAccessor)client).setPlayerSocialManager(new PlayerSocialManager(client, userApiService));
        ((MinecraftAccessor)client).setProfileKeyPairManager(ProfileKeyPairManager.create((UserApiService)userApiService, (User)user, (Path)client.gameDirectory.toPath()));
        ((MinecraftAccessor)client).setReportingContext(ReportingContext.create((ReportEnvironment)((ReportingContextAccessor)client.getReportingContext()).getEnvironment(), (UserApiService)userApiService));
        Class<RealmsClient> clazz = RealmsClient.class;
        synchronized (RealmsClient.class) {
            RealmsClient realmsClient;
            RealmsClient.realmsClientInstance = realmsClient = new RealmsClient(user.getSessionId(), user.getName(), client);
            ((MinecraftAccessor)client).setRealmsDataFetcher(new RealmsDataFetcher(realmsClient));
            RealmsAvailabilityAccessor.setFuture(null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            lastStatus = SessionStatus.UNKNOWN;
            lastStatusCheck = 0L;
            AuthMe.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)user.getName(), (Object)user.getProfileId());
            return;
        }
    }

    public static User offline(String username) {
        return new User(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()), OFFLINE_TOKEN, Optional.empty(), Optional.empty());
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            User session = SessionUtils.getUser();
            String serverId = UUID.randomUUID().toString();
            MinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                AuthMe.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(session.getProfileId(), session.getAccessToken(), serverId);
                if (sessionService.hasJoinedServer(session.getName(), serverId, null) != null) {
                    AuthMe.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    AuthMe.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static MinecraftSessionService getSessionService() {
        return Minecraft.getInstance().services().sessionService();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        return Minecraft.getInstance().authme$getAuthService();
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

