/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.mixin.MinecraftAccessor;
import me.axieum.mcmod.authme.mixin.RealmsAvailabilityAccessor;
import me.axieum.mcmod.authme.mixin.ReportingContextAccessor;
import me.axieum.mcmod.authme.mixin.SplashManagerAccessor;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_4341;
import net.minecraft.class_5520;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7578;
import net.minecraft.class_7853;

public final class SessionUtils {
    public static final String OFFLINE_TOKEN = "invalidtoken";
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static class_320 getUser() {
        return class_310.method_1551().method_1548();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUser(class_320 user) {
        class_310 client = class_310.method_1551();
        ((MinecraftAccessor)client).setUser(user);
        ((SplashManagerAccessor)client.method_18095()).setUser(user);
        ((MinecraftAccessor)client).setProfileFuture(CompletableFuture.supplyAsync(() -> client.method_73361().comp_837().fetchProfile(user.method_44717(), true), (Executor)class_156.method_55473()));
        UserApiService userApiService = UserApiService.OFFLINE;
        if (!OFFLINE_TOKEN.equals(user.method_1674())) {
            userApiService = SessionUtils.getAuthService().createUserApiService(user.method_1674());
        }
        ((MinecraftAccessor)client).setUserApiService(userApiService);
        ((MinecraftAccessor)client).setPlayerSocialManager(new class_5520(client, userApiService));
        ((MinecraftAccessor)client).setProfileKeyPairManager(class_7853.method_46532((UserApiService)userApiService, (class_320)user, (Path)client.field_1697.toPath()));
        ((MinecraftAccessor)client).setReportingContext(class_7574.method_44599((class_7569)((ReportingContextAccessor)client.method_44377()).getEnvironment(), (UserApiService)userApiService));
        Class<class_4341> clazz = class_4341.class;
        synchronized (class_4341.class) {
            class_4341 realmsClient;
            class_4341.field_57916 = realmsClient = new class_4341(user.method_1675(), user.method_1676(), client);
            ((MinecraftAccessor)client).setRealmsDataFetcher(new class_7578(realmsClient));
            RealmsAvailabilityAccessor.setFuture(null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            lastStatus = SessionStatus.UNKNOWN;
            lastStatusCheck = 0L;
            AuthMe.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)user.method_1676(), (Object)user.method_44717());
            return;
        }
    }

    public static class_320 offline(String username) {
        return new class_320(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()), OFFLINE_TOKEN, Optional.empty(), Optional.empty());
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            class_320 session = SessionUtils.getUser();
            String serverId = UUID.randomUUID().toString();
            MinecraftSessionService sessionService = SessionUtils.getSessionService();
            try {
                AuthMe.LOGGER.info("Verifying Minecraft session...");
                sessionService.joinServer(session.method_44717(), session.method_1674(), serverId);
                if (sessionService.hasJoinedServer(session.method_1676(), serverId, null) != null) {
                    AuthMe.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    AuthMe.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static MinecraftSessionService getSessionService() {
        return class_310.method_1551().method_73361().comp_837();
    }

    public static YggdrasilAuthenticationService getAuthService() {
        return class_310.method_1551().authme$getAuthService();
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

