/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.impl.fabric;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.axieum.mcmod.authme.api.AuthMe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class AuthMeFabric
implements ModInitializer {
    public void onInitialize() {
        AuthMeFabric.migrateConfig();
        AuthMe.init();
    }

    private static void migrateConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path oldConfig = configDir.resolve("authme.json5");
        Path newConfig = configDir.resolve("authme.jsonc");
        if (Files.exists(oldConfig, new LinkOption[0]) && Files.notExists(newConfig, new LinkOption[0])) {
            AuthMe.LOGGER.warn("Found old config file '{}', renaming to '{}'", (Object)oldConfig, (Object)newConfig);
            try {
                Files.move(oldConfig, newConfig, new CopyOption[0]);
            }
            catch (IOException e) {
                AuthMe.LOGGER.error("Could not migrate old config file to '{}'", (Object)newConfig, (Object)e);
            }
        }
    }
}

