/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.overlaystate;

import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.core.Compute;
import dev.schmarrn.lighty.overlaystate.State;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class SMACH {
    private static State state = State.OFF;

    public static void updateCompute() {
        Minecraft client = Minecraft.getInstance();
        if (!((Boolean)Config.SHOULD_AUTO_ON.getValue()).booleanValue()) {
            if (state == State.AUTO || state == State.OVERRIDE) {
                state = State.OFF;
                SMACH.whenSwitchingToOff();
            }
            return;
        }
        boolean holdsItem = false;
        List activationItems = (List)Config.AUTO_ON_ITEM_LIST.getValue();
        if (client.player == null) {
            return;
        }
        Item mainHandItem = client.player.getMainHandItem().getItem();
        Item offHandItem = client.player.getOffhandItem().getItem();
        for (ResourceLocation rl : activationItems) {
            Item activationItem = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(rl).get()).value();
            if (mainHandItem != activationItem && offHandItem != activationItem) continue;
            holdsItem = true;
            break;
        }
        switch (state) {
            case OFF: {
                if (!holdsItem) break;
                state = State.AUTO;
                break;
            }
            case ON: {
                break;
            }
            case AUTO: 
            case OVERRIDE: {
                if (holdsItem) break;
                state = State.OFF;
                SMACH.whenSwitchingToOff();
            }
        }
    }

    public static void toggle() {
        switch (state) {
            case OFF: {
                state = State.ON;
                break;
            }
            case ON: {
                state = State.OFF;
                SMACH.whenSwitchingToOff();
                break;
            }
            case AUTO: {
                state = State.OVERRIDE;
                break;
            }
            case OVERRIDE: {
                state = State.AUTO;
            }
        }
    }

    public static State getState() {
        return state;
    }

    public static boolean isEnabled() {
        return state == State.AUTO || state == State.ON;
    }

    private static void whenSwitchingToOff() {
        Compute.clear();
    }
}

