/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.renderers;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.core.LightyPipelines;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CarpetRenderer
implements OverlayRenderer {
    @Override
    public void build(ClientLevel level, BlockPos pos, OverlayData data, VertexConsumer builder, int lightmap) {
        float x = data.rPos().getX();
        float y = (float)(data.rPos().getY() + 1) + data.yOffset();
        float z = data.rPos().getZ();
        try {
            builder.addVertex(x, y + 0.0625f, z).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(x, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(0.0f, 1.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(x + 1.0f, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(1.0f, 1.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(x + 1.0f, y + 0.0625f, z).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
            if (data.yOffset() > 0.001f) {
                pos = pos.above();
            }
            if (Block.shouldRenderFace((BlockState)Blocks.STONE.defaultBlockState(), (BlockState)level.getBlockState(pos.relative(Direction.SOUTH)), (Direction)Direction.SOUTH)) {
                builder.addVertex(x, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(0.0f, 0.0625f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
                builder.addVertex(x, y, z + 1.0f).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
                builder.addVertex(x + 1.0f, y, z + 1.0f).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
                builder.addVertex(x + 1.0f, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(1.0f, 0.0625f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
            }
            if (Block.shouldRenderFace((BlockState)Blocks.STONE.defaultBlockState(), (BlockState)level.getBlockState(pos.relative(Direction.WEST)), (Direction)Direction.WEST)) {
                builder.addVertex(x, y + 0.0625f, z).setColor(data.color()).setUv(0.0f, 0.0625f).setLight(lightmap).setNormal(-1.0f, 0.0f, 0.0f);
                builder.addVertex(x, y, z).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(-1.0f, 0.0f, 0.0f);
                builder.addVertex(x, y, z + 1.0f).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(-1.0f, 0.0f, 0.0f);
                builder.addVertex(x, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(1.0f, 0.0625f).setLight(lightmap).setNormal(-1.0f, 0.0f, 0.0f);
            }
            if (Block.shouldRenderFace((BlockState)Blocks.STONE.defaultBlockState(), (BlockState)level.getBlockState(pos.relative(Direction.NORTH)), (Direction)Direction.NORTH)) {
                builder.addVertex(x + 1.0f, y + 0.0625f, z).setColor(data.color()).setUv(0.0f, 0.0625f).setLight(lightmap).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(x + 1.0f, y, z).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
                builder.addVertex(x, y, z).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
                builder.addVertex(x, y + 0.0625f, z).setColor(data.color()).setUv(1.0f, 0.0625f).setLight(lightmap).setNormal(0.0f, 0.0f, -1.0f);
            }
            if (Block.shouldRenderFace((BlockState)Blocks.STONE.defaultBlockState(), (BlockState)level.getBlockState(pos.relative(Direction.EAST)), (Direction)Direction.EAST)) {
                builder.addVertex(x + 1.0f, y + 0.0625f, z + 1.0f).setColor(data.color()).setUv(0.0f, 0.0625f).setLight(lightmap).setNormal(1.0f, 0.0f, 0.0f);
                builder.addVertex(x + 1.0f, y, z + 1.0f).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(1.0f, 0.0f, 0.0f);
                builder.addVertex(x + 1.0f, y, z).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(1.0f, 0.0f, 0.0f);
                builder.addVertex(x + 1.0f, y + 0.0625f, z).setColor(data.color()).setUv(1.0f, 0.0625f).setLight(lightmap).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RenderPipeline getPipeline() {
        return LightyPipelines.TERRAIN_TRANSLUCENT;
    }

    @Override
    public VertexFormat getVertexFormat() {
        return LightyPipelines.POSITION_COLOR_TEXTURE_LIGHT_NORMAL;
    }

    @Override
    public VertexFormat.Mode getVertexFormatMode() {
        return VertexFormat.Mode.QUADS;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)Config.CARPET_TEXTURE.getValue();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"renderer_carpet");
    }

    public static void init() {
        CarpetRenderer dp = new CarpetRenderer();
        ModeManager.registerRenderer(dp.getResourceLocation(), dp);
    }
}

