/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.fabric;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.Compute;
import dev.schmarrn.lighty.core.LightyRenderer;
import dev.schmarrn.lighty.event.KeyBind;
import dev.schmarrn.lighty.fabric.api.LightyModesRegistration;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;

public class LightyFabric
implements ClientModInitializer {
    private static RenderStateDataKey<Object2ObjectOpenHashMap<class_4076, BufferHolder>> DATA_KEY = RenderStateDataKey.create();

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(event -> {
            KeyBind.handleKeyBind(class_310.method_1551());
            SMACH.updateCompute();
        });
        WorldRenderEvents.END_EXTRACTION.register(t -> {
            Object2ObjectOpenHashMap<class_4076, BufferHolder> cache = Compute.computeCache(t.camera().method_19328(), (class_1937)t.world(), t.worldRenderer(), t.frustum());
            if (cache != null && !cache.isEmpty()) {
                t.worldState().setData(DATA_KEY, cache);
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            Object2ObjectOpenHashMap cache = (Object2ObjectOpenHashMap)context.worldState().getData(DATA_KEY);
            if (cache == null) {
                return;
            }
            class_243 camPos = context.worldState().field_63082.field_63078;
            ArrayList<RenderPass.class_10884<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.class_10884<GpuBufferSlice[]>>();
            ArrayList<class_11282.class_11283> transforms = new ArrayList<class_11282.class_11283>();
            int biggestBufferSize = 0;
            ObjectIterator cacheIterator = cache.object2ObjectEntrySet().fastIterator();
            while (cacheIterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
                class_4076 chunkSection = (class_4076)entry.getKey();
                BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
                Object2ObjectOpenHashMap<class_2960, class_10896> gpuBuffers = cachedBuffer.getGpuBuffers();
                ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
                while (bufferIterator.hasNext()) {
                    Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                    if (!cachedBuffer.isValid((class_2960)bufferEntry.getKey())) continue;
                    biggestBufferSize = LightyRenderer.addData(chunkSection, (class_10896)bufferEntry.getValue(), camPos, biggestBufferSize, drawList, transforms);
                }
            }
            GpuBufferSlice[] dynamicTransforms = RenderSystem.getDynamicUniforms().method_71107(transforms.toArray(new class_11282.class_11283[0]));
            LightyRenderer.DrawListData data = new LightyRenderer.DrawListData(drawList, biggestBufferSize, dynamicTransforms);
            LightyRenderer.render(data);
        });
        ClientTickEvents.END_CLIENT_TICK.register(KeyBind::handleKeyBind);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((minecraft, level) -> Compute.clear());
        Lighty.init();
        FabricLoader.getInstance().getEntrypoints("lightyModesRegistration", LightyModesRegistration.class).forEach(LightyModesRegistration::registerLightyModes);
        Lighty.postLoad();
    }
}

