/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.config;

import com.mojang.serialization.Codec;
import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.config.ConfigType;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class IntegerConfig
extends ConfigType<Integer> {
    private final int min;
    private final int max;

    @Override
    public OptionInstance<Integer> getOptionInstance() {
        return new OptionInstance(this.getTranslationKey(), object -> Tooltip.create((Component)Component.translatable((String)this.getTranslationTooltipKey(), (Object[])new Object[]{object})), (component, integer) -> Options.genericValueLabel((Component)component, (Component)Component.literal((String)integer.toString())), (OptionInstance.ValueSet)new OptionInstance.IntRange(this.min, this.max), Codec.intRange((int)this.min, (int)this.max), (Object)((Integer)this.getValue()), this::setValue);
    }

    public IntegerConfig(String key, Integer defaultValue, int min, int max) {
        super(key, defaultValue);
        this.min = min;
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public void setValue(Integer newValue) {
        if (newValue >= this.min && newValue <= this.max) {
            super.setValue(newValue);
        } else {
            Lighty.LOGGER.error("Lighty Config: {}, new value {} out of bounds: [{}, {}]. Ignoring new value.", new Object[]{this.getKey(), newValue, this.min, this.max});
        }
    }

    @Override
    String serialize() {
        return Integer.toString((Integer)this.getValue());
    }

    @Override
    void deserialize(String value) {
        this.setValue(Integer.valueOf(value));
    }
}

