/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import dev.schmarrn.lighty.Lighty;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.chunk.SectionBuffers;
import net.minecraft.resources.ResourceLocation;

public class BufferHolder
implements AutoCloseable {
    private final Object2ObjectOpenHashMap<ResourceLocation, SectionBuffers> overlayBuffers = new Object2ObjectOpenHashMap();
    private final Object2BooleanMap<ResourceLocation> isValid = new Object2BooleanOpenHashMap();
    private static final int BUFFER_TYPE_VERTEX = 40;
    private static final int BUFFER_TYPE_INDEX = 72;

    public boolean isValid(ResourceLocation key) {
        return this.isValid.getOrDefault((Object)key, false);
    }

    public void invalidateBuffer(ResourceLocation key) {
        this.isValid.put((Object)key, false);
    }

    @Override
    public void close() {
        this.overlayBuffers.values().forEach(SectionBuffers::close);
        this.overlayBuffers.clear();
    }

    void upload(MeshData data, ResourceLocation dataProviderKey) {
        if (data == null) {
            this.isValid.put((Object)dataProviderKey, false);
            return;
        }
        SectionBuffers previous = (SectionBuffers)this.overlayBuffers.get((Object)dataProviderKey);
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        if (previous != null) {
            if (previous.getVertexBuffer().size() < data.vertexBuffer().remaining()) {
                previous.getVertexBuffer().close();
                previous.setVertexBuffer(device.createBuffer(() -> "Lighty vertex buffer for " + String.valueOf(dataProviderKey), 40, data.vertexBuffer()));
            } else if (!previous.getVertexBuffer().isClosed()) {
                commandEncoder.writeToBuffer(previous.getVertexBuffer().slice(), data.vertexBuffer());
            } else {
                Lighty.LOGGER.info("I am curious whether this will ever trigger (BufferHolder::upload)");
            }
            ByteBuffer indexBuffer = data.indexBuffer();
            if (indexBuffer != null) {
                if (previous.getIndexBuffer() != null && previous.getIndexBuffer().size() >= indexBuffer.remaining()) {
                    if (!previous.getIndexBuffer().isClosed()) {
                        commandEncoder.writeToBuffer(previous.getIndexBuffer().slice(), indexBuffer);
                    }
                } else {
                    if (previous.getIndexBuffer() != null) {
                        previous.getIndexBuffer().close();
                    }
                    previous.setIndexBuffer(device.createBuffer(() -> "Lighty index buffer for" + String.valueOf(dataProviderKey), 72, indexBuffer));
                }
            } else if (previous.getIndexBuffer() != null) {
                previous.getIndexBuffer().close();
                previous.setIndexBuffer(null);
            }
            previous.setIndexCount(data.drawState().indexCount());
            previous.setIndexType(indexBuffer != null ? data.drawState().indexType() : null);
        } else {
            GpuBuffer vertexBuffer = device.createBuffer(() -> "Lighty vertex buffer for " + String.valueOf(dataProviderKey), 40, data.vertexBuffer());
            ByteBuffer indexBuffer = data.indexBuffer();
            GpuBuffer gpuIndexBuffer = indexBuffer != null ? device.createBuffer(() -> "Lighty index buffer for" + String.valueOf(dataProviderKey), 72, indexBuffer) : null;
            this.overlayBuffers.put((Object)dataProviderKey, (Object)new SectionBuffers(vertexBuffer, gpuIndexBuffer, data.drawState().indexCount(), gpuIndexBuffer != null ? data.drawState().indexType() : null));
        }
        data.close();
        this.isValid.put((Object)dataProviderKey, true);
    }

    public Object2ObjectOpenHashMap<ResourceLocation, SectionBuffers> getGpuBuffers() {
        return this.overlayBuffers;
    }
}

