/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.DataProviderRegistry;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;

public class Compute {
    private static SectionPos playerPos = SectionPos.of((int)0, (int)0, (int)0);
    private static final Object2ObjectOpenHashMap<SectionPos, BufferHolder> cachedBuffers = new Object2ObjectOpenHashMap();
    private static final TreeSet<SectionPos> toBeUpdated = new TreeSet<SectionPos>(Comparator.comparingDouble(self -> {
        int manhattanDistance = self.distManhattan((Vec3i)playerPos);
        double tieBreaker = (double)self.asLong() / 9.223372036854776E18;
        return (double)manhattanDistance + tieBreaker;
    }));
    static int computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)Minecraft.getInstance().options.renderDistance().get() + 1);

    private static boolean outOfRange(SectionPos sPos) {
        return Compute.outOfRange(sPos, playerPos);
    }

    public static boolean outOfRange(SectionPos one, SectionPos two) {
        int absX = Math.abs(one.x() - two.x());
        int absZ = Math.abs(one.z() - two.z());
        return absX > computationDistance || absZ > computationDistance;
    }

    public static void clear() {
        toBeUpdated.clear();
        cachedBuffers.values().forEach(BufferHolder::close);
        cachedBuffers.clear();
        computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)Minecraft.getInstance().options.renderDistance().get() + 1);
    }

    public static void updateBlockPos(BlockPos pos) {
        SectionPos sPos = SectionPos.of((BlockPos)pos);
        if (sPos.minBlockY() == pos.getY()) {
            Compute.updateSection(sPos.offset(0, -1, 0));
        }
        Compute.updateSection(sPos);
    }

    public static void updateSection(SectionPos sPos) {
        if (Compute.outOfRange(sPos) || !Minecraft.getInstance().levelRenderer.isSectionCompiled(sPos.origin())) {
            return;
        }
        toBeUpdated.add(sPos);
    }

    private static BufferHolder buildChunk(OverlayRenderer renderer, List<OverlayDataProvider> dataProviders, SectionPos sPos, ClientLevel level, BufferHolder buffer) {
        BlockPos sectionOrigin = sPos.origin();
        LevelChunk computationChunk = level.getChunkAt(sectionOrigin);
        for (OverlayDataProvider dataProvider : dataProviders) {
            ObjectArrayList dataList = null;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockPos pos = sectionOrigin.offset(x, y, z);
                        OverlayData data = dataProvider.compute(level, computationChunk, pos, new Vec3i(x, y, z));
                        if (!data.valid()) continue;
                        if (dataList == null) {
                            dataList = new ObjectArrayList(300);
                        }
                        dataList.add((Object)data);
                    }
                }
            }
            if (dataList == null) {
                buffer.invalidateBuffer(dataProvider.getResourceLocation());
                continue;
            }
            BufferBuilder builder = Tesselator.getInstance().begin(renderer.getVertexFormatMode(), renderer.getVertexFormat());
            int overlayBrightness = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            int lightmap = LightTexture.pack((int)overlayBrightness, (int)overlayBrightness);
            for (OverlayData data : dataList) {
                renderer.build(level, data.pos(), data, (VertexConsumer)builder, lightmap);
            }
            buffer.upload(builder.build(), dataProvider.getResourceLocation());
        }
        return buffer;
    }

    @Deprecated
    private static void queueNewChunksSlow(Level level, LevelRenderer levelRenderer) {
        Compute.queueNewChunksSlow(level, levelRenderer, null);
    }

    private static void queueNewChunksSlow(Level level, LevelRenderer levelRenderer, Frustum frustum) {
        for (int yy = level.getMinSectionY(); yy < level.getSectionsCount() + level.getMinSectionY(); ++yy) {
            for (int xx = -computationDistance; xx <= computationDistance; ++xx) {
                for (int zz = -computationDistance; zz <= computationDistance; ++zz) {
                    SectionPos chunkSection = SectionPos.of((int)(playerPos.x() + xx), (int)yy, (int)(playerPos.z() + zz));
                    BlockPos sectionOrigin = chunkSection.origin();
                    AABB chunkBoundaries = AABB.encapsulatingFullBlocks((BlockPos)sectionOrigin.offset(-1, -1, -1), (BlockPos)sectionOrigin.offset(16, 16, 16));
                    if (frustum != null && !frustum.isVisible(chunkBoundaries) || cachedBuffers.containsKey((Object)chunkSection) || !levelRenderer.isSectionCompiled(chunkSection.origin())) continue;
                    toBeUpdated.add(chunkSection);
                }
            }
        }
    }

    public static Object2ObjectOpenHashMap<SectionPos, BufferHolder> computeCache(BlockPos cameraPos, Level level, LevelRenderer levelRenderer, Frustum frustum) {
        SectionPos sectionPos;
        playerPos = SectionPos.of((BlockPos)cameraPos);
        if (!SMACH.isEnabled()) {
            return null;
        }
        Compute.queueNewChunksSlow(level, levelRenderer, frustum);
        List<OverlayDataProvider> dataProviders = DataProviderRegistry.getActiveProviders();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        ObjectIterator cacheIterator = cachedBuffers.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            if (!Compute.outOfRange((SectionPos)entry.getKey())) continue;
            ((BufferHolder)entry.getValue()).close();
            cacheIterator.remove();
        }
        int ii = level.getSectionsCount() * (Integer)Config.CHUNKS_PER_TICK.getValue();
        while (ii > 0 && (sectionPos = toBeUpdated.pollFirst()) != null) {
            if (Compute.outOfRange(sectionPos)) continue;
            --ii;
            cachedBuffers.compute((Object)sectionPos, (pos, bufferHolder) -> Compute.buildChunk(renderer, dataProviders, pos, (ClientLevel)level, bufferHolder != null ? bufferHolder : new BufferHolder()));
        }
        return cachedBuffers;
    }

    private Compute() {
    }
}

