/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.LightyPipelines;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.chunk.SectionBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LightyRenderer {
    private static final Vector4f UNIT_COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Matrix4f DEFAULT_TEXTURE_MATRIX = new Matrix4f();

    public static int addData(SectionPos chunkSection, SectionBuffers gpuBuffer, Vec3 camPos, int biggestBufferSize, List<RenderPass.Draw<GpuBufferSlice[]>> drawList, List<DynamicUniforms.Transform> transforms) {
        Vec3 origin = new Vec3((Vec3i)chunkSection.origin());
        Vec3 dPos = origin.subtract(camPos);
        if (gpuBuffer.getIndexBuffer() == null && gpuBuffer.getIndexCount() > biggestBufferSize) {
            biggestBufferSize = gpuBuffer.getIndexCount();
        }
        int currentTransformationIndex = transforms.size();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        modelViewMatrix.translate((float)dPos.x(), (float)dPos.y(), (float)dPos.z());
        transforms.add(new DynamicUniforms.Transform((Matrix4fc)modelViewMatrix, (Vector4fc)UNIT_COLOR_MODULATOR, (Vector3fc)new Vector3f(), (Matrix4fc)DEFAULT_TEXTURE_MATRIX, 1.0f));
        drawList.add((RenderPass.Draw<GpuBufferSlice[]>)new RenderPass.Draw(0, gpuBuffer.getVertexBuffer(), gpuBuffer.getIndexBuffer(), gpuBuffer.getIndexType(), 0, gpuBuffer.getIndexCount(), (bufferSlice, uniformUploader) -> uniformUploader.upload("DynamicTransforms", bufferSlice[currentTransformationIndex])));
        return biggestBufferSize;
    }

    private static int goThroughEachBuffer(Minecraft minecraft, Camera camera, Vec3 camPos, Frustum frustum, List<RenderPass.Draw<GpuBufferSlice[]>> drawList, List<DynamicUniforms.Transform> transforms, Object2ObjectOpenHashMap<SectionPos, BufferHolder> cache) {
        int biggestBufferSize = 0;
        ObjectIterator cacheIterator = cache.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            SectionPos chunkSection = (SectionPos)entry.getKey();
            BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
            Object2ObjectOpenHashMap<ResourceLocation, SectionBuffers> gpuBuffers = cachedBuffer.getGpuBuffers();
            ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
            while (bufferIterator.hasNext()) {
                Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                if (!cachedBuffer.isValid((ResourceLocation)bufferEntry.getKey())) continue;
                biggestBufferSize = LightyRenderer.addData(chunkSection, (SectionBuffers)bufferEntry.getValue(), camPos, biggestBufferSize, drawList, transforms);
            }
        }
        return biggestBufferSize;
    }

    private static DrawListData prepareData(Minecraft minecraft, Frustum frustum, Object2ObjectOpenHashMap<SectionPos, BufferHolder> cache) {
        Camera camera = minecraft.gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        ArrayList<RenderPass.Draw<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.Draw<GpuBufferSlice[]>>();
        ArrayList<DynamicUniforms.Transform> transforms = new ArrayList<DynamicUniforms.Transform>();
        int biggestBufferSize = LightyRenderer.goThroughEachBuffer(minecraft, camera, camPos, frustum, drawList, transforms, cache);
        GpuBufferSlice[] dynamicTransforms = RenderSystem.getDynamicUniforms().writeTransforms(transforms.toArray(new DynamicUniforms.Transform[0]));
        return new DrawListData(drawList, biggestBufferSize, dynamicTransforms);
    }

    public static void render(DrawListData data) {
        if (!SMACH.isEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        GpuDevice device = RenderSystem.getDevice();
        GpuTextureView tex = minecraft.getTextureManager().getTexture(renderer.getTextureLocation()).getTextureView();
        RenderPipeline pipeline = renderer.getPipeline();
        RenderTarget renderTarget = minecraft.getMainRenderTarget();
        RenderSystem.AutoStorageIndexBuffer asib = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        GpuBuffer baseIndexBuffer = data.maxIndicesRequired == 0 ? null : asib.getBuffer(data.maxIndicesRequired);
        VertexFormat.IndexType baseIndexType = data.maxIndicesRequired == 0 ? null : asib.type();
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(() -> "Lighty Render Pass for" + String.valueOf(pipeline.getLocation()), renderTarget.getColorTextureView(), OptionalInt.empty(), renderTarget.getDepthTextureView(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.bindSampler("Sampler2", minecraft.gameRenderer.lightTexture().getTextureView());
            pass.setPipeline(pipeline);
            pass.bindSampler("Sampler0", tex);
            pass.drawMultipleIndexed(pipeline == LightyPipelines.TERRAIN_TRANSLUCENT ? data.drawList.reversed() : data.drawList, baseIndexBuffer, baseIndexType, List.of("DynamicTransforms"), (Object)data.dynamicTransforms);
        }
    }

    public record DrawListData(List<RenderPass.Draw<GpuBufferSlice[]>> drawList, int maxIndicesRequired, GpuBufferSlice[] dynamicTransforms) {
    }
}

