/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.forge;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.Compute;
import dev.schmarrn.lighty.core.LightyRenderer;
import dev.schmarrn.lighty.event.KeyBind;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.chunk.SectionBuffers;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ExtractLevelRenderStateEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="lighty", dist={Dist.CLIENT})
public class LightyForge {
    private static final Logger log = LoggerFactory.getLogger(LightyForge.class);

    public LightyForge() {
        Lighty.init();
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="lighty")
    private static class ClassLoadingProtection2 {
        private static final ContextKey<Object2ObjectOpenHashMap<SectionPos, BufferHolder>> DATA_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"compute_cache"));

        private ClassLoadingProtection2() {
        }

        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post event) {
            KeyBind.handleKeyBind(Minecraft.getInstance());
            SMACH.updateCompute();
        }

        @SubscribeEvent
        public static void extractRenderState(ExtractLevelRenderStateEvent event) {
            Object2ObjectOpenHashMap<SectionPos, BufferHolder> cache = Compute.computeCache(event.getCamera().getBlockPosition(), (Level)event.getLevel(), event.getLevelRenderer(), event.getFrustum());
            if (cache != null && !cache.isEmpty()) {
                event.getRenderState().setRenderData(DATA_KEY, cache);
            }
        }

        @SubscribeEvent
        public static void render(RenderLevelStageEvent.AfterTripwireBlocks event) {
            Object2ObjectOpenHashMap cache = (Object2ObjectOpenHashMap)event.getLevelRenderState().getRenderData(DATA_KEY);
            if (cache == null) {
                return;
            }
            Vec3 camPos = event.getLevelRenderState().cameraRenderState.pos;
            ArrayList<RenderPass.Draw<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.Draw<GpuBufferSlice[]>>();
            ArrayList<DynamicUniforms.Transform> transforms = new ArrayList<DynamicUniforms.Transform>();
            int biggestBufferSize = 0;
            ObjectIterator cacheIterator = cache.object2ObjectEntrySet().fastIterator();
            while (cacheIterator.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
                SectionPos chunkSection = (SectionPos)entry.getKey();
                BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
                Object2ObjectOpenHashMap<ResourceLocation, SectionBuffers> gpuBuffers = cachedBuffer.getGpuBuffers();
                ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
                while (bufferIterator.hasNext()) {
                    Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                    if (!cachedBuffer.isValid((ResourceLocation)bufferEntry.getKey())) continue;
                    biggestBufferSize = LightyRenderer.addData(chunkSection, (SectionBuffers)bufferEntry.getValue(), camPos, biggestBufferSize, drawList, transforms);
                }
            }
            GpuBufferSlice[] dynamicTransforms = RenderSystem.getDynamicUniforms().writeTransforms(transforms.toArray(new DynamicUniforms.Transform[0]));
            LightyRenderer.DrawListData data = new LightyRenderer.DrawListData(drawList, biggestBufferSize, dynamicTransforms);
            LightyRenderer.render(data);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    private static class ClassLoadingProtection {
        private ClassLoadingProtection() {
        }

        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent event) {
            Lighty.postLoad();
        }

        @SubscribeEvent
        public static void Load(LevelEvent.Load event) {
            Compute.clear();
        }
    }
}

