/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.forge;

import dev.schmarrn.lighty.UtilDefinition;
import dev.schmarrn.lighty.core.LightyPipelines;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisProgram;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class UtilForgeImpl
implements UtilDefinition {
    private static final IrisApi IRIS;
    private static final List<KeyMapping> MAPPINGS;

    @Override
    public KeyMapping registerKeyBinding(KeyMapping mapping) {
        MAPPINGS.add(mapping);
        return mapping;
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean shadersEnabled() {
        return IRIS != null && IRIS.isShaderPackInUse();
    }

    @Override
    public void registerPipelinesWithIris() {
        if (IRIS != null) {
            IRIS.assignPipeline(LightyPipelines.TERRAIN_TRANSLUCENT, IrisProgram.TERRAIN_CUTOUT);
            IRIS.assignPipeline(LightyPipelines.TERRAIN_CUTOUT, IrisProgram.TERRAIN_CUTOUT);
            IRIS.assignPipeline(LightyPipelines.LINES, IrisProgram.LINES);
        }
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        MAPPINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    static {
        IrisApi i;
        try {
            i = (IrisApi)Class.forName("net.irisshaders.iris.apiimpl.IrisApiV0Impl").getField("INSTANCE").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException var1) {
            i = null;
        }
        IRIS = i;
        MAPPINGS = new ArrayList<KeyMapping>();
    }
}

