/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainLinkEntity;
import com.github.legoatoom.connectiblechains.entity.Chainable;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.item.ChainItemCallbacks;
import com.github.legoatoom.connectiblechains.networking.packet.ChainAttachS2CPacket;
import com.github.legoatoom.connectiblechains.tag.ModTagRegistry;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9691;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainKnotEntity
extends class_9691
implements Chainable,
ChainLinkEntity {
    private HashSet<Chainable.ChainData> chainDataSet = new HashSet();
    @NotNull
    private class_1792 sourceItem;

    protected ChainKnotEntity(class_1299<? extends class_9691> entityType, class_1937 world) {
        super(entityType, world);
        this.sourceItem = class_1802.field_23983;
    }

    public ChainKnotEntity(class_1937 world, class_2338 pos, @NotNull class_1792 sourceItem) {
        super(ModEntityTypes.CHAIN_KNOT, world, pos);
        this.sourceItem = sourceItem;
        this.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Nullable
    public static ChainKnotEntity getOrNull(class_1937 world, class_2338 pos) {
        List chainKnotEntities = world.method_18467(ChainKnotEntity.class, new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1014(1.0));
        for (ChainKnotEntity chainKnotEntity : chainKnotEntities) {
            if (!chainKnotEntity.method_59940().equals((Object)pos)) continue;
            return chainKnotEntity;
        }
        return null;
    }

    public static ChainKnotEntity getOrCreate(class_1937 world, class_2338 pos, @NotNull class_1792 newSourceItem) {
        ChainKnotEntity chainKnotEntity = ChainKnotEntity.getOrNull(world, pos);
        if (chainKnotEntity == null) {
            chainKnotEntity = new ChainKnotEntity(world, pos, newSourceItem);
            world.method_8649((class_1297)chainKnotEntity);
        }
        return chainKnotEntity;
    }

    @Override
    public HashSet<Chainable.ChainData> getChainDataSet() {
        return this.chainDataSet;
    }

    @Override
    public void replaceChainData(@Nullable Chainable.ChainData oldChainData, @Nullable Chainable.ChainData newChainData) {
        if (oldChainData != null && !this.chainDataSet.removeIf(chainData -> chainData.equals(oldChainData) || chainData.equals(newChainData))) {
            ConnectibleChains.LOGGER.warn("Attempted to remove {}, from {}. But it was not able to find it?", (Object)oldChainData, this.chainDataSet);
        }
        if (newChainData != null) {
            this.chainDataSet.add(newChainData);
        }
    }

    @Override
    public void setChainData(HashSet<Chainable.ChainData> chainDataSet) {
        this.chainDataSet = chainDataSet;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            Chainable.tickChain(serverWorld, this);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1937 class_19372;
        class_1799 handStack = player.method_5998(hand);
        if (this.method_37908().method_8608()) {
            Chainable.ChainData chainDataForPlayer = this.getChainData((class_1297)player);
            if (chainDataForPlayer != null) {
                if (!player.method_56992()) {
                    player.method_7270(new class_1799((class_1935)chainDataForPlayer.sourceItem));
                }
                return class_1269.field_5812;
            }
            if (handStack.method_31573(ModTagRegistry.CATENARY_ITEMS)) {
                handStack.method_57008(1, (class_1309)player);
                return class_1269.field_5812;
            }
            if (handStack.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        if (this.method_5805() && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            boolean hasConnectedFromPlayer = false;
            List<Chainable> list = ChainItemCallbacks.collectChainablesAround(this.method_37908(), this.method_59940(), entity -> entity.getChainData((class_1297)player) != null);
            for (Chainable chainable : list) {
                Chainable.ChainData chainData = chainable.getChainData((class_1297)player);
                if (chainData == null || !chainable.canAttachTo((class_1297)this)) continue;
                chainable.attachChain(new Chainable.ChainData((class_1297)this, chainData.sourceItem), (class_1297)player, true);
                hasConnectedFromPlayer = true;
            }
            if (hasConnectedFromPlayer) {
                this.onPlace();
                return class_1269.field_5812;
            }
            Chainable.ChainData matchingData = null;
            for (Chainable.ChainData chainData : new HashSet<Chainable.ChainData>(this.getChainDataSet())) {
                if (player != this.getChainHolder(chainData)) continue;
                matchingData = chainData;
                break;
            }
            if (matchingData != null) {
                this.detachChainWithoutDrop(matchingData);
                if (!player.method_56992()) {
                    player.method_7270(new class_1799((class_1935)matchingData.sourceItem));
                }
                this.method_32875((class_6880)class_5712.field_28725, (class_1297)player);
                return class_1269.field_5812;
            }
            if (handStack.method_31573(ModTagRegistry.CATENARY_ITEMS)) {
                this.onPlace();
                this.attachChain(new Chainable.ChainData((class_1297)player, handStack.method_7909()), null, true);
                handStack.method_57008(1, (class_1309)player);
                return class_1269.field_5812;
            }
            if (handStack.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
                ConnectibleChains.LOGGER.debug("Removing all connections due to player {} action on chain: {}", (Object)player, (Object)this);
                if (player.method_56992()) {
                    this.detachAllChainsWithoutDrop();
                } else {
                    this.detachAllChains();
                }
                this.method_5650(class_1297.class_5529.field_26999);
                this.method_6889((class_1297)player);
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_5698(class_1297 attacker) {
        if (!super.method_5698(attacker)) {
            this.method_5783(this.getSourceBlockSoundGroup().method_10596(), 0.5f, 1.0f);
        }
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236) {
            return false;
        }
        class_1269 result = this.onDamageFrom(source, this.getSourceBlockSoundGroup().method_10596());
        if (!result.method_23665()) {
            return false;
        }
        if (result == class_1269.field_5812) {
            ConnectibleChains.LOGGER.debug("Dropping all chains from knot ({}) due to receiving damage from source: {}", (Object)this, (Object)source);
            this.detachAllChains();
        }
        return super.method_5643(source, amount);
    }

    protected void method_30076() {
        super.method_30076();
        this.detachAllChainsWithoutDrop();
    }

    public void method_5652(class_2487 nbt) {
        this.writeChainDataSetToNbt(nbt, this.chainDataSet);
    }

    public void method_5749(class_2487 nbt) {
        this.readChainDataFromNbt(nbt);
    }

    protected void method_6895() {
        this.method_23327((double)this.field_51589.method_10263() + 0.5, (double)this.field_51589.method_10264() + 0.5, (double)this.field_51589.method_10260() + 0.5);
        double width = (double)this.method_5864().method_17685() / 2.0;
        double height = this.method_5864().method_17686();
        this.method_5857(new class_238(this.method_23317() - width, this.method_23318(), this.method_23321() - width, this.method_23317() + width, this.method_23318() + height, this.method_23321() + width));
    }

    public boolean method_5640(double distance) {
        if (this.method_37908().method_8320(this.method_59940()).method_26164(class_3481.field_15504)) {
            return false;
        }
        return distance < 1024.0;
    }

    public boolean method_6888() {
        return this.method_37908().method_8320(this.field_51589).method_26164(ModTagRegistry.CHAIN_CONNECTIBLE);
    }

    @Override
    public void onChainAttached(Chainable.ChainData newChainData) {
        this.method_5783(newChainData.getSourceBlockSoundGroup().method_10595(), 1.0f, 1.0f);
    }

    @Override
    @NotNull
    public class_1792 getSourceItem() {
        return this.sourceItem;
    }

    @Override
    public void setSourceItem(@NotNull class_1792 sourceItem) {
        this.sourceItem = sourceItem;
    }

    @Override
    public void onChainDetached(Chainable.ChainData removedChainData) {
        this.method_5783(removedChainData.getSourceBlockSoundGroup().method_10595(), 1.0f, 1.0f);
    }

    public void onPlace() {
        this.method_5783(this.getSourceBlockSoundGroup().method_10598(), 1.0f, 1.0f);
    }

    public void method_6889(@Nullable class_1297 breaker) {
        this.method_5783(this.getSourceBlockSoundGroup().method_10595(), 1.0f, 1.0f);
    }

    public void method_5837(class_3222 player) {
        for (Chainable.ChainData chainData : this.getChainDataSet()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ChainAttachS2CPacket((class_1297)this, null, this.getChainHolder(chainData), chainData.sourceItem));
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        int id = class_7923.field_41178.method_10206((Object)this.getSourceItem());
        return new class_2604((class_1297)this, id, this.method_59940());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        int rawChainItemSourceId = packet.method_11166();
        this.sourceItem = (class_1792)class_7923.field_41178.method_10200(rawChainItemSourceId);
    }

    public float method_5832(class_2470 rotation) {
        for (Chainable.ChainData chainData : this.chainDataSet) {
            chainData.applyRotation(rotation);
        }
        return super.method_5832(rotation);
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getSourceItem());
    }

    @Override
    public class_243 getChainPos(float delta) {
        return this.method_30950(delta).method_1031(0.0, 0.2, 0.0);
    }
}

