/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainModel;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;

public class ChainRenderer {
    private final Object2ObjectOpenHashMap<BakeKey, ChainModel> models = new Object2ObjectOpenHashMap(256);

    public void renderBaked(CatenaryRenderer renderer, class_4588 buffer, class_4587.class_4665 matricesEntry, BakeKey key, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model;
        if (this.models.containsKey((Object)key)) {
            model = (ChainModel)this.models.get((Object)key);
        } else {
            model = renderer.buildModel(chainVec);
            this.models.put((Object)key, (Object)model);
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && this.models.size() > 10000) {
            ConnectibleChains.LOGGER.error("Chain model leak found!");
        }
        model.render(buffer, matricesEntry, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    public void render(CatenaryRenderer renderer, class_4588 buffer, class_4587.class_4665 matricesEntry, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model = renderer.buildModel(chainVec);
        model.render(buffer, matricesEntry, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    public void purge() {
        this.models.clear();
    }

    public static class BakeKey {
        private final class_243 srcPos;
        private final class_243 dstPos;

        public BakeKey(class_243 srcPos, class_243 dstPos) {
            this.srcPos = srcPos;
            this.dstPos = dstPos;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BakeKey)) {
                return false;
            }
            BakeKey bakeKey = (BakeKey)o;
            return Objects.equals(this.srcPos, bakeKey.srcPos) && Objects.equals(this.dstPos, bakeKey.dstPos);
        }

        public int hashCode() {
            return Objects.hash(this.srcPos, this.dstPos);
        }
    }
}

