/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity.catenary;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainModel;
import com.github.legoatoom.connectiblechains.client.render.entity.UVRect;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryRenderer;
import com.github.legoatoom.connectiblechains.util.Helper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlussCatenaryRenderer
extends CatenaryRenderer {
    public PlussCatenaryRenderer(UVRect a, UVRect b) {
        super(a, b);
    }

    @Override
    public ChainModel buildModel(Vector3f chainVec) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        int initialCapacity = (int)(2.0f * chainVec.lengthSquared() / desiredSegmentLength);
        ChainModel.Builder builder = ChainModel.builder(initialCapacity);
        if (chainVec.x() == 0.0f && chainVec.z() == 0.0f) {
            this.buildFaceVertical(builder, chainVec, 0.0f, this.SIDE_A);
            this.buildFaceVertical(builder, chainVec, 90.0f, this.SIDE_B);
        } else {
            this.buildFace(builder, chainVec, 0.0f, this.SIDE_A);
            this.buildFace(builder, chainVec, 90.0f, this.SIDE_B);
        }
        return builder.build();
    }

    private void buildFaceVertical(ChainModel.Builder builder, Vector3f endPosition, float angle, UVRect uv) {
        endPosition.x = 0.0f;
        endPosition.z = 0.0f;
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        Vector3f normal = new Vector3f((float)Math.cos(Math.toRadians(angle)), 0.0f, (float)Math.sin(Math.toRadians(angle)));
        normal.normalize(chainWidth / 2.0f);
        Vector3f offset = new Vector3f(5.0E-5f, 0.0f, 5.0E-5f);
        offset = offset.rotateY(-angle);
        Vector3f vert00 = new Vector3f(-normal.x(), 0.0f, -normal.z());
        Vector3f vert01 = new Vector3f(normal.x(), 0.0f, normal.z());
        Vector3f vert10 = new Vector3f(-normal.x(), endPosition.y(), -normal.z());
        Vector3f vert11 = new Vector3f(normal.x(), endPosition.y(), normal.z());
        float uvv0 = 0.0f;
        float uvv1 = Math.abs(endPosition.y()) / 1.0f;
        builder.vertex(vert00.add((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv0).next();
        builder.vertex(vert01.add((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv0).next();
        builder.vertex(vert11.add((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv1).next();
        builder.vertex(vert10.add((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv1).next();
        builder.vertex(vert10.sub((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv1).next();
        builder.vertex(vert11.sub((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv1).next();
        builder.vertex(vert01.sub((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv0).next();
        builder.vertex(vert00.sub((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv0).next();
    }

    private void buildFace(ChainModel.Builder builder, Vector3f endPosition, float angle, UVRect uv) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float distance = endPosition.length();
        float distanceXZ = (float)Math.sqrt(Math.fma(endPosition.x(), endPosition.x(), endPosition.z() * endPosition.z()));
        float wrongDistanceFactor = distance / distanceXZ;
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        Vector3f normal = new Vector3f();
        Vector3f rotAxis = new Vector3f();
        Vector3f vert00 = new Vector3f();
        Vector3f vert01 = new Vector3f();
        Vector3f vert11 = new Vector3f();
        Vector3f vert10 = new Vector3f();
        Quaternionf rotator = new Quaternionf();
        Vector3f segmentStart = new Vector3f();
        Vector3f segmentEnd = new Vector3f();
        float uvv1 = 0.0f;
        float x = 0.0f;
        for (int segment = 0; segment < 2048; ++segment) {
            float gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, endPosition.y());
            x += this.estimateDeltaX(desiredSegmentLength, gradient);
            x = Math.min(x, distanceXZ);
            float y = (float)Helper.drip2(x * wrongDistanceFactor, distance, endPosition.y());
            segmentEnd.set(x, y, 0.0f);
            rotAxis.set(segmentEnd.x() - segmentStart.x(), segmentEnd.y() - segmentStart.y(), segmentEnd.z() - segmentStart.z());
            rotAxis.normalize();
            rotator = rotator.fromAxisAngleDeg((Vector3fc)rotAxis, angle);
            normal.set(-gradient, Math.abs(distanceXZ / distance), 0.0f);
            normal.normalize();
            normal.rotate((Quaternionfc)rotator);
            normal.normalize(chainWidth / 2.0f);
            if (segment == 0) {
                vert00.set((Vector3fc)segmentStart).sub((Vector3fc)normal);
                vert01.set((Vector3fc)segmentStart).add((Vector3fc)normal);
            } else {
                vert00.set((Vector3fc)vert10);
                vert01.set((Vector3fc)vert11);
            }
            vert10.set((Vector3fc)segmentEnd).sub((Vector3fc)normal);
            vert11.set((Vector3fc)segmentEnd).add((Vector3fc)normal);
            float actualSegmentLength = segmentStart.distance((Vector3fc)segmentEnd);
            float uvv0 = uvv1;
            uvv1 = uvv0 + actualSegmentLength / 1.0f;
            if (angle == 90.0f) {
                builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
                builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
                builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1).next();
                builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            } else {
                Vector3f offset = new Vector3f(0.0f, 0.0f, -5.0E-6f);
                builder.vertex(vert00.add((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv0).next();
                builder.vertex(vert01.add((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv0).next();
                builder.vertex(vert11.add((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv1).next();
                builder.vertex(vert10.add((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv1).next();
                builder.vertex(vert10.sub((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv1).next();
                builder.vertex(vert11.sub((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv1).next();
                builder.vertex(vert01.sub((Vector3fc)offset)).uv(uv.x1() / 16.0f, uvv0).next();
                builder.vertex(vert00.sub((Vector3fc)offset)).uv(uv.x0() / 16.0f, uvv0).next();
            }
            if (x >= distanceXZ) break;
            segmentStart.set((Vector3fc)segmentEnd);
        }
    }
}

