/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity.texture;

import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.client.render.entity.UVRect;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryModel;
import com.github.legoatoom.connectiblechains.client.render.entity.catenary.CatenaryRenderer;
import com.github.legoatoom.connectiblechains.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public class ChainModelReloader
extends class_4309<CatenaryModel> {
    private static final String MODEL_FILE_LOCATION = "models/entity/connectiblechains";
    private static final int EXPECTED_UNIQUE_CHAIN_COUNT = 64;
    public static final class_2960 DEFAULT_CATENARY = Helper.identifier("cross");
    public static final class_3545<UVRect, UVRect> DEFAULT_UV = new class_3545((Object)UVRect.DEFAULT_SIDE_A, (Object)UVRect.DEFAULT_SIDE_B);
    private Map<class_2960, CatenaryModel> models = new Object2ObjectOpenHashMap(64);

    public ChainModelReloader() {
        super(CatenaryModel.CODEC.codec(), class_7654.method_45114((String)MODEL_FILE_LOCATION));
    }

    protected void apply(Map<class_2960, CatenaryModel> prepared, class_3300 manager, class_3695 profiler) {
        this.clearCache();
        this.models = prepared;
    }

    public void clearCache() {
        ClientInitializer.getInstance().getChainKnotEntityRenderer().ifPresent(it -> it.getChainRenderer().purge());
    }

    @NotNull
    private static class_2960 defaultChainTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"block/%s".formatted(itemId.method_12832()));
    }

    @NotNull
    private static class_2960 defaultKnotTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"item/%s".formatted(itemId.method_12832()));
    }

    public CatenaryRenderer getCatenaryRenderer(class_2960 sourceItemId) {
        Optional<CatenaryModel> catenaryModel = Optional.ofNullable(this.models.get(sourceItemId));
        class_2960 catenaryId = catenaryModel.flatMap(CatenaryModel::catenaryRendererId).orElse(DEFAULT_CATENARY);
        class_3545<UVRect, UVRect> uvMappings = catenaryModel.flatMap(CatenaryModel::uvRects).orElse(DEFAULT_UV);
        return CatenaryRenderer.getRenderer(catenaryId, uvMappings);
    }

    public class_2960 getChainTexture(class_2960 sourceItemId) {
        return Optional.ofNullable(this.models.get(sourceItemId)).flatMap(CatenaryModel::textures).flatMap(CatenaryModel.CatenaryTextures::chainTexture).orElse(ChainModelReloader.defaultChainTextureId(sourceItemId)).method_45134(arg_0 -> ChainModelReloader.lambda$getChainTexture$1("textures/%s.png", arg_0));
    }

    public class_2960 getKnotTexture(class_2960 sourceItemId) {
        return Optional.ofNullable(this.models.get(sourceItemId)).flatMap(CatenaryModel::textures).flatMap(CatenaryModel.CatenaryTextures::knotTexture).orElse(ChainModelReloader.defaultKnotTextureId(sourceItemId)).method_45134(arg_0 -> ChainModelReloader.lambda$getKnotTexture$2("textures/%s.png", arg_0));
    }

    private static /* synthetic */ String lambda$getKnotTexture$2(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getChainTexture$1(String rec$, Object xva$0) {
        return "textures/%s.png".formatted(xva$0);
    }
}

