/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.migrator.ChainableMigrator;
import com.github.legoatoom.connectiblechains.networking.packet.ChainAttachS2CPacket;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1804;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.minecraft.class_9691;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Chainable {
    public static final String CHAINS_NBT_KEY;
    public static final String SOURCE_ITEM_KEY;

    public static double getMaxChainLength() {
        return ConnectibleChains.runtimeConfig.getMaxChainRange();
    }

    private static <E extends class_9691> void resolveChainDataSet(E entity, HashSet<ChainData> chainDataSet) {
        class_1937 class_19372 = entity.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (ChainData chainData : new HashSet<ChainData>(chainDataSet)) {
            Object chainHolder;
            if (chainData.unresolvedChainData == null) continue;
            Optional optionalUUID = chainData.unresolvedChainData.left();
            Optional optionalRelPos = chainData.unresolvedChainData.right();
            if (optionalUUID.isPresent()) {
                chainHolder = serverWorld.method_66347((UUID)optionalUUID.get());
                if (chainHolder != null) {
                    newChainData = new ChainData((class_1297)chainHolder, chainData.sourceItem);
                    ((Chainable)entity).replaceChainData(chainData, null);
                    Chainable.attachChain(entity, newChainData, null, true);
                    continue;
                }
            } else if (optionalRelPos.isPresent() && (chainHolder = ChainKnotEntity.getOrNull((class_1937)serverWorld, entity.method_59940().method_10081((class_2382)optionalRelPos.get()))) != null) {
                newChainData = new ChainData((class_1297)chainHolder, chainData.sourceItem);
                ((Chainable)entity).replaceChainData(chainData, null);
                Chainable.attachChain(entity, newChainData, null, true);
                continue;
            }
            if (entity.field_6012 <= 100) continue;
            ConnectibleChains.LOGGER.debug("Dropping chain connection as we have not been able to find chainholder for {}", (Object)chainData);
            entity.method_5706(serverWorld, (class_1935)chainData.sourceItem);
            ((Chainable)entity).replaceChainData(chainData, null);
        }
    }

    private static <E extends class_9691> void detachChain(E entity, ChainData chainData, boolean sendPacket, boolean dropItem) {
        if (chainData.chainHolder != null && chainData.isAlive()) {
            chainData.kill();
            ((Chainable)entity).replaceChainData(chainData, null);
            ((Chainable)entity).onChainDetached(chainData);
            class_1937 class_19372 = entity.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (dropItem) {
                    entity.method_5706(serverWorld, (class_1935)chainData.sourceItem);
                }
                if (sendPacket) {
                    serverWorld.method_14178().method_18754(entity, new ChainAttachS2CPacket((class_1297)entity, chainData.chainHolder, null, chainData.sourceItem).asPacket());
                }
                ChainCollisionEntity.destroyCollision(serverWorld, chainData);
            }
        }
    }

    private static <E extends class_9691> void attachChain(E entity, ChainData chainData, @Nullable class_1297 previousHolder, boolean sendPacket) {
        class_1937 class_19372;
        if (chainData.chainHolder == null) {
            throw new IllegalArgumentException("Given chainData has empty holder");
        }
        ((Chainable)entity).replaceChainData(((Chainable)entity).getChainData(previousHolder), chainData);
        ((Chainable)entity).onChainAttached(chainData);
        if (sendPacket && (class_19372 = entity.method_73183()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_18754(entity, new ChainAttachS2CPacket((class_1297)entity, previousHolder, chainData.chainHolder, chainData.sourceItem).asPacket());
            if (chainData.chainHolder instanceof Chainable) {
                ChainCollisionEntity.createCollision(entity, chainData);
            }
        }
    }

    public static <E extends class_9691> void tickChain(class_3218 world, E entity) {
        HashSet<ChainData> chainDataSet = ((Chainable)entity).getChainDataSet();
        Chainable.resolveChainDataSet(entity, chainDataSet);
        for (ChainData chainData : new HashSet<ChainData>(chainDataSet)) {
            float distanceTo;
            class_1297 chainHolder = ((Chainable)entity).getChainHolder(chainData);
            if (chainHolder == null) continue;
            if (entity.method_31481() || chainHolder.method_31481()) {
                class_1297.class_5529 reason;
                class_1297.class_5529 class_55292 = reason = entity.method_31481() ? entity.method_35049() : chainHolder.method_35049();
                if (!1.$assertionsDisabled && reason == null) {
                    throw new AssertionError();
                }
                if (reason.method_31486()) {
                    if (entity.method_31481()) {
                        ConnectibleChains.LOGGER.debug("Removing chain since chainReceiver ({}) is no longer alive, data: {}", entity, (Object)chainData);
                    } else {
                        ConnectibleChains.LOGGER.debug("Removing chain since chainHolder ({}) is no longer alive, data: {}", (Object)chainHolder, (Object)chainData);
                    }
                    if (world.method_64395().method_8355(class_1928.field_19393)) {
                        ((Chainable)entity).detachChain(chainData);
                    } else {
                        ((Chainable)entity).detachChainWithoutDrop(chainData);
                    }
                }
            }
            if ((chainHolder = ((Chainable)entity).getChainHolder(chainData)) == null || !chainHolder.method_73183().equals(entity.method_73183()) || !((Chainable)entity).beforeChainTick(chainHolder, distanceTo = entity.method_5739(chainHolder)) || !((double)distanceTo > Chainable.getMaxChainLength())) continue;
            ((Chainable)entity).breakLongChain(chainData);
        }
    }

    @Nullable
    private static <E extends class_9691> class_1297 getChainHolder(E entity, ChainData chainData) {
        class_1297 chainHolder;
        if (!((Chainable)entity).getChainDataSet().contains(chainData)) {
            return null;
        }
        if (chainData.unresolvedChainHolderId != 0 && entity.method_73183().method_8608() && (chainHolder = entity.method_73183().method_8469(chainData.unresolvedChainHolderId)) instanceof class_1297) {
            ((Chainable)entity).replaceChainData(chainData, new ChainData(chainHolder, chainData.sourceItem));
        }
        return chainData.chainHolder;
    }

    public static class_2498 getSourceBlockSoundGroup(class_1792 sourceItem) {
        class_1792 class_17922 = sourceItem;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1747.class, class_1804.class}, (Object)class_17922, n)) {
            case 0 -> {
                class_1747 blockItem = (class_1747)class_17922;
                yield blockItem.method_7711().method_9564().method_26231();
            }
            case 1 -> {
                class_1804 ignored = (class_1804)class_17922;
                yield new class_2498(1.0f, 1.0f, class_3417.field_60854, class_2498.field_11543.method_10594(), class_3417.field_60855, class_2498.field_11543.method_10596(), class_2498.field_11543.method_10593());
            }
            default -> class_2498.field_24119;
        };
    }

    default public boolean canAttachTo(class_1297 entity) {
        if (this == entity) {
            return false;
        }
        if (this.getChainData(entity) != null) {
            return false;
        }
        if (!(entity instanceof Chainable)) {
            return false;
        }
        Chainable chainable = (Chainable)entity;
        if (chainable.getChainData((class_1297)this) != null) {
            return false;
        }
        return this.getDistanceToCenter(entity) <= Chainable.getMaxChainLength();
    }

    default public double getDistanceToCenter(class_1297 entity) {
        return entity.method_5829().method_1005().method_1022(((class_1297)this).method_5829().method_1005());
    }

    public <E extends class_9691> ChainableMigrator<E> getDataMigrator();

    public HashSet<ChainData> getChainDataSet();

    public void replaceChainData(@Nullable ChainData var1, @Nullable ChainData var2);

    public void setChainData(HashSet<ChainData> var1);

    default public void addUnresolvedChainHolderId(int unresolvedOldChainHolderId, int unresolvedNewChainHolderId, class_1792 sourceItem) {
        ChainData oldChainData = null;
        ChainData newChainData = null;
        if (unresolvedOldChainHolderId != 0) {
            oldChainData = new ChainData(unresolvedOldChainHolderId, sourceItem);
        }
        if (unresolvedNewChainHolderId != 0) {
            newChainData = new ChainData(unresolvedNewChainHolderId, sourceItem);
        }
        this.replaceChainData(oldChainData, newChainData);
    }

    default public void readChainData(class_11368 view) {
        view = this.getDataMigrator().migrate(view, (class_9691)this);
        class_1792 source = view.method_71441(SOURCE_ITEM_KEY).map(sourceKey -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)sourceKey))).orElse(class_1802.field_23983);
        this.setSourceItem(source);
        HashSet<ChainData> chainData = Chainable.readChainDataSet(view);
        if (!this.getChainDataSet().isEmpty() && chainData.isEmpty()) {
            this.detachAllChainsWithoutDrop();
        }
        this.setChainData(chainData);
    }

    default public void writeChainData(class_11372 view, HashSet<ChainData> chainDataSet) {
        this.getDataMigrator().addVersionTag(view);
        view.method_71468(SOURCE_ITEM_KEY, class_7923.field_41178.method_39673(), (Object)this.getSourceItem());
        Chainable.writeChainDataSet((class_9691)this, chainDataSet, view);
    }

    private static <E extends class_9691> HashSet<ChainData> readChainDataSet(class_11368 view) {
        HashSet<ChainData> result = new HashSet<ChainData>();
        Optional optionalList = view.method_71436(CHAINS_NBT_KEY);
        if (optionalList.isPresent()) {
            class_11368.class_11370 list = (class_11368.class_11370)optionalList.get();
            for (class_11368 element : list) {
                class_1792 source = element.method_71426(SOURCE_ITEM_KEY, class_7923.field_41178.method_39673()).orElse(class_1802.field_23983);
                element.method_71426("UUID", class_4844.field_40825).ifPresent(uuid -> result.add(new ChainData((Either<UUID, class_2338>)Either.left((Object)uuid), source)));
                element.method_71426("RelativePos", class_2338.field_25064).ifPresent(vec3i -> result.add(new ChainData((Either<UUID, class_2338>)Either.right((Object)vec3i), source)));
            }
        }
        return result;
    }

    private static <E extends class_9691> void writeChainDataSet(E entity, HashSet<ChainData> chainDataSet, class_11372 writeView) {
        class_11372.class_11374 linksTag = writeView.method_71476(CHAINS_NBT_KEY);
        for (ChainData chainData : chainDataSet) {
            Either either;
            class_1297 class_12972 = chainData.chainHolder;
            if (class_12972 instanceof ChainKnotEntity) {
                ChainKnotEntity chainKnotEntity = (ChainKnotEntity)class_12972;
                either = Either.right((Object)chainKnotEntity.method_59940().method_10059((class_2382)entity.method_59940()));
            } else {
                either = chainData.chainHolder != null ? Either.left((Object)chainData.chainHolder.method_5667()) : chainData.unresolvedChainData;
            }
            if (either == null) continue;
            class_11372 tag = linksTag.method_71480();
            either.ifLeft(uuid -> tag.method_71468("UUID", class_4844.field_40825, uuid)).ifRight(relPos -> tag.method_71468("RelativePos", class_2338.field_25064, relPos));
            tag.method_71468(SOURCE_ITEM_KEY, class_7923.field_41178.method_39673(), (Object)chainData.sourceItem);
        }
    }

    default public void detachChain(ChainData chainData) {
        Chainable.detachChain((class_9691)this, chainData, true, true);
    }

    default public void detachChainWithoutDrop(ChainData chainData) {
        Chainable.detachChain((class_9691)this, chainData, true, false);
    }

    default public void detachAllChains() {
        for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
            this.detachChain(chainData);
        }
    }

    default public void detachAllChainsWithoutDrop() {
        for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
            this.detachChainWithoutDrop(chainData);
        }
    }

    default public void onChainDetached(ChainData removedChainData) {
    }

    default public boolean beforeChainTick(class_1297 chainHolder, float distance) {
        return true;
    }

    default public void breakLongChain(ChainData chainData) {
        ConnectibleChains.LOGGER.debug("Breaking chain as it is too long! {}", (Object)chainData);
        this.detachChain(chainData);
    }

    default public void attachChain(ChainData chainData, @Nullable class_1297 previousHolder, boolean sendPacket) {
        Chainable.attachChain((class_9691)this, chainData, previousHolder, sendPacket);
    }

    default public void onChainAttached(ChainData newChainData) {
    }

    @Nullable
    default public class_1297 getChainHolder(ChainData chainData) {
        return Chainable.getChainHolder((class_9691)this, chainData);
    }

    @Nullable
    default public ChainData getChainData(@Nullable class_1297 holder) {
        if (holder != null) {
            for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
                if (this.getChainHolder(chainData) != holder) continue;
                return chainData;
            }
        }
        return null;
    }

    public class_1792 getSourceItem();

    public void setSourceItem(class_1792 var1);

    default public class_2498 getSourceBlockSoundGroup() {
        return Chainable.getSourceBlockSoundGroup(this.getSourceItem());
    }

    public class_243 getChainPos(float var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CHAINS_NBT_KEY = "%s_Chains".formatted("connectiblechains");
        SOURCE_ITEM_KEY = "%s_SourceItem".formatted("connectiblechains");
    }

    public static final class ChainData {
        private boolean isDead = false;
        public final IntArrayList collisionStorage = new IntArrayList(16);
        @Nullable
        public Either<UUID, class_2338> unresolvedChainData;
        @NotNull
        public final class_1792 sourceItem;
        final int unresolvedChainHolderId;
        @Nullable
        private final class_1297 chainHolder;

        public ChainData(@Nullable Either<UUID, class_2338> unresolvedChainData, @NotNull class_1792 sourceItem) {
            this.unresolvedChainData = unresolvedChainData;
            this.sourceItem = sourceItem;
            this.chainHolder = null;
            this.unresolvedChainHolderId = 0;
        }

        public ChainData(@Nullable class_1297 chainHolder, @NotNull class_1792 sourceItem) {
            this.chainHolder = chainHolder;
            this.sourceItem = sourceItem;
            this.unresolvedChainData = null;
            this.unresolvedChainHolderId = 0;
        }

        public ChainData(int unresolvedChainHolderId, @NotNull class_1792 sourceItem) {
            this.unresolvedChainHolderId = unresolvedChainHolderId;
            this.sourceItem = sourceItem;
            this.chainHolder = null;
            this.unresolvedChainData = null;
        }

        public class_2498 getSourceBlockSoundGroup() {
            return Chainable.getSourceBlockSoundGroup(this.sourceItem);
        }

        private int getHolderId() {
            return this.chainHolder != null ? this.chainHolder.method_5628() : this.unresolvedChainHolderId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChainData)) {
                return false;
            }
            ChainData chainData = (ChainData)o;
            int thisId = this.getHolderId();
            int thatId = chainData.getHolderId();
            if (thisId != 0 && thisId == thatId) {
                return true;
            }
            return this.unresolvedChainData != null && this.unresolvedChainData.equals(chainData.unresolvedChainData);
        }

        public void kill() {
            if (this.isDead) {
                ConnectibleChains.LOGGER.warn("Stop! Stop! {} is already dead!", (Object)this);
            }
            this.isDead = true;
        }

        public boolean isAlive() {
            return !this.isDead;
        }

        public int hashCode() {
            return Objects.hash(this.getHolderId());
        }

        public void applyRotation(class_2470 rotation) {
            if (this.unresolvedChainData != null) {
                this.unresolvedChainData = this.unresolvedChainData.mapRight(blockPos -> blockPos.method_10070(rotation));
            }
        }

        public String toString() {
            return "ChainData{collisionStorage=" + String.valueOf(this.collisionStorage) + ", unresolvedChainData=" + String.valueOf(this.unresolvedChainData) + ", sourceItem=" + String.valueOf(this.sourceItem) + ", unresolvedChainHolderId=" + this.unresolvedChainHolderId + ", chainHolder=" + String.valueOf(this.chainHolder) + "}";
        }
    }
}

