/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.migrator;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.migrator.Migration;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public abstract class DataMigrator<Context extends class_1297> {
    private static final String DATA_VERSION_KEY = "connectiblechains_DataVersion";
    private final SortedMap<Integer, Migration<Context>> migrations = new TreeMap<Integer, Migration<Context>>();

    public DataMigrator() {
        this.registerMigrations();
    }

    public abstract void registerMigrations();

    public class_11368 migrate(class_11368 readView, Context context) {
        int version = readView.method_71424(DATA_VERSION_KEY, 0);
        class_11368 currentReadView = readView;
        try (class_8942.class_11340 logging = new class_8942.class_11340(context.method_71370(), ConnectibleChains.LOGGER);){
            for (Map.Entry<Integer, Migration<Context>> entry : this.migrations.entrySet()) {
                Integer migrationVersion = entry.getKey();
                Migration<Context> migration = entry.getValue();
                if (version >= migrationVersion) {
                    break;
                }
                class_11362 newWriteView = class_11362.method_71458((class_8942)logging);
                try {
                    migration.migrate(currentReadView, (class_11372)newWriteView, context);
                }
                catch (Exception e) {
                    ConnectibleChains.LOGGER.error("Error during fixing {} for '{}':", new Object[]{context, version, e});
                }
                currentReadView = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)context.method_56673(), (class_2487)newWriteView.method_71475());
            }
        }
        return currentReadView;
    }

    public void addVersionTag(class_11372 writeView) {
        writeView.method_71465(DATA_VERSION_KEY, this.getLatestVersion());
    }

    private int getLatestVersion() {
        return this.migrations.lastKey();
    }

    protected void registerMigration(int version, Migration<Context> migration) {
        if (!this.migrations.containsKey(version)) {
            this.migrations.put(version, migration);
        } else {
            ConnectibleChains.LOGGER.error("Version {} already registered!", (Object)version);
        }
    }
}

