/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.migrator.migrations;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.minecraft.class_9691;

public final class ChainToNewSystem {
    private static final String OLD_CHAINS_NBT_KEY = "Chains";
    private static final String NEW_CHAINS_NBT_KEY = "%s_%s".formatted("connectiblechains", "Chains");
    private static final String OLD_SOURCE_ITEM_KEY = "SourceItem";
    private static final String NEW_SOURCE_ITEM_KEY = "%s_%s".formatted("connectiblechains", "SourceItem");

    public static <E extends class_9691> void migrate(class_11368 readView, class_11372 writeView, E entity) {
        class_1792 knotSourceItem = readView.method_71441(OLD_SOURCE_ITEM_KEY).map(sourceKey -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)sourceKey))).orElse(class_1802.field_23983);
        writeView.method_71468(NEW_SOURCE_ITEM_KEY, class_7923.field_41178.method_39673(), (Object)knotSourceItem);
        Optional optionalList = readView.method_71436(OLD_CHAINS_NBT_KEY);
        optionalList.ifPresent(readViews -> {
            class_11372.class_11374 linksTag = writeView.method_71476(NEW_CHAINS_NBT_KEY);
            for (class_11368 element : (class_11368.class_11370)optionalList.get()) {
                class_11372 tag = linksTag.method_71480();
                ChainToNewSystem.migrateChainData(element, tag, entity);
            }
        });
    }

    private static <E extends class_9691> void migrateChainData(class_11368 readView, class_11372 writeView, E entity) {
        class_1792 source = readView.method_71441(OLD_SOURCE_ITEM_KEY).map(sourceKey -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)sourceKey))).orElse(class_1802.field_23983);
        writeView.method_71468(NEW_SOURCE_ITEM_KEY, class_7923.field_41178.method_39673(), (Object)source);
        Optional optionalUUID = readView.method_71441("UUID");
        Optional optionalDest = readView.method_71439("DestX");
        Optional optionalRel = readView.method_71439("RelX");
        if (optionalUUID.isPresent()) {
            UUID uuid = UUID.fromString((String)optionalUUID.get());
            writeView.method_71468("UUID", class_4844.field_40825, (Object)uuid);
        } else if (optionalDest.isPresent()) {
            Integer destX = (Integer)optionalDest.get();
            Integer destY = (Integer)readView.method_71439("DestY").get();
            Integer destZ = (Integer)readView.method_71439("DestZ").get();
            class_2338 desPos = new class_2338(destX.intValue(), destY.intValue(), destZ.intValue());
            class_2338 relPos = desPos.method_10059((class_2382)entity.method_59940());
            writeView.method_71468("RelativePos", class_2338.field_25064, (Object)relPos);
        } else if (optionalRel.isPresent()) {
            Integer relX = (Integer)optionalRel.get();
            Integer relY = (Integer)readView.method_71439("RelY").get();
            Integer relZ = (Integer)readView.method_71439("RelZ").get();
            writeView.method_71468("RelativePos", class_2338.field_25064, (Object)new class_2338(relX.intValue(), relY.intValue(), relZ.intValue()));
        }
    }
}

