/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import fi.dy.masa.tweakeroo.util.SnapAimUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(Minecraft mc, GuiGraphics drawContext) {
        LocalPlayer player = mc.player;
        if (player != null && mc.screen == null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            Font textRenderer = mc.font;
            Matrix4f modelViewMatrix = new Matrix4f();
            modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.bindTexture((ResourceLocation)AbstractContainerScreen.INVENTORY_LOCATION);
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54);
            drawContext.drawString(textRenderer, "1", x - 10, y + 4, 0xFFFFFF);
            drawContext.drawString(textRenderer, "2", x - 10, y + 22, 0xFFFFFF);
            drawContext.drawString(textRenderer, "3", x - 10, y + 40, 0xFFFFFF);
            for (int row = 1; row <= 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    ItemStack stack = player.getInventory().getItem(row * 9 + column);
                    if (!stack.isEmpty()) {
                        InventoryOverlay.renderStackAt((ItemStack)stack, (float)x, (float)y, (float)1.0f, (Minecraft)mc, (GuiGraphics)drawContext);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        }
    }

    public static void renderInventoryOverlay(InventoryOverlay.Context context, GuiGraphics drawContext) {
        Minecraft mc = Minecraft.getInstance();
        LivingEntity entityLivingBase = null;
        BlockEntity be = null;
        Container inv = null;
        CompoundTag nbt = new CompoundTag();
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof LivingEntity) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.merge(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof Wolf;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.getContainerSize() > 0) {
            Block block;
            boolean isHorse = entityLivingBase instanceof AbstractHorse;
            int totalSlots = isHorse ? inv.getContainerSize() - 1 : inv.getContainerSize();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType((Container)inv, (CompoundTag)nbt, (InventoryOverlay.Context)context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof CrafterBlockEntity) {
                    CrafterBlockEntity cbe = (CrafterBlockEntity)be;
                    lockedSlots = BlockUtils.getDisabledSlots((CrafterBlockEntity)cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt((CompoundTag)context.nbt());
                }
            }
            if (context.be() != null && (block = context.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)sbb, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
            if (isHorse) {
                SimpleContainer horseInv = new SimpleContainer(2);
                ItemStack horseArmor = ((AbstractHorse)entityLivingBase).getBodyArmorItem();
                horseInv.setItem(0, horseArmor != null && !horseArmor.isEmpty() ? horseArmor : ItemStack.EMPTY);
                horseInv.setItem(1, inv.getItem(0));
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc);
                InventoryOverlay.renderInventoryBackgroundSlots((InventoryOverlay.InventoryRenderType)type, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (GuiGraphics)drawContext);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (Minecraft)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, lockedSlots, (Minecraft)mc, (GuiGraphics)drawContext);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            SimpleContainer wolfInv = new SimpleContainer(2);
            ItemStack wolfArmor = ((Wolf)entityLivingBase).getBodyArmorItem();
            wolfInv.setItem(0, wolfArmor != null && !wolfArmor.isEmpty() ? wolfArmor : ItemStack.EMPTY);
            InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc);
            InventoryOverlay.renderWolfArmorBackgroundSlots((Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (GuiGraphics)drawContext);
            InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc, (GuiGraphics)drawContext);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (LivingEntity)entityLivingBase, (GuiGraphics)drawContext);
            InventoryOverlay.renderEquipmentStacks((LivingEntity)entityLivingBase, (int)x, (int)y, (Minecraft)mc, (GuiGraphics)drawContext);
        }
    }

    public static void renderPlayerInventoryOverlay(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        Inventory inv = mc.player.getInventory();
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (Minecraft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
    }

    public static void renderHotbarScrollOverlay(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        Inventory inv = mc.player.getInventory();
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (Minecraft)mc);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)(y + 70), (int)9, (int)9, (Minecraft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27, (Minecraft)mc, (GuiGraphics)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9, (Minecraft)mc, (GuiGraphics)drawContext);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float getLavaFogDistance(Entity entity, float originalFog) {
        LivingEntity living;
        ItemStack head;
        if (entity instanceof LivingEntity && !(head = (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.HEAD)).isEmpty()) {
            ItemEnchantments enchants = head.getEnchantments();
            float fog = originalFog > 1.0f ? 3.3f : 1.3f;
            int resp = 0;
            int aqua = 0;
            if (!enchants.equals((Object)ItemEnchantments.EMPTY)) {
                Set enchantList = enchants.keySet();
                for (Holder entry : enchantList) {
                    if (entry.is(Enchantments.AQUA_AFFINITY)) {
                        aqua = enchants.getLevel(entry);
                    }
                    if (!entry.is(Enchantments.RESPIRATION)) continue;
                    resp = enchants.getLevel(entry);
                }
            }
            if (aqua > 0) {
                fog *= 1.6f;
            }
            if (resp > 0) {
                fog *= (float)resp * 1.6f;
            }
            return Math.max(fog, originalFog);
        }
        return originalFog;
    }

    public static void renderDirectionsCursor(GuiGraphics drawContext) {
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        float width = (float)drawContext.guiWidth() / 2.0f;
        float height = (float)drawContext.guiHeight() / 2.0f;
        float pitch = camera.getXRot();
        float yaw = camera.getYRot();
        RenderSystem.enableBlend();
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)drawContext.pose().last().pose());
        matrix4fStack.translate(width, height, 0.0f);
        matrix4fStack.rotateX(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)(-pitch)));
        matrix4fStack.rotateY(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)yaw));
        matrix4fStack.scale(-1.0f, -1.0f, -1.0f);
        RenderSystem.renderCrosshair((int)10);
        matrix4fStack.popMatrix();
        RenderSystem.disableBlend();
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator(GuiGraphics drawContext) {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            Minecraft mc = Minecraft.getInstance();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(xCenter, yCenter, 80, 12, mc, drawContext);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(xCenter, yCenter, 12, 50, mc, drawContext);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(int xCenter, int yCenter, int width, int height, Minecraft mc, GuiGraphics drawContext) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = Mth.positiveModulo((double)SnapAimUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = SnapAimUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(Mth.wrapDegrees((double)(realYaw - startYaw)) / step * (double)width);
        Font textRenderer = mc.font;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        String str = Mth.wrapDegrees((double)snappedYaw) + "\u00b0";
        drawContext.drawString(textRenderer, str, xCenter - textRenderer.width(str) / 2, y + height + 2, -1, false);
        str = "<  " + Mth.wrapDegrees((double)(snappedYaw - step)) + "\u00b0";
        drawContext.drawString(textRenderer, str, x - textRenderer.width(str), y + height + 2, -1, false);
        str = Mth.wrapDegrees((double)(snappedYaw + step)) + "\u00b0  >";
        drawContext.drawString(textRenderer, str, x + width, y + height + 2, -1, false);
        if (Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue();
            int snapThreshOffset = (int)((double)width * threshold / step);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)(snapThreshOffset * 2), (int)height, (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter + snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
            }
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)lineX, (int)y, (int)2, (int)height, (int)-1);
    }

    private static void renderSnapAimAngleIndicatorPitch(int xCenter, int yCenter, int width, int height, Minecraft mc, GuiGraphics drawContext) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = Mth.wrapDegrees((double)SnapAimUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -SnapAimUtils.calculateSnappedAngle(-realPitch, step) : SnapAimUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = Mth.clamp((double)Mth.wrapDegrees((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(x, y, width, height, realPitch, snappedPitch, step, true, mc, drawContext);
    }

    public static void renderPitchLockIndicator(Minecraft mc, GuiGraphics drawContext) {
        if (mc.player == null) {
            return;
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 12;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = mc.player.getXRot();
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(x, y, width, height, currentPitch, centerPitch, indicatorRange, false, mc, drawContext);
    }

    private static void renderPitchIndicator(int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange, Minecraft mc, GuiGraphics drawContext) {
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((Mth.wrapDegrees((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font textRenderer = mc.font;
        if (isSnapRange) {
            String strUp = String.format("%6.1f\u00b0 ^", Mth.wrapDegrees((double)angleUp));
            String strDown = String.format("%6.1f\u00b0 v", Mth.wrapDegrees((double)angleDown));
            drawContext.drawString(textRenderer, strUp, x + width + 4, y - 4, -1, false);
            drawContext.drawString(textRenderer, strDown, x + width + 4, y + height - 4, -1, false);
            String str = String.format("%6.1f\u00b0", Mth.wrapDegrees((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.drawString(textRenderer, str, x + width + 4, y + height / 2 - 4, -1, false);
        } else {
            String str = String.format("%4.1f\u00b0", Mth.wrapDegrees((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.drawString(textRenderer, str, x + width + 4, lineY - 4, -1, false);
        }
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        int yCenter = y + height / 2 - 1;
        if (isSnapRange && Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue();
            int snapThreshOffset = (int)((double)height * threshold / indicatorRange);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)(snapThreshOffset * 2), (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)2, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter + snapThreshOffset), (int)width, (int)2, (int)-14614752);
            }
        } else if (!isSnapRange) {
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(x + 1), (int)(yCenter - 1), (int)(width - 2), (int)2, (int)-4144960);
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(lineY - 1), (int)width, (int)2, (int)-1);
    }

    public static void renderBlockOutline(BlockPos pos, float expand, float lineWidth, Color4f color, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, color, expand, buffer, mc);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - expand);
        float minY = (float)((double)pos.getY() - dy - expand);
        float minZ = (float)((double)pos.getZ() - dz - expand);
        float maxX = (float)((double)pos.getX() - dx + expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + expand + 1.0);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawConnectingLineBatchedLines(BlockPos pos1, BlockPos pos2, boolean center, Color4f color, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float x1 = (float)((double)pos1.getX() - dx);
        float y1 = (float)((double)pos1.getY() - dy);
        float z1 = (float)((double)pos1.getZ() - dz);
        float x2 = (float)((double)pos2.getX() - dx);
        float y2 = (float)((double)pos2.getY() - dy);
        float z2 = (float)((double)pos2.getZ() - dz);
        if (center) {
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
            x2 += 0.5f;
            y2 += 0.5f;
            z2 += 0.5f;
        }
        buffer.addVertex(x1, y1, z1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x2, y2, z2).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderBlockOutlineOverlapping(BlockPos pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float minX = (float)((double)pos.getX() - dx - (double)expand);
        float minY = (float)((double)pos.getY() - dy - (double)expand);
        float minZ = (float)((double)pos.getZ() - dz - (double)expand);
        float maxX = (float)((double)pos.getX() - dx + (double)expand + 1.0);
        float maxY = (float)((double)pos.getY() - dy + (double)expand + 1.0);
        float maxZ = (float)((double)pos.getZ() - dz + (double)expand + 1.0);
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, minZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color1.r, color1.g, color1.b, color1.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color2.r, color2.g, color2.b, color2.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color3.r, color3.g, color3.b, color3.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color3.r, color3.g, color3.b, color3.a);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderAreaOutline(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        RenderSystem.lineWidth((float)lineWidth);
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz;
        double maxX = (double)Math.max(pos1.getX(), pos2.getX()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.getY(), pos2.getY()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.getZ(), pos2.getZ()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.drawBoundingBoxLinesX(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawBoundingBoxLinesX(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesY(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesZ(BufferBuilder buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderAreaSides(BlockPos pos1, BlockPos pos2, Color4f color, Matrix4f matrix4f, Minecraft mc) {
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer, mc);
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void renderAreaSidesBatched(BlockPos pos1, BlockPos pos2, Color4f color, double expand, BufferBuilder buffer, Minecraft mc) {
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        double minX = (double)Math.min(pos1.getX(), pos2.getX()) - dx - expand;
        double minY = (double)Math.min(pos1.getY(), pos2.getY()) - dy - expand;
        double minZ = (double)Math.min(pos1.getZ(), pos2.getZ()) - dz - expand;
        double maxX = (double)(Math.max(pos1.getX(), pos2.getX()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.getY(), pos2.getY()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.getZ(), pos2.getZ()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (BufferBuilder)buffer);
    }

    public static void renderAreaOutlineNoCorners(BlockPos pos1, BlockPos pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, Minecraft mc) {
        int end;
        int xMin = Math.min(pos1.getX(), pos2.getX());
        int yMin = Math.min(pos1.getY(), pos2.getY());
        int zMin = Math.min(pos1.getZ(), pos2.getZ());
        int xMax = Math.max(pos1.getX(), pos2.getX());
        int yMax = Math.max(pos1.getY(), pos2.getY());
        int zMax = Math.max(pos1.getZ(), pos2.getZ());
        double expand = 0.001;
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        double dx = cameraPos.x;
        double dy = cameraPos.y;
        double dz = cameraPos.z;
        float dxMin = (float)(-dx - 0.001);
        float dyMin = (float)(-dy - 0.001);
        float dzMin = (float)(-dz - 0.001);
        float dxMax = (float)(-dx + 0.001);
        float dyMax = (float)(-dy + 0.001);
        float dzMax = (float)(-dz + 0.001);
        float minX = (float)xMin + dxMin;
        float minY = (float)yMin + dyMin;
        float minZ = (float)zMin + dzMin;
        float maxX = (float)xMax + dxMax;
        float maxY = (float)yMax + dyMax;
        float maxZ = (float)zMax + dzMax;
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        int start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, minZ).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, minY, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.addVertex((float)start + dxMin, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.addVertex((float)end + dxMax, maxY + 1.0f, maxZ + 1.0f).setColor(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, minZ).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(minX, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(minX, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, (float)start + dyMin, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.addVertex(maxX + 1.0f, (float)end + dyMax, maxZ + 1.0f).setColor(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.getX() == xMin && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.getX() == xMax && pos1.getY() == yMin && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMin && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, minY, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, minY, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.getX() == xMin && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMin && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(minX, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(minX, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMin || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.getX() == xMax && pos1.getY() == yMax && pos1.getZ() == zMax || pos2.getX() == xMax && pos2.getY() == yMax && pos2.getZ() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)start + dzMin).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.addVertex(maxX + 1.0f, maxY + 1.0f, (float)end + dzMax).setColor(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        try {
            MeshData meshData = buffer.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

