/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import fi.dy.masa.malilib.data.CachedBlockTags;
import fi.dy.masa.malilib.data.CachedTagKey;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CachedTagManager {
    public static final CachedTagKey SILK_TOUCH_OVERRIDE_KEY = new CachedTagKey("tweakeroo", "silk_touch_override");
    public static final CachedTagKey NEEDS_SHEARS_KEY = new CachedTagKey("tweakeroo", "needs_shears");
    public static final CachedTagKey NEEDS_SILK_TOUCH_KEY = new CachedTagKey("tweakeroo", "needs_silk_touch");
    public static final CachedTagKey ORE_BLOCKS_KEY = new CachedTagKey("tweakeroo", "ore_blocks");

    public static void startCache() {
        CachedTagManager.clearCache();
        CachedBlockTags.getInstance().build(NEEDS_SHEARS_KEY, CachedTagManager.buildNeedsShearsCache());
        CachedBlockTags.getInstance().build(NEEDS_SILK_TOUCH_KEY, CachedTagManager.buildNeedsSilkTouchCache());
        CachedBlockTags.getInstance().build(ORE_BLOCKS_KEY, CachedTagManager.buildOreBlocksCache());
    }

    private static List<String> buildNeedsShearsCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + BlockTags.LEAVES.location().toString());
        list.add("#" + BlockTags.WOOL.location().toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CAVE_VINES).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CAVE_VINES_PLANT).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.COBWEB).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_BUSH).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.FERN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GLOW_LICHEN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.HANGING_ROOTS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LARGE_FERN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_SPROUTS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PALE_HANGING_MOSS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SHORT_GRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SHORT_DRY_GRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SEAGRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TALL_GRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TALL_DRY_GRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TALL_SEAGRASS).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TRIPWIRE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TWISTING_VINES).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TWISTING_VINES_PLANT).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WEEPING_VINES).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WEEPING_VINES_PLANT).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.VINE).toString());
        return list;
    }

    private static List<String> buildNeedsSilkTouchCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + BlockTags.IMPERMEABLE.location().toString());
        list.add("#" + BlockTags.LEAVES.location().toString());
        list.add("#" + BlockTags.CORALS.location().toString());
        list.add("#" + BlockTags.WALL_CORALS.location().toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLACK_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLUE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BROWN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CYAN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GRAY_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GREEN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_BLUE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_GRAY_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIME_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.MAGENTA_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ORANGE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PINK_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PURPLE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.RED_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.YELLOW_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CALIBRATED_SCULK_SENSOR).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_CATALYST).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_SENSOR).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_SHRIEKER).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_VEIN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BEEHIVE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BEE_NEST).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BOOKSHELF).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLUE_ICE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BUSH).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CAMPFIRE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CHISELED_BOOKSHELF).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ENDER_CHEST).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ICE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PACKED_ICE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SOUL_CAMPFIRE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TURTLE_EGG).toString());
        return list;
    }

    private static List<String> buildOreBlocksCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + BlockTags.COAL_ORES.location().toString());
        list.add("#" + BlockTags.COPPER_ORES.location().toString());
        list.add("#" + BlockTags.DIAMOND_ORES.location().toString());
        list.add("#" + BlockTags.EMERALD_ORES.location().toString());
        list.add("#" + BlockTags.GOLD_ORES.location().toString());
        list.add("#" + BlockTags.IRON_ORES.location().toString());
        list.add("#" + BlockTags.LAPIS_ORES.location().toString());
        list.add("#" + BlockTags.REDSTONE_ORES.location().toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_QUARTZ_ORE).toString());
        return list;
    }

    public static void parseSilkTouchOverride(List<String> configStrs) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (configStrs.isEmpty()) {
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_OVERRIDE.getBooleanValue()) {
                Tweakeroo.LOGGER.error("parseSilkTouchOverride: Config List '{}' is empty.", (Object)Configs.Lists.SILK_TOUCH_OVERRIDE.getName());
            }
            return;
        }
        CachedBlockTags.getInstance().clearEntry(SILK_TOUCH_OVERRIDE_KEY);
        CachedBlockTags.getInstance().build(SILK_TOUCH_OVERRIDE_KEY, configStrs);
    }

    private static void clearCache() {
        CachedBlockTags.getInstance().clearEntry(SILK_TOUCH_OVERRIDE_KEY);
        CachedBlockTags.getInstance().clearEntry(NEEDS_SHEARS_KEY);
        CachedBlockTags.getInstance().clearEntry(NEEDS_SILK_TOUCH_KEY);
        CachedBlockTags.getInstance().clearEntry(ORE_BLOCKS_KEY);
    }

    public static boolean isNeedsShears(BlockState state) {
        return CachedBlockTags.getInstance().match(NEEDS_SHEARS_KEY, state);
    }

    public static boolean isNeedsSilkTouch(BlockState state) {
        return CachedBlockTags.getInstance().match(NEEDS_SILK_TOUCH_KEY, state);
    }

    public static boolean isOreBlock(BlockState state) {
        return CachedBlockTags.getInstance().match(ORE_BLOCKS_KEY, state);
    }

    public static boolean isSilkTouchOverride(BlockState state) {
        return CachedBlockTags.getInstance().match(SILK_TOUCH_OVERRIDE_KEY, state);
    }
}

