/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.item;

import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract DataComponentMap getComponents();

    @Inject(method={"getMaxStackSize()I"}, at={@At(value="RETURN")}, cancellable=true)
    public void tweakeroo_getMaxStackSizeStackSensitive(CallbackInfoReturnable<Integer> cir) {
        BlockItem block;
        Item item;
        if (FeatureToggle.TWEAK_SHULKERBOX_STACKING.getBooleanValue() && (item = this.getItem()) instanceof BlockItem && (block = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock && !InventoryUtils.shulkerBoxHasItems((ItemStack)((ItemStack)this)) && (Integer)this.getComponents().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1) < Configs.Internal.SHULKER_MAX_STACK_SIZE.getIntegerValue()) {
            cir.setReturnValue((Object)Configs.Internal.SHULKER_MAX_STACK_SIZE.getIntegerValue());
        }
    }

    @Inject(method={"addToTooltip(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/item/component/TooltipDisplay;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private <T> void tweakeroo_removeVanillaTooltip(DataComponentType<T> componentType, Item.TooltipContext context, TooltipDisplay displayComponent, Consumer<Component> textConsumer, TooltipFlag type, CallbackInfo ci) {
        BlockItem block;
        Item item = this.getItem();
        if (item instanceof BlockItem && (block = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock && componentType == DataComponents.CONTAINER && Configs.Disable.DISABLE_SHULKER_BOX_TOOLTIP.getBooleanValue()) {
            ci.cancel();
        }
    }
}

