/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.network;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.MiscTweaks;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MixinClientPlayerInteractionManager {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int destroyDelay;

    @Shadow
    public abstract InteractionResult useItemOn(LocalPlayer var1, InteractionHand var2, BlockHitResult var3);

    @Inject(method={"useItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;ensureHasSentCarriedItem()V")}, cancellable=true)
    private void tweakeroo_onProcessRightClickFirst(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
        }
    }

    @Inject(method={"useItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="TAIL")})
    private void tweakeroo_onProcessRightClickPost(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (((InteractionResult)cir.getReturnValue()).consumesAction()) {
            PlacementTweaks.onProcessRightClickPost(player, hand);
        }
    }

    @Inject(method={"interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onRightClickMouseOnEntityPre1(Player player, Entity target, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }

    @Inject(method={"interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/EntityHitResult;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_onRightClickMouseOnEntityPre2(Player player, Entity target, EntityHitResult trace, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (CameraUtils.shouldPreventPlayerInputs() || PlacementTweaks.onProcessRightClickPre(player, hand)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_preventEntityAttacksInFreeCameraMode(Player player, Entity target, CallbackInfo ci) {
        if (CameraUtils.shouldPreventPlayerInputs()) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_ENTITY_TYPE_ATTACK_RESTRICTION.getBooleanValue() && !MiscTweaks.isEntityAllowedByAttackingRestriction(target.getType())) {
            ci.cancel();
        } else if (FeatureToggle.TWEAK_WEAPON_SWITCH.getBooleanValue()) {
            InventoryUtils.trySwitchToWeapon(target);
        }
    }

    @Inject(method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=2)})
    private void tweakeroo_onClickBlockPre(BlockPos pos, Direction face, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecraft.player != null && this.minecraft.level != null) {
            if (FeatureToggle.TWEAK_TOOL_SWITCH.getBooleanValue()) {
                InventoryUtils.trySwitchToEffectiveTool(pos);
            }
            PlacementTweaks.cacheStackInHand(InteractionHand.MAIN_HAND);
        }
    }

    @Inject(method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_handleBreakingRestriction1(BlockPos pos, Direction side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)false);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V")})
    private void tweakeroo_handleBreakReplaceInAttack(BlockPos targetPos, Direction side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_BREAK_REPLACE.getBooleanValue() && this.minecraft.level != null && this.minecraft.player != null && this.minecraft.level.getBlockState(targetPos).isAir()) {
            BlockHitResult blockHitResult = new BlockHitResult(targetPos.getCenter(), side, targetPos, false);
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = this.minecraft.player.getItemInHand(hand);
                if (stack == null || !(stack.getItem() instanceof BlockItem) || !this.useItemOn(this.minecraft.player, hand, blockHitResult).consumesAction()) continue;
                if (!this.minecraft.player.getAbilities().instabuild) {
                    this.destroyDelay = 1;
                }
                return;
            }
        }
    }

    @Inject(method={"continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V")})
    private void tweakeroo_handleBreakReplaceInUpdate(BlockPos targetPos, Direction side, CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_BREAK_REPLACE.getBooleanValue() && this.minecraft.level != null && this.minecraft.player != null && this.minecraft.level.getBlockState(targetPos).isAir()) {
            BlockHitResult blockHitResult = new BlockHitResult(targetPos.getCenter(), side, targetPos, false);
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = this.minecraft.player.getItemInHand(hand);
                if (stack == null || !(stack.getItem() instanceof BlockItem) || !this.useItemOn(this.minecraft.player, hand, blockHitResult).consumesAction()) continue;
                return;
            }
        }
    }

    @Inject(method={"continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_handleBreakingRestriction2(BlockPos pos, Direction side, CallbackInfoReturnable<Boolean> cir) {
        if (Configs.Disable.DISABLE_BLOCK_BREAK_COOLDOWN.getBooleanValue()) {
            this.destroyDelay = 0;
        }
        if (FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue() || CameraUtils.shouldPreventPlayerInputs() || !PlacementTweaks.isPositionAllowedByBreakingRestriction(pos, side)) {
            cir.setReturnValue((Object)true);
        } else {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        }
    }

    @Inject(method={"hasMissTime()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void tweakeroo_overrideLimitedAttackSpeed(CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_FAST_LEFT_CLICK.getBooleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }
}

