/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.entity;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.DummyMovementInput;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class MixinClientPlayerEntity
extends AbstractClientPlayer {
    @Shadow
    public Input input;
    @Shadow
    protected int sprintTriggerTime;
    @Shadow
    public float oSpinningEffectIntensity;
    @Shadow
    public float spinningEffectIntensity;
    @Shadow
    private boolean wasFallFlying;
    @Unique
    private final DummyMovementInput dummyMovementInput = new DummyMovementInput(null);
    @Unique
    private Input realInput;
    @Unique
    private float realNauseaIntensity;
    @Unique
    private ItemStack autoSwitchElytraChestplate = ItemStack.EMPTY;

    private MixinClientPlayerEntity(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Redirect(method={"handleConfusionTransitionEffect(Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;isPauseScreen()Z"))
    private boolean onDoesGuiPauseGame(Screen gui) {
        if (Configs.Disable.DISABLE_PORTAL_GUI_CLOSING.getBooleanValue()) {
            return true;
        }
        return gui.isPauseScreen();
    }

    @Inject(method={"handleConfusionTransitionEffect(Z)V"}, at={@At(value="HEAD")})
    private void disableNauseaEffectPre(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_NAUSEA_EFFECT.getBooleanValue()) {
            this.spinningEffectIntensity = this.realNauseaIntensity;
        }
    }

    @Inject(method={"handleConfusionTransitionEffect(Z)V"}, at={@At(value="TAIL")})
    private void disableNauseaEffectPost(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_NAUSEA_EFFECT.getBooleanValue()) {
            this.realNauseaIntensity = this.spinningEffectIntensity;
            this.oSpinningEffectIntensity = 0.0f;
            this.spinningEffectIntensity = 0.0f;
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;wasFallFlying:Z")})
    private void overrideSprint(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_PERMANENT_SPRINT.getBooleanValue() && !this.isSprinting() && !this.isUsingItem() && this.input.forwardImpulse >= 0.8f && ((float)this.getFoodData().getFoodLevel() > 6.0f || this.getAbilities().mayfly) && !this.hasEffect(MobEffects.BLINDNESS) && !this.isInWater()) {
            this.setSprinting(true);
        }
    }

    @Redirect(method={"aiStep()V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;horizontalCollision:Z"))
    private boolean overrideCollidedHorizontally(LocalPlayer player) {
        if (Configs.Disable.DISABLE_WALL_UNSPRINT.getBooleanValue()) {
            return false;
        }
        return player.horizontalCollision;
    }

    @Inject(method={"aiStep()V"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/Options;keySprint:Lnet/minecraft/client/KeyMapping;"))}, at={@At(value="FIELD", opcode=181, ordinal=0, shift=At.Shift.AFTER, target="Lnet/minecraft/client/player/LocalPlayer;sprintTriggerTime:I")})
    private void disableDoubleTapSprint(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_DOUBLE_TAP_SPRINT.getBooleanValue()) {
            this.sprintTriggerTime = 0;
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/player/LocalPlayer;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private void onFallFlyingCheckChestSlot(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_AUTO_SWITCH_ELYTRA.getBooleanValue()) {
            if (!(this.onGround() || this.isFallFlying() || this.isInLiquid() || this.hasEffect(MobEffects.LEVITATION) || this.getItemBySlot(EquipmentSlot.CHEST).is(Items.ELYTRA) && this.getItemBySlot(EquipmentSlot.CHEST).getDamageValue() <= this.getItemBySlot(EquipmentSlot.CHEST).getMaxDamage() - 10)) {
                InventoryUtils.equipBestElytra((Player)this);
            }
        } else {
            this.autoSwitchElytraChestplate = ItemStack.EMPTY;
        }
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="RETURN")})
    private void onStopFlying(EntityDataAccessor<?> data, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_AUTO_SWITCH_ELYTRA.getBooleanValue() && DATA_SHARED_FLAGS_ID.equals(data) && this.wasFallFlying && !this.isFallFlying() && this.getItemBySlot(EquipmentSlot.CHEST).is(Items.ELYTRA)) {
            if (!this.autoSwitchElytraChestplate.isEmpty() && !this.autoSwitchElytraChestplate.is(Items.ELYTRA)) {
                int targetSlot;
                if (this.inventoryMenu.getCarried().isEmpty() && (targetSlot = InventoryUtils.findSlotWithItem((AbstractContainerMenu)this.inventoryMenu, this.autoSwitchElytraChestplate, true, false)) >= 0) {
                    InventoryUtils.swapItemToEquipmentSlot((Player)this, EquipmentSlot.CHEST, targetSlot);
                    this.autoSwitchElytraChestplate = ItemStack.EMPTY;
                }
            } else {
                InventoryUtils.swapElytraAndChestPlate((Player)this);
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void disableMovementInputsPre(CallbackInfo ci) {
        if (CameraUtils.shouldPreventPlayerMovement()) {
            this.realInput = this.input;
            this.input = this.dummyMovementInput;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void disableMovementInputsPost(CallbackInfo ci) {
        if (this.realInput != null) {
            this.input = this.realInput;
            this.realInput = null;
        }
    }

    @Inject(method={"isControlledCamera()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowPlayerMovementInFreeCameraMode(CallbackInfoReturnable<Boolean> cir) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && CameraEntity.originalCameraWasPlayer()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventHandSwing(InteractionHand hand, CallbackInfo ci) {
        if (CameraUtils.shouldPreventPlayerInputs()) {
            ci.cancel();
        }
    }
}

