/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.render;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1001)
public abstract class MixinWorldRenderer {
    @Shadow
    private int lastCameraSectionX;
    @Shadow
    private int lastCameraSectionZ;
    @Unique
    private int lastUpdatePosX;
    @Unique
    private int lastUpdatePosZ;

    @Inject(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelRainRender(Camera camera, CallbackInfo ci) {
        if (Configs.Disable.DISABLE_RAIN_EFFECTS.getBooleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelRainRender(LightTexture lightmap, float partialTicks, double x, double y, double z, CallbackInfo ci) {
        if (Configs.Disable.DISABLE_RAIN_EFFECTS.getBooleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=terrain_setup"})})
    private void preSetupTerrain(DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            CameraUtils.setFreeCameraSpectator(true);
        }
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=compile_sections"})})
    private void postSetupTerrain(DeltaTracker tickCounter, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        CameraUtils.setFreeCameraSpectator(false);
    }

    @Redirect(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getEntity()Lnet/minecraft/world/entity/Entity;", ordinal=3))
    private Entity allowRenderingClientPlayerInFreeCameraMode(Camera camera) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            return Minecraft.getInstance().player;
        }
        return camera.getEntity();
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    private void spawnParticleInject(ParticleOptions parameters, boolean alwaysSpawn, boolean canSpawnOnMinimal, double x, double y, double z, double velocityX, double velocityY, double velocityZ, CallbackInfoReturnable<Particle> cir) {
        if (Configs.Generic.SELECTIVE_BLOCKS_HIDE_PARTICLES.getBooleanValue() && !RenderTweaks.isPositionValidForRendering(BlockPos.containing((double)x, (double)y, (double)z))) {
            cir.setReturnValue(null);
            cir.cancel();
        }
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, require=0, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/renderer/LevelRenderer;prevCamX:D")})
    private void rebuildChunksAroundCamera1(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            this.lastUpdatePosX = this.lastCameraSectionX;
            this.lastUpdatePosZ = this.lastCameraSectionZ;
        }
    }

    @Inject(method={"setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, require=0, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/ViewArea;repositionCamera(DD)V")})
    private void rebuildChunksAroundCamera2(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
            int x = Mth.floor((double)camera.getPosition().x) >> 4;
            int z = Mth.floor((double)camera.getPosition().z) >> 4;
            CameraUtils.markChunksForRebuild(x, z, this.lastUpdatePosX, this.lastUpdatePosZ);
        }
    }
}

