/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.restrictions.BlockRestriction;
import fi.dy.masa.malilib.util.restrictions.ItemRestriction;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.IMinecraftClientInvoker;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.PlacementRestrictionMode;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlacementTweaks {
    private static BlockPos posFirst = null;
    private static BlockPos posFirstBreaking = null;
    private static BlockPos posLast = null;
    private static PositionUtils.HitPart hitPartFirst = null;
    private static InteractionHand handFirst = InteractionHand.MAIN_HAND;
    private static Vec3 hitVecFirst = null;
    private static Direction sideFirst = null;
    private static Direction sideFirstBreaking = null;
    private static Direction sideRotatedFirst = null;
    private static float playerYawFirst;
    private static ItemStack[] stackBeforeUse;
    private static boolean isFirstClick;
    private static boolean isEmulatedClick;
    private static boolean firstWasRotation;
    private static boolean firstWasOffset;
    private static int placementCount;
    private static int hotbarSlot;
    private static ItemStack stackClickedOn;
    @Nullable
    private static BlockState stateClickedOn;
    public static final BlockRestriction BLOCK_TYPE_BREAK_RESTRICTION;
    public static final BlockRestriction FAST_RIGHT_CLICK_BLOCK_RESTRICTION;
    public static final ItemRestriction FAST_RIGHT_CLICK_ITEM_RESTRICTION;
    public static final ItemRestriction FAST_PLACEMENT_ITEM_RESTRICTION;
    public static final ItemRestriction HAND_RESTOCK_RESTRICTION;

    public static void onTick(Minecraft mc) {
        boolean attack = mc.options.keyAttack.isDown();
        boolean use = mc.options.keyUse.isDown();
        if (GuiUtils.getCurrentScreen() == null && !FeatureToggle.TWEAK_AREA_SELECTOR.getBooleanValue()) {
            if (use) {
                PlacementTweaks.onUsingTick();
            }
            if (attack) {
                PlacementTweaks.onAttackTick(mc);
            }
        } else {
            PlacementTweaks.stackBeforeUse[0] = ItemStack.EMPTY;
            PlacementTweaks.stackBeforeUse[1] = ItemStack.EMPTY;
        }
        if (!use) {
            PlacementTweaks.clearClickedBlockInfoUse();
            if (!attack) {
                PlacementTweaks.stackBeforeUse[0] = ItemStack.EMPTY;
                PlacementTweaks.stackBeforeUse[1] = ItemStack.EMPTY;
            }
        }
        if (!attack) {
            PlacementTweaks.clearClickedBlockInfoAttack();
        }
    }

    public static boolean onProcessRightClickPre(Player player, InteractionHand hand) {
        fi.dy.masa.tweakeroo.util.InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        ItemStack stackOriginal = player.getItemInHand(hand);
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && !stackOriginal.isEmpty() && PlacementTweaks.canUseItemWithRestriction(HAND_RESTOCK_RESTRICTION, stackOriginal)) {
            if (!isEmulatedClick) {
                PlacementTweaks.cacheStackInHand(hand);
            }
            boolean allowHotbar = !FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue() && !FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue();
            fi.dy.masa.tweakeroo.util.InventoryUtils.preRestockHand(player, hand, allowHotbar);
        }
        return fi.dy.masa.tweakeroo.util.InventoryUtils.canUnstackingItemNotFitInInventory(stackOriginal, player);
    }

    public static void onProcessRightClickPost(Player player, InteractionHand hand) {
        PlacementTweaks.tryRestockHand(player, hand, stackBeforeUse[hand.ordinal()]);
    }

    public static void onLeftClickMousePre() {
        Minecraft mc = Minecraft.getInstance();
        HitResult trace = mc.hitResult;
        if (trace != null && trace.getType() == HitResult.Type.BLOCK && posFirstBreaking == null) {
            posFirstBreaking = ((BlockHitResult)trace).getBlockPos();
            sideFirstBreaking = ((BlockHitResult)trace).getDirection();
        }
        PlacementTweaks.onProcessRightClickPre((Player)mc.player, InteractionHand.MAIN_HAND);
    }

    public static void onLeftClickMousePost() {
        PlacementTweaks.onProcessRightClickPost((Player)Minecraft.getInstance().player, InteractionHand.MAIN_HAND);
    }

    public static void cacheStackInHand(InteractionHand hand) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stackOriginal = player.getItemInHand(hand);
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && !stackOriginal.isEmpty() && PlacementTweaks.canUseItemWithRestriction(HAND_RESTOCK_RESTRICTION, stackOriginal)) {
            PlacementTweaks.stackBeforeUse[hand.ordinal()] = stackOriginal.copy();
            hotbarSlot = player.getInventory().selected;
        }
    }

    private static void onAttackTick(Minecraft mc) {
        if (FeatureToggle.TWEAK_FAST_LEFT_CLICK.getBooleanValue()) {
            if (mc.player.getAbilities().instabuild || Configs.Generic.FAST_LEFT_CLICK_ALLOW_TOOLS.getBooleanValue() || !(mc.player.getMainHandItem().getItem() instanceof DiggerItem)) {
                int count = Configs.Generic.FAST_LEFT_CLICK_COUNT.getIntegerValue();
                for (int i = 0; i < count; ++i) {
                    isEmulatedClick = true;
                    ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoAttack();
                    isEmulatedClick = false;
                }
            }
        } else {
            fi.dy.masa.tweakeroo.util.InventoryUtils.trySwapCurrentToolIfNearlyBroken();
            InteractionHand hand = InteractionHand.MAIN_HAND;
            PlacementTweaks.tryRestockHand((Player)mc.player, hand, stackBeforeUse[hand.ordinal()]);
        }
    }

    private static void onUsingTick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (posFirst != null && FeatureToggle.TWEAK_FAST_BLOCK_PLACEMENT.getBooleanValue() && PlacementTweaks.canUseItemWithRestriction(FAST_PLACEMENT_ITEM_RESTRICTION, (Player)mc.player)) {
            HitResult trace;
            LocalPlayer player = mc.player;
            Level world = player.getCommandSenderWorld();
            double reach = mc.player.blockInteractionRange();
            int maxCount = Configs.Generic.FAST_BLOCK_PLACEMENT_COUNT.getIntegerValue();
            mc.hitResult = player.pick(reach, mc.getTimer().getGameTimeDeltaPartialTick(false), false);
            for (int i = 0; i < maxCount && (trace = mc.hitResult) != null && trace.getType() == HitResult.Type.BLOCK; ++i) {
                InteractionResult result;
                BlockHitResult blockHitResult = (BlockHitResult)trace;
                InteractionHand hand = handFirst;
                Direction side = blockHitResult.getDirection();
                BlockPos pos = blockHitResult.getBlockPos();
                Vec3 hitVec = blockHitResult.getLocation();
                if (FeatureToggle.TWEAK_SCAFFOLD_PLACE.getBooleanValue()) {
                    ItemStack stack = player.getItemInHand(hand);
                    if ((pos = PlacementTweaks.getScaffoldPlacePosition(pos, side = PlacementTweaks.getScaffoldPlaceDirection(side, hitPartFirst, (Player)player), world, stack, (Player)player)) == null) {
                        return;
                    }
                    pos = pos.relative(side.getOpposite());
                }
                BlockHitResult hitResult = new BlockHitResult(hitVec, side, pos, false);
                BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
                BlockPos posNew = PlacementTweaks.getPlacementPositionForTargetedPosition(world, pos, side, ctx);
                hitResult = new BlockHitResult(hitVec, side, posNew, false);
                ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
                if (hand == null || posNew.equals((Object)posLast) || !PlacementTweaks.canPlaceBlockIntoPosition(world, posNew, ctx) || !PlacementTweaks.isPositionAllowedByPlacementRestriction(posNew, side) || !PlacementTweaks.canPlaceBlockAgainst(world, pos, (Player)player, hand) || (result = PlacementTweaks.tryPlaceBlock(mc.gameMode, player, mc.level, posNew, sideFirst, sideRotatedFirst, playerYawFirst, hitVec = hitVecFirst.add((double)posNew.getX(), (double)posNew.getY(), (double)posNew.getZ()), hand, hitPartFirst, false)) != InteractionResult.SUCCESS) break;
                posLast = posNew;
                mc.hitResult = player.pick(reach, mc.getTimer().getGameTimeDeltaPartialTick(false), false);
            }
            ((IMinecraftClientInvoker)mc).tweakeroo_setItemUseCooldown(4);
        } else if (FeatureToggle.TWEAK_FAST_RIGHT_CLICK.getBooleanValue() && mc.options.keyUse.isDown() && PlacementTweaks.canUseFastRightClick((Player)mc.player)) {
            int count = Configs.Generic.FAST_RIGHT_CLICK_COUNT.getIntegerValue();
            for (int i = 0; i < count; ++i) {
                isEmulatedClick = true;
                ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoItemUse();
                isEmulatedClick = false;
            }
        }
    }

    public static InteractionResult onProcessRightClickBlock(MultiPlayerGameMode controller, LocalPlayer player, ClientLevel world, InteractionHand hand, BlockHitResult hitResult) {
        if (CameraUtils.shouldPreventPlayerInputs()) {
            return InteractionResult.PASS;
        }
        fi.dy.masa.tweakeroo.util.InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        ItemStack stackPre = player.getItemInHand(hand);
        BlockPos posIn = hitResult.getBlockPos();
        if (Configs.Disable.DISABLE_AXE_STRIPPING.getBooleanValue() && stackPre.getItem() instanceof AxeItem && MiscUtils.isStrippableLog((Level)world, posIn)) {
            return InteractionResult.PASS;
        }
        if (Configs.Disable.DISABLE_SHOVEL_PATHING.getBooleanValue() && stackPre.getItem() instanceof ShovelItem && MiscUtils.isShovelPathConvertableBlock((Level)world, posIn)) {
            return InteractionResult.PASS;
        }
        stackPre = stackPre.copy();
        boolean restricted = FeatureToggle.TWEAK_PLACEMENT_RESTRICTION.getBooleanValue() || FeatureToggle.TWEAK_PLACEMENT_GRID.getBooleanValue();
        Direction sideIn = hitResult.getDirection();
        Vec3 hitVec = hitResult.getLocation();
        Direction playerFacingH = player.getDirection();
        PositionUtils.HitPart hitPart = PositionUtils.getHitPart((Direction)sideIn, (Direction)playerFacingH, (BlockPos)posIn, (Vec3)hitVec);
        Direction sideRotated = PlacementTweaks.getRotatedFacing(sideIn, playerFacingH, hitPart);
        float yaw = player.getYRot();
        PlacementTweaks.cacheStackInHand(hand);
        if (FeatureToggle.TWEAK_PLACEMENT_REST_FIRST.getBooleanValue() && stateClickedOn == null) {
            BlockState state = world.getBlockState(posIn);
            stackClickedOn = state.getBlock().getCloneItemStack((LevelReader)world, posIn, state);
            stateClickedOn = state;
        }
        if (!PlacementTweaks.canPlaceBlockAgainst((Level)world, posIn, (Player)player, hand)) {
            return InteractionResult.PASS;
        }
        boolean flexible = FeatureToggle.TWEAK_FLEXIBLE_BLOCK_PLACEMENT.getBooleanValue();
        boolean rotation = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ROTATION.getKeybind().isKeybindHeld();
        boolean offset = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_OFFSET.getKeybind().isKeybindHeld();
        boolean adjacent = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ADJACENT.getKeybind().isKeybindHeld();
        if (!(!FeatureToggle.TWEAK_SCAFFOLD_PLACE.getBooleanValue() || flexible && (rotation || offset || adjacent))) {
            ItemStack stack = player.getItemInHand(hand);
            Direction extendDirection = PlacementTweaks.getScaffoldPlaceDirection(sideIn, hitPart, (Player)player);
            BlockPos newPos = PlacementTweaks.getScaffoldPlacePosition(posIn, extendDirection, (Level)world, stack, (Player)player);
            if (newPos == null) {
                return InteractionResult.PASS;
            }
            newPos = newPos.relative(extendDirection.getOpposite());
            sideIn = extendDirection;
            hitVec = hitVec.subtract((double)posIn.getX(), (double)posIn.getY(), (double)posIn.getZ()).add((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ());
            posIn = newPos;
        }
        InteractionResult result = PlacementTweaks.tryPlaceBlock(controller, player, world, posIn, sideIn, sideRotated, yaw, hitVec, hand, hitPart, true);
        if (posFirst == null && result == InteractionResult.SUCCESS && restricted) {
            boolean accurate = FeatureToggle.TWEAK_ACCURATE_BLOCK_PLACEMENT.getBooleanValue();
            boolean accurateIn = Hotkeys.ACCURATE_BLOCK_PLACEMENT_IN.getKeybind().isKeybindHeld();
            boolean accurateReverse = Hotkeys.ACCURATE_BLOCK_PLACEMENT_REVERSE.getKeybind().isKeybindHeld();
            firstWasRotation = flexible && rotation || accurate && (accurateIn || accurateReverse);
            firstWasOffset = flexible && offset;
            BlockHitResult hitResultTmp = new BlockHitResult(hitVec, sideIn, posIn, false);
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResultTmp));
            posLast = posFirst = PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posIn, sideIn, ctx);
            hitPartFirst = hitPart;
            handFirst = hand;
            hitVecFirst = hitVec.subtract((double)posFirst.getX(), (double)posFirst.getY(), (double)posFirst.getZ());
            sideFirst = sideIn;
            sideRotatedFirst = sideRotated;
            playerYawFirst = yaw;
            PlacementTweaks.stackBeforeUse[hand.ordinal()] = stackPre;
        }
        return result;
    }

    private static Direction getScaffoldPlaceDirection(Direction side, PositionUtils.HitPart hitPart, Player player) {
        Direction offsetIn = PlacementTweaks.getRotatedFacing(side, player.getDirection(), hitPart).getOpposite();
        Direction extendDirection = side == Direction.UP || side == Direction.DOWN ? (hitPart == PositionUtils.HitPart.CENTER || Configs.Generic.SCAFFOLD_PLACE_VANILLA.getBooleanValue() ? player.getDirection() : offsetIn) : (hitPart == PositionUtils.HitPart.CENTER || Configs.Generic.SCAFFOLD_PLACE_VANILLA.getBooleanValue() ? Direction.UP : offsetIn);
        return extendDirection;
    }

    private static BlockPos getScaffoldPlacePosition(BlockPos pos, Direction extendDirection, Level world, ItemStack stack, Player player) {
        if (!(stack.getItem() instanceof BlockItem) || extendDirection == null) {
            return null;
        }
        Block itemBlock = ((BlockItem)stack.getItem()).getBlock();
        Minecraft mc = Minecraft.getInstance();
        double reach = mc.player.blockInteractionRange();
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        for (int i = 0; i < Configs.Generic.SCAFFOLD_PLACE_DISTANCE.getIntegerValue(); ++i) {
            tempPos.move(extendDirection);
            if (!MiscUtils.isInReach((BlockPos)tempPos, player, reach)) {
                return null;
            }
            BlockState state = world.getBlockState((BlockPos)tempPos);
            if (state.getBlock() == itemBlock) continue;
            if (state.isAir() || state.canBeReplaced()) {
                return tempPos.immutable();
            }
            return null;
        }
        return null;
    }

    private static InteractionResult tryPlaceBlock(MultiPlayerGameMode controller, LocalPlayer player, ClientLevel world, BlockPos posIn, Direction sideIn, Direction sideRotatedIn, float playerYaw, Vec3 hitVec, InteractionHand hand, PositionUtils.HitPart hitPart, boolean isFirstClick) {
        Direction side = sideIn;
        boolean handleFlexible = false;
        BlockPos posNew = null;
        boolean flexible = FeatureToggle.TWEAK_FLEXIBLE_BLOCK_PLACEMENT.getBooleanValue();
        boolean rotationHeld = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ROTATION.getKeybind().isKeybindHeld();
        boolean offsetHeld = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_OFFSET.getKeybind().isKeybindHeld();
        boolean adjacent = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ADJACENT.getKeybind().isKeybindHeld();
        boolean rememberFlexible = Configs.Generic.REMEMBER_FLEXIBLE.getBooleanValue();
        boolean rotation = rotationHeld || rememberFlexible && firstWasRotation;
        boolean offset = offsetHeld || rememberFlexible && firstWasOffset;
        ItemStack stack = player.getItemInHand(hand);
        if (flexible) {
            BlockHitResult hitResult = new BlockHitResult(hitVec, sideIn, posIn, false);
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
            BlockPos blockPos = posNew = isFirstClick && (rotation || offset || adjacent) ? PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posIn, sideIn, ctx) : posIn;
            if (adjacent && hitPart != null && hitPart != PositionUtils.HitPart.CENTER) {
                posNew = posNew.relative(sideRotatedIn.getOpposite()).relative(sideIn.getOpposite());
                hitVec = hitVec.add(Vec3.atLowerCornerOf((Vec3i)sideRotatedIn.getOpposite().getNormal().offset(sideIn.getOpposite().getNormal())));
                handleFlexible = true;
            }
            if (rotation) {
                side = sideRotatedIn;
                handleFlexible = true;
            } else {
                hitPart = null;
            }
            if (offset) {
                posNew = posNew.relative(sideRotatedIn.getOpposite());
                hitVec = hitVec.add(Vec3.atLowerCornerOf((Vec3i)sideRotatedIn.getOpposite().getNormal()));
                handleFlexible = true;
            }
        }
        boolean simpleOffset = false;
        if (!handleFlexible && FeatureToggle.TWEAK_FAKE_SNEAK_PLACEMENT.getBooleanValue() && stack.getItem() instanceof BlockItem) {
            BlockHitResult hitResult = new BlockHitResult(hitVec, sideIn, posIn, false);
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
            posNew = PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posIn, sideIn, ctx);
            simpleOffset = true;
        }
        boolean accurate = FeatureToggle.TWEAK_ACCURATE_BLOCK_PLACEMENT.getBooleanValue();
        boolean accurateIn = Hotkeys.ACCURATE_BLOCK_PLACEMENT_IN.getKeybind().isKeybindHeld();
        boolean accurateReverse = Hotkeys.ACCURATE_BLOCK_PLACEMENT_REVERSE.getKeybind().isKeybindHeld();
        boolean afterClicker = FeatureToggle.TWEAK_AFTER_CLICKER.getBooleanValue();
        if (accurate && (accurateIn || accurateReverse || afterClicker)) {
            BlockPlaceContext ctx;
            BlockHitResult hitResult;
            Direction facing = side;
            boolean handleAccurate = false;
            if (posNew == null) {
                if (!flexible || !isFirstClick) {
                    posNew = posIn;
                } else {
                    hitResult = new BlockHitResult(hitVec, side, posIn, false);
                    ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
                    posNew = PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posIn, side, ctx);
                }
            }
            if (accurateIn) {
                facing = sideIn;
                hitPart = null;
                handleAccurate = true;
                if (!(stack.getItem() instanceof BlockItem) || ((BlockItem)stack.getItem()).getBlock() != Blocks.OBSERVER) {
                    facing = facing.getOpposite();
                }
            } else if (!flexible || !rotation) {
                if (stack.getItem() instanceof BlockItem) {
                    hitResult = new BlockHitResult(hitVec, sideIn, posNew, false);
                    ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
                    BlockPos posPlacement = PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posNew, sideIn, ctx);
                    hitResult = new BlockHitResult(hitVec, sideIn, posPlacement, false);
                    ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
                    BlockItem item = (BlockItem)stack.getItem();
                    BlockState state = item.getBlock().getStateForPlacement(ctx);
                    if (state == null) {
                        return InteractionResult.PASS;
                    }
                    Optional facingTmp = BlockUtils.getFirstPropertyFacingValue((BlockState)state);
                    if (facingTmp.isPresent()) {
                        facing = (Direction)facingTmp.get();
                    }
                } else {
                    facing = player.getDirection();
                }
            }
            if (accurateReverse) {
                if (accurateIn || !flexible || !rotation) {
                    facing = facing.getOpposite();
                }
                hitPart = null;
                handleAccurate = true;
            }
            if ((handleAccurate || afterClicker) && Configs.Generic.ACCURATE_PLACEMENT_PROTOCOL.getBooleanValue()) {
                double relX = hitVec.x - (double)posNew.getX();
                double x = hitVec.x;
                int afterClickerClickCount = Mth.clamp((int)Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue(), (int)0, (int)32);
                if (handleAccurate && BlockUtils.isFacingValidForDirection((ItemStack)stack, (Direction)facing)) {
                    x = (double)posNew.getX() + relX + 2.0 + (double)(facing.get3DDataValue() * 2);
                } else if (handleAccurate && BlockUtils.isFacingValidForOrientation((ItemStack)stack, (Direction)facing)) {
                    int facingIndex = BlockUtils.getOrientationFacingIndex((ItemStack)stack, (Direction)facing);
                    x = facingIndex > 0 ? (double)posNew.getX() + relX + 2.0 + (double)(facingIndex * 2) : (double)posNew.getX() + relX + 2.0 + (double)(facing.get3DDataValue() * 2);
                }
                if (afterClicker) {
                    x += (double)(afterClickerClickCount * 16);
                }
                hitVec = new Vec3(x, hitVec.y, hitVec.z);
            }
            return PlacementTweaks.processRightClickBlockWrapper(controller, player, world, posNew, side, hitVec, hand);
        }
        if (handleFlexible) {
            BlockHitResult hitResult = new BlockHitResult(hitVec, side, posNew, false);
            BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
            if (PlacementTweaks.canPlaceBlockIntoPosition((Level)world, posNew, ctx)) {
                return PlacementTweaks.handleFlexibleBlockPlacement(controller, player, world, posNew, side, playerYaw, hitVec, hand, hitPart);
            }
            return InteractionResult.PASS;
        }
        if (!isFirstClick && Configs.Generic.FAST_PLACEMENT_REMEMBER_ALWAYS.getBooleanValue()) {
            return PlacementTweaks.handleFlexibleBlockPlacement(controller, player, world, posIn, sideIn, playerYaw, hitVec, hand, null);
        }
        return PlacementTweaks.processRightClickBlockWrapper(controller, player, world, simpleOffset ? posNew : posIn, sideIn, hitVec, hand);
    }

    private static boolean canPlaceBlockAgainst(Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stackHand;
        ItemStack stackClicked;
        BlockState state;
        if (FeatureToggle.TWEAK_PLACEMENT_REST_FIRST.getBooleanValue()) {
            ItemStack stack;
            state = world.getBlockState(pos);
            if (!stackClickedOn.isEmpty() ? !InventoryUtils.areStacksEqual((ItemStack)stackClickedOn, (ItemStack)(stack = state.getBlock().getCloneItemStack((LevelReader)world, pos, state))) : state != stateClickedOn) {
                return false;
            }
        }
        return !FeatureToggle.TWEAK_PLACEMENT_REST_HAND.getBooleanValue() || InventoryUtils.areStacksEqual((ItemStack)(stackClicked = (state = world.getBlockState(pos)).getBlock().getCloneItemStack((LevelReader)world, pos, state)), (ItemStack)(stackHand = player.getItemInHand(hand)));
    }

    public static boolean canUseItemWithRestriction(ItemRestriction restriction, InteractionHand hand, Player player) {
        ItemStack stack = player.getItemInHand(hand);
        return PlacementTweaks.canUseItemWithRestriction(restriction, stack);
    }

    public static boolean canUseItemWithRestriction(ItemRestriction restriction, ItemStack stack) {
        return stack.isEmpty() || restriction.isAllowed((Object)stack.getItem());
    }

    public static boolean canUseItemWithRestriction(ItemRestriction restriction, Player player) {
        return PlacementTweaks.canUseItemWithRestriction(restriction, InteractionHand.MAIN_HAND, player) && PlacementTweaks.canUseItemWithRestriction(restriction, InteractionHand.OFF_HAND, player);
    }

    private static boolean canUseFastRightClick(Player player) {
        if (!PlacementTweaks.canUseItemWithRestriction(FAST_RIGHT_CLICK_ITEM_RESTRICTION, player)) {
            return false;
        }
        HitResult trace = player.pick(6.0, 0.0f, false);
        if (trace == null || trace.getType() != HitResult.Type.BLOCK) {
            return FAST_RIGHT_CLICK_BLOCK_RESTRICTION.isAllowed((Object)Blocks.AIR);
        }
        Block block = player.getCommandSenderWorld().getBlockState(((BlockHitResult)trace).getBlockPos()).getBlock();
        return FAST_RIGHT_CLICK_BLOCK_RESTRICTION.isAllowed((Object)block);
    }

    public static void tryRestockHand(Player player, InteractionHand hand, ItemStack stackOriginal) {
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && PlacementTweaks.canUseItemWithRestriction(HAND_RESTOCK_RESTRICTION, stackOriginal)) {
            ItemStack stackCurrent = player.getItemInHand(hand);
            if (!(stackOriginal.isEmpty() || player.getInventory().selected != hotbarSlot || !stackCurrent.isEmpty() && ItemStack.isSameItem((ItemStack)stackCurrent, (ItemStack)stackOriginal))) {
                boolean allowHotbar = !FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue() && !FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue();
                fi.dy.masa.tweakeroo.util.InventoryUtils.restockNewStackToHand(player, hand, stackOriginal, allowHotbar);
            }
        }
    }

    private static InteractionResult processRightClickBlockWrapper(MultiPlayerGameMode controller, LocalPlayer player, ClientLevel world, BlockPos posIn, Direction sideIn, Vec3 hitVecIn, InteractionHand hand) {
        InteractionResult result;
        if (FeatureToggle.TWEAK_PLACEMENT_LIMIT.getBooleanValue() && placementCount >= Configs.Generic.PLACEMENT_LIMIT.getIntegerValue()) {
            return InteractionResult.PASS;
        }
        boolean allowHotbar = !FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue() && !FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue();
        fi.dy.masa.tweakeroo.util.InventoryUtils.preRestockHand((Player)player, hand, allowHotbar);
        BlockHitResult hitResult = new BlockHitResult(hitVecIn, sideIn, posIn, false);
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)player, hand, hitResult));
        BlockPos posPlacement = PlacementTweaks.getPlacementPositionForTargetedPosition((Level)world, posIn, sideIn, ctx);
        BlockState stateBefore = world.getBlockState(posPlacement);
        BlockState state = world.getBlockState(posIn);
        ItemStack stackOriginal = !stackBeforeUse[hand.ordinal()].isEmpty() && !FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue() && !FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue() ? stackBeforeUse[hand.ordinal()] : player.getItemInHand(hand).copy();
        if (FeatureToggle.TWEAK_PLACEMENT_RESTRICTION.getBooleanValue() && !state.canBeReplaced(ctx) && state.canBeReplaced()) {
            posIn = posIn.relative(sideIn.getOpposite());
        }
        if (posFirst != null && !PlacementTweaks.isPositionAllowedByPlacementRestriction(posIn, sideIn)) {
            return InteractionResult.PASS;
        }
        int afterClickerClickCount = Mth.clamp((int)Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue(), (int)0, (int)32);
        Direction facing = sideIn;
        boolean flexible = FeatureToggle.TWEAK_FLEXIBLE_BLOCK_PLACEMENT.getBooleanValue();
        boolean rotationHeld = Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ROTATION.getKeybind().isKeybindHeld();
        boolean rememberFlexible = Configs.Generic.REMEMBER_FLEXIBLE.getBooleanValue();
        boolean rotation = rotationHeld || rememberFlexible && firstWasRotation;
        boolean accurate = FeatureToggle.TWEAK_ACCURATE_BLOCK_PLACEMENT.getBooleanValue();
        boolean keys = Hotkeys.ACCURATE_BLOCK_PLACEMENT_IN.getKeybind().isKeybindHeld() || Hotkeys.ACCURATE_BLOCK_PLACEMENT_REVERSE.getKeybind().isKeybindHeld();
        boolean bl = accurate = accurate && keys;
        if (flexible && rotation && !accurate && Configs.Generic.ACCURATE_PLACEMENT_PROTOCOL.getBooleanValue() && BlockUtils.isFacingValidForDirection((ItemStack)stackOriginal, (Direction)facing)) {
            facing = facing.getOpposite();
            double x = posIn.getX() + 2 + facing.get3DDataValue() * 2;
            if (FeatureToggle.TWEAK_AFTER_CLICKER.getBooleanValue()) {
                x += (double)(afterClickerClickCount * 16);
            }
            hitVecIn = new Vec3(x, hitVecIn.y, hitVecIn.z);
        } else if (flexible && rotation && !accurate && Configs.Generic.ACCURATE_PLACEMENT_PROTOCOL.getBooleanValue() && BlockUtils.isFacingValidForOrientation((ItemStack)stackOriginal, (Direction)facing)) {
            int facingIndex = BlockUtils.getOrientationFacingIndex((ItemStack)stackOriginal, (Direction)(facing = facing.getOpposite()));
            double x = facingIndex >= 0 ? (double)(posIn.getX() + 2 + facingIndex * 2) : (double)(posIn.getX() + 2 + facing.get3DDataValue() * 2);
            if (FeatureToggle.TWEAK_AFTER_CLICKER.getBooleanValue()) {
                x += (double)(afterClickerClickCount * 16);
            }
            hitVecIn = new Vec3(x, hitVecIn.y, hitVecIn.z);
        }
        if (FeatureToggle.TWEAK_Y_MIRROR.getBooleanValue() && Hotkeys.PLACEMENT_Y_MIRROR.getKeybind().isKeybindHeld()) {
            double y = 1.0 - hitVecIn.y + (double)(2 * posIn.getY());
            hitVecIn = new Vec3(hitVecIn.x, y, hitVecIn.z);
            if (sideIn.getAxis() == Direction.Axis.Y) {
                posIn = posIn.relative(sideIn);
                sideIn = sideIn.getOpposite();
            }
        }
        if (FeatureToggle.TWEAK_PICK_BEFORE_PLACE.getBooleanValue()) {
            fi.dy.masa.tweakeroo.util.InventoryUtils.switchToPickedBlock();
        }
        fi.dy.masa.tweakeroo.util.InventoryUtils.trySwapCurrentToolIfNearlyBroken();
        if (fi.dy.masa.tweakeroo.util.InventoryUtils.canUnstackingItemNotFitInInventory(stackOriginal, (Player)player)) {
            result = InteractionResult.PASS;
        } else {
            BlockHitResult context = new BlockHitResult(hitVecIn, sideIn, posIn, false);
            result = controller.useItemOn(player, hand, context);
        }
        if (result == InteractionResult.SUCCESS) {
            ++placementCount;
        }
        PlacementTweaks.tryRestockHand((Player)player, hand, stackOriginal);
        if (FeatureToggle.TWEAK_AFTER_CLICKER.getBooleanValue() && !Configs.Generic.ACCURATE_PLACEMENT_PROTOCOL.getBooleanValue() && world.getBlockState(posPlacement) != stateBefore) {
            for (int i = 0; i < afterClickerClickCount; ++i) {
                BlockHitResult context = new BlockHitResult(hitVecIn, sideIn, posPlacement, false);
                result = controller.useItemOn(player, hand, context);
            }
        }
        if (result == InteractionResult.SUCCESS) {
            Inventory inv = player.getInventory();
            if (FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getBooleanValue()) {
                int newSlot = inv.selected + 1;
                if (newSlot >= 9 || newSlot >= Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getIntegerValue()) {
                    newSlot = 0;
                }
                inv.selected = newSlot;
            } else if (FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getBooleanValue()) {
                int newSlot;
                inv.selected = newSlot = player.getRandom().nextInt(Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getIntegerValue());
            }
        }
        return result;
    }

    private static InteractionResult handleFlexibleBlockPlacement(MultiPlayerGameMode controller, LocalPlayer player, ClientLevel world, BlockPos pos, Direction side, float playerYaw, Vec3 hitVec, InteractionHand hand, @Nullable PositionUtils.HitPart hitPart) {
        Direction facing;
        Direction facingOrig = facing = Direction.from2DDataValue((int)(Mth.floor((double)((double)(playerYaw * 4.0f / 360.0f) + 0.5)) & 3));
        float yawOrig = player.getYRot();
        if (hitPart == PositionUtils.HitPart.CENTER) {
            facing = facing.getOpposite();
        } else if (hitPart == PositionUtils.HitPart.LEFT) {
            facing = facing.getCounterClockWise();
        } else if (hitPart == PositionUtils.HitPart.RIGHT) {
            facing = facing.getClockWise();
        }
        float yaw = facing.toYRot();
        float pitch = player.getXRot();
        player.setYRot(yaw);
        player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(yaw, pitch, player.onGround()));
        InteractionResult result = PlacementTweaks.processRightClickBlockWrapper(controller, player, world, pos, side, hitVec, hand);
        player.setYRot(yawOrig);
        player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(yawOrig, pitch, player.onGround()));
        return result;
    }

    private static void clearClickedBlockInfoUse() {
        posFirst = null;
        hitPartFirst = null;
        hitVecFirst = null;
        sideFirst = null;
        sideRotatedFirst = null;
        firstWasRotation = false;
        firstWasOffset = false;
        isFirstClick = true;
        placementCount = 0;
        stackClickedOn = ItemStack.EMPTY;
        stateClickedOn = null;
    }

    private static void clearClickedBlockInfoAttack() {
        posFirstBreaking = null;
        sideFirstBreaking = null;
    }

    private static Direction getRotatedFacing(Direction originalSide, Direction playerFacingH, PositionUtils.HitPart hitPart) {
        if (originalSide.getAxis().isVertical()) {
            return switch (hitPart) {
                default -> throw new MatchException(null, null);
                case PositionUtils.HitPart.LEFT -> playerFacingH.getClockWise();
                case PositionUtils.HitPart.RIGHT -> playerFacingH.getCounterClockWise();
                case PositionUtils.HitPart.BOTTOM -> {
                    if (originalSide == Direction.UP) {
                        yield playerFacingH;
                    }
                    yield playerFacingH.getOpposite();
                }
                case PositionUtils.HitPart.TOP -> {
                    if (originalSide == Direction.DOWN) {
                        yield playerFacingH;
                    }
                    yield playerFacingH.getOpposite();
                }
                case PositionUtils.HitPart.CENTER -> originalSide.getOpposite();
            };
        }
        return switch (hitPart) {
            default -> throw new MatchException(null, null);
            case PositionUtils.HitPart.LEFT -> originalSide.getCounterClockWise();
            case PositionUtils.HitPart.RIGHT -> originalSide.getClockWise();
            case PositionUtils.HitPart.BOTTOM -> Direction.UP;
            case PositionUtils.HitPart.TOP -> Direction.DOWN;
            case PositionUtils.HitPart.CENTER -> originalSide.getOpposite();
        };
    }

    private static boolean isPositionAllowedByPlacementRestriction(BlockPos pos, Direction side) {
        boolean restrictionEnabled = FeatureToggle.TWEAK_PLACEMENT_RESTRICTION.getBooleanValue();
        boolean gridEnabled = FeatureToggle.TWEAK_PLACEMENT_GRID.getBooleanValue();
        if (!restrictionEnabled && !gridEnabled) {
            return true;
        }
        int gridSize = Configs.Generic.PLACEMENT_GRID_SIZE.getIntegerValue();
        PlacementRestrictionMode mode = (PlacementRestrictionMode)Configs.Generic.PLACEMENT_RESTRICTION_MODE.getOptionListValue();
        return PlacementTweaks.isPositionAllowedByRestrictions(pos, side, posFirst, sideFirst, restrictionEnabled, mode, gridEnabled, gridSize);
    }

    public static boolean isPositionAllowedByBreakingRestriction(BlockPos pos, Direction side) {
        BlockState state;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (world != null && FeatureToggle.TWEAK_BLOCK_TYPE_BREAK_RESTRICTION.getBooleanValue() && !BLOCK_TYPE_BREAK_RESTRICTION.isAllowed((Object)(state = world.getBlockState(pos)).getBlock())) {
            MessageOutputType type = (MessageOutputType)Configs.Generic.BLOCK_TYPE_BREAK_RESTRICTION_WARN.getOptionListValue();
            if (type == MessageOutputType.MESSAGE) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakeroo.message.warning.block_type_break_restriction", (Object[])new Object[0]);
            } else if (type == MessageOutputType.ACTIONBAR) {
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.warning.block_type_break_restriction", (Object[])new Object[0]);
            }
            return false;
        }
        boolean restrictionEnabled = FeatureToggle.TWEAK_BREAKING_RESTRICTION.getBooleanValue();
        boolean gridEnabled = FeatureToggle.TWEAK_BREAKING_GRID.getBooleanValue();
        if (!restrictionEnabled && !gridEnabled) {
            return true;
        }
        int gridSize = Configs.Generic.BREAKING_GRID_SIZE.getIntegerValue();
        PlacementRestrictionMode mode = (PlacementRestrictionMode)Configs.Generic.BREAKING_RESTRICTION_MODE.getOptionListValue();
        return posFirstBreaking == null || PlacementTweaks.isPositionAllowedByRestrictions(pos, side, posFirstBreaking, sideFirstBreaking, restrictionEnabled, mode, gridEnabled, gridSize);
    }

    private static boolean isPositionAllowedByRestrictions(BlockPos pos, Direction side, BlockPos posFirst, Direction sideFirst, boolean restrictionEnabled, PlacementRestrictionMode mode, boolean gridEnabled, int gridSize) {
        if (gridEnabled && (Math.abs(pos.getX() - posFirst.getX()) % gridSize != 0 || Math.abs(pos.getY() - posFirst.getY()) % gridSize != 0 || Math.abs(pos.getZ() - posFirst.getZ()) % gridSize != 0)) {
            return false;
        }
        if (restrictionEnabled) {
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case PlacementRestrictionMode.COLUMN -> PlacementTweaks.isNewPositionValidForColumnMode(pos, posFirst, sideFirst);
                case PlacementRestrictionMode.DIAGONAL -> PlacementTweaks.isNewPositionValidForDiagonalMode(pos, posFirst, sideFirst);
                case PlacementRestrictionMode.FACE -> PlacementTweaks.isNewPositionValidForFaceMode(pos, side, sideFirst);
                case PlacementRestrictionMode.LAYER -> PlacementTweaks.isNewPositionValidForLayerMode(pos, posFirst, sideFirst);
                case PlacementRestrictionMode.LINE -> PlacementTweaks.isNewPositionValidForLineMode(pos, posFirst, sideFirst);
                case PlacementRestrictionMode.PLANE -> PlacementTweaks.isNewPositionValidForPlaneMode(pos, posFirst, sideFirst);
            };
        }
        return true;
    }

    private static BlockPos getPlacementPositionForTargetedPosition(Level world, BlockPos pos, Direction side, BlockPlaceContext useContext) {
        if (PlacementTweaks.canPlaceBlockIntoPosition(world, pos, useContext)) {
            return pos;
        }
        return pos.relative(side);
    }

    private static boolean canPlaceBlockIntoPosition(Level world, BlockPos pos, BlockPlaceContext useContext) {
        BlockState state = world.getBlockState(pos);
        return state.canBeReplaced(useContext) || state.liquid() || state.canBeReplaced();
    }

    private static boolean isNewPositionValidForColumnMode(BlockPos posNew, BlockPos posFirst, Direction sideFirst) {
        Direction.Axis axis = sideFirst.getAxis();
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (posNew.getY() == posFirst.getY() && posNew.getZ() == posFirst.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (posNew.getX() == posFirst.getX() && posNew.getZ() == posFirst.getZ()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> posNew.getX() == posFirst.getX() && posNew.getY() == posFirst.getY();
        };
    }

    private static boolean isNewPositionValidForDiagonalMode(BlockPos posNew, BlockPos posFirst, Direction sideFirst) {
        Direction.Axis axis = sideFirst.getAxis();
        BlockPos relativePos = posNew.subtract((Vec3i)posFirst);
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (posNew.getX() == posFirst.getX() && Math.abs(relativePos.getY()) == Math.abs(relativePos.getZ())) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (posNew.getY() == posFirst.getY() && Math.abs(relativePos.getX()) == Math.abs(relativePos.getZ())) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> posNew.getZ() == posFirst.getZ() && Math.abs(relativePos.getX()) == Math.abs(relativePos.getY());
        };
    }

    private static boolean isNewPositionValidForFaceMode(BlockPos posNew, Direction side, Direction sideFirst) {
        return side == sideFirst;
    }

    private static boolean isNewPositionValidForLayerMode(BlockPos posNew, BlockPos posFirst, Direction sideFirst) {
        int height = Configs.Generic.RESTRICTION_LAYER_HEIGHT.getIntegerValue();
        if (height > 0) {
            int diff = posNew.getY() - posFirst.getY() + 1;
            return diff > 0 && diff <= height;
        }
        if (height < 0) {
            int diff = posFirst.getY() - posNew.getY() + 1;
            return diff > 0 && diff <= -height;
        }
        return true;
    }

    private static boolean isNewPositionValidForLineMode(BlockPos posNew, BlockPos posFirst, Direction sideFirst) {
        Direction.Axis axis = sideFirst.getAxis();
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (posNew.getX() == posFirst.getX() && (posNew.getY() == posFirst.getY() || posNew.getZ() == posFirst.getZ())) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (posNew.getY() == posFirst.getY() && (posNew.getX() == posFirst.getX() || posNew.getZ() == posFirst.getZ())) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> posNew.getZ() == posFirst.getZ() && (posNew.getX() == posFirst.getX() || posNew.getY() == posFirst.getY());
        };
    }

    private static boolean isNewPositionValidForPlaneMode(BlockPos posNew, BlockPos posFirst, Direction sideFirst) {
        Direction.Axis axis = sideFirst.getAxis();
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (posNew.getX() == posFirst.getX()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (posNew.getY() == posFirst.getY()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> posNew.getZ() == posFirst.getZ();
        };
    }

    public static boolean shouldSkipSlotSync(int slotNumber, ItemStack newStack) {
        AbstractContainerMenu container;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        AbstractContainerMenu abstractContainerMenu = container = player != null ? player.containerMenu : null;
        if (Configs.Generic.SLOT_SYNC_WORKAROUND.getBooleanValue() && !FeatureToggle.TWEAK_PICK_BEFORE_PLACE.getBooleanValue() && container != null && container == player.inventoryMenu && (slotNumber == 45 || slotNumber - 36 == player.getInventory().selected)) {
            if (mc.options.keyUse.isDown() && (Configs.Generic.SLOT_SYNC_WORKAROUND_ALWAYS.getBooleanValue() || FeatureToggle.TWEAK_FAST_BLOCK_PLACEMENT.getBooleanValue() || FeatureToggle.TWEAK_FAST_RIGHT_CLICK.getBooleanValue())) {
                return true;
            }
            return mc.options.keyAttack.isDown() && FeatureToggle.TWEAK_FAST_LEFT_CLICK.getBooleanValue();
        }
        return false;
    }

    static {
        stackBeforeUse = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY};
        hotbarSlot = -1;
        stackClickedOn = ItemStack.EMPTY;
        stateClickedOn = null;
        BLOCK_TYPE_BREAK_RESTRICTION = new BlockRestriction();
        FAST_RIGHT_CLICK_BLOCK_RESTRICTION = new BlockRestriction();
        FAST_RIGHT_CLICK_ITEM_RESTRICTION = new ItemRestriction();
        FAST_PLACEMENT_ITEM_RESTRICTION = new ItemRestriction();
        HAND_RESTOCK_RESTRICTION = new ItemRestriction();
    }
}

