/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.restrictions.UsageRestriction;
import fi.dy.masa.tweakeroo.Tweakeroo;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemRestriction {
    private UsageRestriction.ListType type = UsageRestriction.ListType.NONE;
    private final HashSet<Item> blackList = new HashSet();
    private final HashSet<Item> whiteList = new HashSet();

    public void setValues(UsageRestriction.ListType type, List<String> namesBlacklist, List<String> namesWhitelist) {
        this.type = type;
        this.setValuesForList(UsageRestriction.ListType.BLACKLIST, namesBlacklist);
        this.setValuesForList(UsageRestriction.ListType.WHITELIST, namesWhitelist);
    }

    protected void setValuesForList(UsageRestriction.ListType type, List<String> names) {
        HashSet<Item> set = type == UsageRestriction.ListType.WHITELIST ? this.whiteList : this.blackList;
        set.clear();
        for (String name : names) {
            try {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)name));
                if (item != null && item != Items.AIR) {
                    set.add(item);
                    continue;
                }
                Tweakeroo.LOGGER.warn("Invalid item name in a black- or whitelist: '{}", (Object)name);
            }
            catch (Exception e) {
                Tweakeroo.LOGGER.warn("Invalid item name in a black- or whitelist: '{}", (Object)name, (Object)e);
            }
        }
    }

    public boolean isItemAllowed(ItemStack stack) {
        switch (this.type) {
            case BLACKLIST: {
                return !this.blackList.contains(stack.getItem());
            }
            case WHITELIST: {
                return this.whiteList.contains(stack.getItem());
            }
        }
        return true;
    }
}

