/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.world;

import fi.dy.masa.tweakeroo.world.FakeWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class FakeChunk
extends LevelChunk {
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private final int bottomY;
    private final int topY;
    private boolean isEmpty = true;

    public FakeChunk(FakeWorld world, ChunkPos pos) {
        super((Level)world, pos);
        this.bottomY = world.getMinBuildHeight();
        this.topY = world.getMaxBuildHeight();
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection chunkSection;
        int x = pos.getX() & 0xF;
        int y = pos.getY();
        int z = pos.getZ() & 0xF;
        int cy = this.getSectionIndex(y);
        y &= 0xF;
        LevelChunkSection[] sections = this.getSections();
        if (cy >= 0 && cy < sections.length && !(chunkSection = sections[cy]).hasOnlyAir()) {
            return chunkSection.getBlockState(x, y, z);
        }
        return AIR;
    }

    public BlockState setBlockState(BlockPos pos, BlockState state, boolean flags) {
        BlockState stateOld = this.getBlockState(pos);
        int y = pos.getY();
        if (stateOld == state || y >= this.topY || y < this.bottomY) {
            return null;
        }
        int x = pos.getX() & 0xF;
        int z = pos.getZ() & 0xF;
        int cy = this.getSectionIndex(y);
        Block blockNew = state.getBlock();
        Block blockOld = stateOld.getBlock();
        LevelChunkSection section = this.getSections()[cy];
        if (section.hasOnlyAir() && state.isAir()) {
            return null;
        }
        y &= 0xF;
        if (!state.isAir()) {
            this.isEmpty = false;
        }
        section.setBlockState(x, y, z, state);
        if (blockOld != blockNew) {
            this.getLevel().removeBlockEntity(pos);
        }
        if (section.getBlockState(x, y, z).getBlock() != blockNew) {
            return null;
        }
        this.isUnsaved();
        return stateOld;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

