/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.command;

import fi.dy.masa.malilib.interfaces.IClientCommandListener;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class FcCommand
implements IClientCommandListener {
    private final String PREFIX = "tweakeroo.message.free_cam.preset";

    public String getCommand() {
        return "#fc";
    }

    public boolean execute(List<String> args, Minecraft mc) {
        ArrayList<String> list = new ArrayList<String>(args);
        list.removeFirst();
        if (!list.isEmpty()) {
            Sub sub = Sub.fromString((String)list.getFirst());
            if (sub != null) {
                list.removeFirst();
                if (sub.needsArgs() && list.isEmpty()) {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_enough_args_given", (Object[])new Object[0]));
                    return true;
                }
                return switch (sub.getName().toLowerCase()) {
                    case "add" -> this.executeAdd(list, mc);
                    case "set" -> this.executeSet(list, mc);
                    case "del" -> this.executeDel(list, mc);
                    case "del_all" -> this.executeDelAll(list, mc);
                    case "list" -> this.executeList(list, mc);
                    case "rename" -> this.executeRename(list, mc);
                    case "recall" -> this.executeRecall(list, mc);
                    case "cycle" -> this.executeCycle(list, mc);
                    case "help" -> this.executeHelp(list, mc);
                    default -> this.executeInvalid(mc);
                };
            }
        } else {
            if (!FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
                FeatureToggle.TWEAK_FREE_CAMERA.setBooleanValue(true);
                InfoUtils.printBooleanConfigToggleMessage((String)FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), (boolean)true);
                return true;
            }
            FeatureToggle.TWEAK_FREE_CAMERA.setBooleanValue(false);
            InfoUtils.printBooleanConfigToggleMessage((String)FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), (boolean)false);
            return true;
        }
        return this.executeInvalid(mc);
    }

    private boolean executeInvalid(Minecraft mc) {
        mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid_operation", (Object[])new Object[0]));
        return true;
    }

    private boolean executeAdd(List<String> args, Minecraft mc) {
        if (mc.level != null && mc.getCameraEntity() != null) {
            Object name;
            ResourceKey dimKey = mc.level.dimension();
            Entity camera = mc.getCameraEntity();
            int id = CameraPresetManager.getInstance().getNextId(-1);
            CameraPreset newPreset = new CameraPreset(id, (String)(name = !args.isEmpty() ? CameraUtils.fixPresetName(args.toString()) : "Preset " + id), dimKey.location(), camera.position(), camera.getYRot(), camera.getXRot());
            if (CameraUtils.addPreset(newPreset)) {
                InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_added", (Object[])new Object[]{newPreset.toShortString()}), (Object[])new Object[0]);
            } else {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_already_in_use", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private boolean executeSet(List<String> args, Minecraft mc) {
        if (mc.level != null && mc.getCameraEntity() != null) {
            try {
                int id = Integer.parseInt(args.getFirst());
                if (CameraPresetManager.getInstance().hasId(id)) {
                    ResourceKey dimKey = mc.level.dimension();
                    Entity camera = mc.getCameraEntity();
                    CameraPreset oldPreset = CameraPresetManager.getInstance().get(id);
                    if (oldPreset != null) {
                        CameraPreset newPreset = new CameraPreset(id, oldPreset.getName(), dimKey.location(), camera.getEyePosition(), camera.getYRot(), camera.getXRot());
                        CameraUtils.updatePreset(newPreset);
                        InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_updated", (Object[])new Object[]{newPreset.toShortString()}), (Object[])new Object[0]);
                    }
                } else {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_found", (Object[])new Object[]{String.format("%02d", id)}));
                }
            }
            catch (Exception err) {
                Tweakeroo.LOGGER.error("FcCommand#set(): Exception; {}", (Object)err.getLocalizedMessage());
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid", (Object[])new Object[]{args.getFirst()}));
            }
        }
        return true;
    }

    private boolean executeDel(List<String> args, Minecraft mc) {
        try {
            if (!args.isEmpty()) {
                int id = Integer.parseInt(args.getFirst());
                if (CameraPresetManager.getInstance().hasId(id)) {
                    CameraPreset oldPreset = CameraPresetManager.getInstance().get(id);
                    if (CameraUtils.deletePreset(oldPreset)) {
                        InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_deleted", (Object[])new Object[]{oldPreset.toShortString()}), (Object[])new Object[0]);
                    }
                } else {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_found", (Object[])new Object[]{String.format("%02d", id)}));
                }
            } else if (mc.level != null && mc.getCameraEntity() != null) {
                CameraPreset oldPreset = CameraPresetManager.getInstance().getAtPosition(mc.getCameraEntity());
                if (CameraUtils.deletePresetAtPosition(mc) && oldPreset != null) {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_deleted", (Object[])new Object[]{oldPreset.toShortString()}), (Object[])new Object[0]);
                }
            }
        }
        catch (Exception err) {
            Tweakeroo.LOGGER.error("FcCommand#del(): Exception; {}", (Object)err.getLocalizedMessage());
            mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid", (Object[])new Object[]{args.getFirst()}));
        }
        return true;
    }

    private boolean executeDelAll(List<String> args, Minecraft mc) {
        ResourceKey dimKey;
        if (mc.level != null && CameraUtils.deleteAllPresets((ResourceKey<Level>)(dimKey = mc.level.dimension()))) {
            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_deleted_all_dim", (Object[])new Object[]{dimKey.location().toString()}), (Object[])new Object[0]);
        }
        return true;
    }

    private boolean executeList(List<String> args, Minecraft mc) {
        if (mc.level != null) {
            ResourceKey dimKey = mc.level.dimension();
            List<CameraPreset> list = CameraPresetManager.getInstance().toList((ResourceKey<Level>)dimKey);
            if (list.isEmpty()) {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_list_empty", (Object[])new Object[0]));
            } else {
                for (CameraPreset entry : list) {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_list", (Object[])new Object[]{entry.toShortString()}));
                }
            }
        }
        return true;
    }

    private boolean executeRename(List<String> args, Minecraft mc) {
        try {
            int id = Integer.parseInt(args.getFirst());
            if (CameraPresetManager.getInstance().hasId(id)) {
                args.removeFirst();
                if (!args.isEmpty()) {
                    CameraPreset oldPreset = CameraPresetManager.getInstance().get(id);
                    Object newName = CameraUtils.fixPresetName(args.toString());
                    if (oldPreset != null) {
                        if (((String)newName).isEmpty()) {
                            newName = "Preset " + oldPreset.getId();
                        }
                        if (CameraUtils.renamePreset(oldPreset, (String)newName)) {
                            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_renamed", (Object[])new Object[]{String.format("%02d", id), oldPreset.getName(), newName}), (Object[])new Object[0]);
                        }
                    }
                } else {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_enough_args_given", (Object[])new Object[0]));
                }
            } else {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_found", (Object[])new Object[]{String.format("%02d", id)}));
            }
        }
        catch (Exception err) {
            Tweakeroo.LOGGER.error("FcCommand#rename(): Exception; {}", (Object)err.getLocalizedMessage());
            mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid", (Object[])new Object[]{args.getFirst()}));
        }
        return true;
    }

    private boolean executeRecall(List<String> args, Minecraft mc) {
        try {
            int id = Integer.parseInt(args.getFirst());
            if (CameraPresetManager.getInstance().hasId(id)) {
                CameraPreset preset = CameraPresetManager.getInstance().get(id);
                if (preset != null && mc.level != null) {
                    if (mc.level.dimension().location().equals((Object)preset.getDim())) {
                        if (CameraUtils.recallPreset(preset, mc)) {
                            InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_recalled", (Object[])new Object[]{FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), String.format("%02d", preset.getId()), preset.getName()}), (Object[])new Object[0]);
                        } else {
                            mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_matches_camera", (Object[])new Object[]{String.format("%02d", preset.getId())}));
                        }
                    } else {
                        mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_wrong_dimension", (Object[])new Object[]{String.format("%02d", preset.getId()), preset.getName()}));
                    }
                }
            } else {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_not_found", (Object[])new Object[]{String.format("%02d", id)}));
            }
        }
        catch (Exception err) {
            Tweakeroo.LOGGER.error("FcCommand#recall(): Exception; {}", (Object)err.getLocalizedMessage());
            mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid", (Object[])new Object[]{args.getFirst()}));
        }
        return true;
    }

    private boolean executeCycle(List<String> args, Minecraft mc) {
        if (mc.level != null) {
            ResourceKey dimKey = mc.level.dimension();
            CameraPreset preset = null;
            boolean exception = false;
            if (args.isEmpty()) {
                preset = CameraPresetManager.getInstance().cycle((ResourceKey<Level>)dimKey);
            } else {
                try {
                    int id = Integer.parseInt(args.getFirst());
                    if (CameraPresetManager.getInstance().hasId(id)) {
                        preset = CameraPresetManager.getInstance().get(id);
                        CameraPresetManager.getInstance().setLastPreset(id);
                    }
                }
                catch (Exception err) {
                    Tweakeroo.LOGGER.error("FcCommand#cycle(): Exception; {}", (Object)err.getLocalizedMessage());
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid", (Object[])new Object[]{args.getFirst()}));
                    exception = true;
                }
            }
            if (preset != null) {
                if (CameraUtils.recallPreset(preset, mc)) {
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"tweakeroo.message.free_cam.preset_recalled", (Object[])new Object[]{FeatureToggle.TWEAK_FREE_CAMERA.getPrettyName(), String.format("%02d", preset.getId()), preset.getName()}), (Object[])new Object[0]);
                } else {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_matches_camera", (Object[])new Object[]{String.format("%02d", preset.getId())}));
                }
            } else if (!exception) {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_cycle_not_found", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private boolean executeHelp(List<String> args, Minecraft mc) {
        String prefix = "tweakeroo.message.free_cam.preset_help";
        if (!args.isEmpty()) {
            Sub sub = Sub.fromString(args.getFirst());
            if (sub != null) {
                String key = sub.getName();
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_help", (Object[])new Object[0]));
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)("tweakeroo.message.free_cam.preset_help." + key), (Object[])new Object[0]));
                if (!sub.getAlias().isEmpty()) {
                    mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_help_alias", (Object[])new Object[]{sub.getAlias().toString()}));
                }
            } else {
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_invalid_operation", (Object[])new Object[0]));
            }
        } else {
            mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_help", (Object[])new Object[0]));
            for (Sub entry : Sub.values()) {
                String key = entry.getName();
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)("tweakeroo.message.free_cam.preset_help." + key), (Object[])new Object[0]));
                if (entry.getAlias().isEmpty()) continue;
                mc.gui.getChat().addMessage(StringUtils.translateAsText((String)"tweakeroo.message.free_cam.preset_help_alias", (Object[])new Object[]{entry.getAlias().toString()}));
            }
        }
        return true;
    }

    public static enum Sub {
        ADD("add", false, List.of("a", "new")),
        SET("set", true, List.of("s", "update", "upd")),
        DEL("del", true, List.of("d", "delete")),
        DEL_ALL("del_all", false, List.of("da", "del-all")),
        LIST("list", false, List.of("l", "lst")),
        RENAME("rename", true, List.of("n", "ren")),
        RECALL("recall", true, List.of("r", "rec", "goto", "go")),
        CYCLE("cycle", false, List.of("c", "cyc")),
        HELP("help", false, List.of("h", "hlp"));

        private final String name;
        private final boolean needsArgs;
        private final List<String> alias;

        private Sub(String name, boolean needsArgs, List<String> alias) {
            this.name = name;
            this.needsArgs = needsArgs;
            this.alias = alias;
        }

        public String getName() {
            return this.name;
        }

        public boolean needsArgs() {
            return this.needsArgs;
        }

        public List<String> getAlias() {
            return this.alias;
        }

        @Nullable
        public static Sub fromString(String s) {
            for (Sub entry : Sub.values()) {
                if (entry.getName().equalsIgnoreCase(s)) {
                    return entry;
                }
                for (String alias : entry.getAlias()) {
                    if (!alias.equalsIgnoreCase(s)) continue;
                    return entry;
                }
            }
            return null;
        }
    }
}

