/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CameraPresetManager {
    private static final CameraPresetManager INSTANCE = new CameraPresetManager();
    private final List<CameraPreset> presets = new ArrayList<CameraPreset>();
    private CameraPreset selectedPreset = null;
    private int lastPreset = -1;

    public static CameraPresetManager getInstance() {
        return INSTANCE;
    }

    private CameraPresetManager() {
    }

    @Nullable
    public CameraPreset getSelectedPreset() {
        return this.selectedPreset;
    }

    public void setSelectedPreset(@Nullable CameraPreset preset) {
        this.selectedPreset = preset;
    }

    public boolean hasId(int id) {
        AtomicBoolean bool = new AtomicBoolean(false);
        this.presets.forEach(entry -> {
            if (entry.getId() == id) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public int getNextId(int start) {
        if (this.presets.isEmpty()) {
            return 1;
        }
        int index = Math.max(start, 1);
        for (CameraPreset entry : this.presets) {
            if (entry.getId() != index) continue;
            ++index;
        }
        if (this.hasId(index)) {
            return this.getNextId(index);
        }
        return index;
    }

    public boolean hasPosition(@Nonnull CameraPreset other) {
        AtomicBoolean bool = new AtomicBoolean(false);
        this.presets.forEach(ent -> {
            if (ent.equals(other)) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public boolean add(CameraPreset preset) {
        return this.add(preset, true);
    }

    public boolean add(CameraPreset preset, boolean message) {
        if (!this.hasId(preset.getId())) {
            if (this.hasPosition(preset)) {
                if (message) {
                    Tweakeroo.LOGGER.error("CameraPresetCache: Error adding new preset [{}]; A matching position already exists.", (Object)preset.getId());
                }
                return false;
            }
            this.presets.add(preset);
            this.presets.sort(Comparator.comparingInt(CameraPreset::getId));
            if (message) {
                Tweakeroo.LOGGER.info("CameraPresetCache: Added new preset [{}/{}]", (Object)preset.getId(), (Object)preset.getName());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public CameraPreset get(int id) {
        for (CameraPreset entry : this.presets) {
            if (entry.getId() != id) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public CameraPreset getAtPosition(@Nonnull Entity camera) {
        for (CameraPreset entry : this.presets) {
            if (!entry.equals(camera)) continue;
            return entry;
        }
        return null;
    }

    public boolean remove(int id) {
        return this.remove(id, true);
    }

    public boolean remove(int id, boolean message) {
        CameraPreset oldPreset = this.get(id);
        if (oldPreset != null) {
            this.presets.remove(oldPreset);
            if (message) {
                Tweakeroo.LOGGER.info("CameraPresetCache: Removed preset [{}/{}]", (Object)oldPreset.getId(), (Object)oldPreset.getName());
            }
            return true;
        }
        return false;
    }

    public boolean update(@Nonnull CameraPreset preset) {
        return this.update(preset, true);
    }

    public boolean update(@Nonnull CameraPreset preset, boolean message) {
        this.remove(preset.getId(), message);
        return this.add(preset, message);
    }

    public boolean isEmpty() {
        return this.presets.isEmpty();
    }

    public int size() {
        return this.presets.size();
    }

    public List<CameraPreset> toList() {
        ArrayList<CameraPreset> list = new ArrayList<CameraPreset>(this.presets);
        if (!list.isEmpty()) {
            list.sort(Comparator.comparingInt(CameraPreset::getId));
        }
        return list;
    }

    public boolean isEmpty(@Nonnull ResourceKey<Level> worldKey) {
        return this.toList(worldKey).isEmpty();
    }

    public int size(@Nonnull ResourceKey<Level> worldKey) {
        return this.toList(worldKey).size();
    }

    public List<CameraPreset> toList(@Nonnull ResourceKey<Level> worldKey) {
        ResourceLocation dim = worldKey.location();
        ArrayList<CameraPreset> list = new ArrayList<CameraPreset>();
        for (CameraPreset entry : this.presets) {
            if (entry == null || !entry.getDim().equals((Object)dim)) continue;
            list.add(entry);
        }
        list.sort(Comparator.comparingInt(CameraPreset::getId));
        return list;
    }

    public int getLastPreset() {
        return this.lastPreset;
    }

    public void setLastPreset(int id) {
        this.lastPreset = id;
    }

    @Nullable
    public CameraPreset cycle(@Nonnull ResourceKey<Level> worldKey) {
        CameraPreset last;
        ResourceLocation dim = worldKey.location();
        boolean getNext = this.lastPreset == -1;
        for (CameraPreset entry : this.presets) {
            if (entry == null || !entry.getDim().equals((Object)dim)) continue;
            if (getNext) {
                CameraPreset first;
                if (entry.getId() == this.lastPreset && (first = this.getFirst(worldKey)) != null) {
                    if (first.equals(entry)) {
                        return null;
                    }
                    this.lastPreset = first.getId();
                    return first;
                }
                this.lastPreset = entry.getId();
                return entry;
            }
            if (entry.getId() != this.lastPreset) continue;
            getNext = true;
        }
        if (this.lastPreset != -1 && (last = this.getLast(worldKey)) != null) {
            if (last.getId() == this.lastPreset) {
                this.lastPreset = -1;
                return this.getFirst(worldKey);
            }
            this.lastPreset = last.getId();
            return last;
        }
        return null;
    }

    @Nullable
    public CameraPreset getFirst(@Nonnull ResourceKey<Level> worldKey) {
        ResourceLocation dim = worldKey.location();
        for (CameraPreset entry : this.presets) {
            if (entry == null || !entry.getDim().equals((Object)dim)) continue;
            this.lastPreset = entry.getId();
            return entry;
        }
        return null;
    }

    @Nullable
    public CameraPreset getLast(@Nonnull ResourceKey<Level> worldKey) {
        ResourceLocation dim = worldKey.location();
        CameraPreset last = null;
        for (CameraPreset entry : this.presets) {
            if (entry == null || !entry.getDim().equals((Object)dim)) continue;
            last = entry;
        }
        if (last != null) {
            this.lastPreset = last.getId();
        }
        return last;
    }

    public void clear(@Nonnull ResourceKey<Level> worldKey) {
        this.clear(worldKey, true);
    }

    public void clear(@Nonnull ResourceKey<Level> worldKey, boolean message) {
        ResourceLocation dim = worldKey.location();
        ArrayList<CameraPreset> list = new ArrayList<CameraPreset>(this.presets);
        for (CameraPreset entry : list) {
            if (entry == null || !entry.getDim().equals((Object)dim)) continue;
            this.presets.remove(entry);
            if (!message) continue;
            Tweakeroo.LOGGER.info("CameraPresetCache: Clear preset [{}/{}]", (Object)entry.getId(), (Object)entry.getName());
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean message) {
        this.presets.clear();
        if (message) {
            Tweakeroo.LOGGER.warn("CameraPresetCache: All presets cleared.");
        }
    }

    @Nullable
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        List<CameraPreset> sorted = this.toList();
        if (sorted.isEmpty()) {
            return null;
        }
        JsonArray arr = new JsonArray();
        for (CameraPreset entry : sorted) {
            CameraPreset.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry).resultOrPartial().ifPresent(arg_0 -> ((JsonArray)arr).add(arg_0));
        }
        if (arr.size() > 0) {
            obj.add("list", (JsonElement)arr);
        }
        return obj;
    }

    public void fromJson(JsonElement ele) {
        try {
            JsonObject obj;
            if (ele.isJsonObject() && JsonUtils.hasArray((JsonObject)(obj = ele.getAsJsonObject()), (String)"list")) {
                JsonArray arr = obj.get("list").getAsJsonArray();
                this.presets.clear();
                for (int i = 0; i < arr.size(); ++i) {
                    CameraPreset entry = (CameraPreset)CameraPreset.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)arr.get(i)).getOrThrow();
                    if (entry == null) continue;
                    this.add(entry, false);
                }
            }
        }
        catch (Exception err) {
            Tweakeroo.LOGGER.error("CameraPresetCache#fromJson(): Exception deserializing Camera Presets; {}", (Object)err.getLocalizedMessage());
        }
    }
}

