/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.gui;

import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.gui.widgets.WidgetCameraPresetEntry;
import fi.dy.masa.tweakeroo.gui.widgets.WidgetCameraPresetList;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuiCameraPresetEditor
extends GuiListBase<CameraPreset, WidgetCameraPresetEntry, WidgetCameraPresetList>
implements ISelectionListener<CameraPreset> {
    private ResourceKey<Level> dimKey;
    private boolean showAll;

    public GuiCameraPresetEditor() {
        super(10, 44);
        this.title = StringUtils.translate((String)"tweakeroo.gui.title.camera_preset_editor", (Object[])new Object[0]);
        if (this.mc.level != null) {
            this.dimKey = this.mc.level.dimension();
            this.showAll = false;
        } else {
            this.dimKey = null;
            this.showAll = true;
        }
    }

    protected int getBrowserWidth() {
        return this.getScreenWidth() - 20;
    }

    protected int getBrowserHeight() {
        return this.getScreenHeight() - 80;
    }

    public void initGui() {
        super.initGui();
        int x = 12;
        int y = 24;
        x += this.createButton(x, y, -1, ButtonListener.Type.SHOW) + 4;
        int posX = this.getBrowserWidth() - 22;
        posX -= ButtonListener.Type.CLEAR.getDisplayName(new Object[0]).length() + 15;
        posX -= this.createButton(posX, y, -1, ButtonListener.Type.CLEAR) + 4;
        posX -= ButtonListener.Type.CREATE.getDisplayName(new Object[0]).length() + 15;
        posX -= this.createButton(posX, y, -1, ButtonListener.Type.CREATE) + 4;
        y += 22;
    }

    private int createButton(int x, int y, int width, ButtonListener.Type type) {
        ButtonListener listener = new ButtonListener(type, this);
        String dimStr = this.showAll ? StringUtils.translate((String)"tweakeroo.gui.label.preset_gui.all", (Object[])new Object[0]) : StringUtils.translate((String)"tweakeroo.gui.label.preset_gui.dim", (Object[])new Object[0]);
        String label = type.getDisplayName(dimStr);
        if (width == -1) {
            width = this.getStringWidth(label) + 10;
        }
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, label, new String[0]);
        if (type == ButtonListener.Type.SHOW) {
            button.setHoverStrings(new String[]{"tweakeroo.gui.button.hover.preset_gui.show"});
        }
        this.addButton((ButtonBase)button, listener);
        return width + 2;
    }

    public boolean shouldShowAll() {
        return this.showAll;
    }

    private void toggleShowAll(boolean toggle) {
        if (this.mc.level == null) {
            this.dimKey = null;
            this.showAll = true;
        } else {
            this.showAll = toggle;
        }
        this.reCreateListWidget();
    }

    protected WidgetCameraPresetList createListWidget(int listX, int listY) {
        return new WidgetCameraPresetList(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this.dimKey, this);
    }

    public void onSelectionChange(@Nullable CameraPreset entry) {
        CameraPreset old = CameraPresetManager.getInstance().getSelectedPreset();
        CameraPresetManager.getInstance().setSelectedPreset(old == entry ? null : entry);
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiCameraPresetEditor parent;
        private final Type type;

        public ButtonListener(Type type, GuiCameraPresetEditor parent) {
            this.type = type;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.SHOW) {
                this.parent.toggleShowAll(!this.parent.showAll);
            } else if (this.type == Type.CLEAR) {
                if (this.parent.showAll) {
                    CameraPresetManager.getInstance().clear();
                    InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"tweakeroo.message.free_cam.preset_deleted_all", (Object[])new Object[0]);
                } else {
                    CameraPresetManager.getInstance().clear(this.parent.dimKey);
                    InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"tweakeroo.message.free_cam.preset_deleted_all_dim", (Object[])new Object[]{this.parent.dimKey.location().toString()});
                }
            } else if (this.type == Type.CREATE) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.level != null && mc.getCameraEntity() != null) {
                    String name;
                    Entity camera = mc.getCameraEntity();
                    ResourceKey dimKey = mc.level.dimension();
                    int id = CameraPresetManager.getInstance().getNextId(-1);
                    CameraPreset newPreset = new CameraPreset(id, name = "Preset " + id, dimKey.location(), camera.position(), camera.getYRot(), camera.getXRot());
                    if (CameraUtils.addPreset(newPreset)) {
                        InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"tweakeroo.message.free_cam.preset_added", (Object[])new Object[]{newPreset.toShortString()});
                    } else {
                        InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"tweakeroo.message.free_cam.preset_already_in_use", (Object[])new Object[0]);
                    }
                }
            }
            if (this.parent.getListWidget() != null) {
                ((WidgetCameraPresetList)this.parent.getListWidget()).refreshEntries();
            }
            this.parent.initGui();
        }

        public static enum Type {
            SHOW("tweakeroo.gui.button.preset_gui.show"),
            CLEAR("tweakeroo.gui.button.preset_gui.clear"),
            CREATE("tweakeroo.gui.button.preset_gui.create");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getTranslationKey() {
                return this.translationKey;
            }

            public String getDisplayName(Object ... args) {
                return StringUtils.translate((String)this.getTranslationKey(), (Object[])args);
            }
        }
    }
}

