/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.entity;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import java.util.Collection;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Unique
    private boolean wasGammaOverriden = false;

    @Shadow
    public abstract InteractionHand getUsedItemHand();

    private MixinLivingEntity(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"tickEffects()V"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/network/syncher/SynchedEntityData;get(Lnet/minecraft/network/syncher/EntityDataAccessor;)Ljava/lang/Object;")}, cancellable=true)
    private void tweakeroo_removeOwnPotionEffects(CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (Configs.Disable.DISABLE_FP_EFFECT_PARTICLES.getBooleanValue() && this == mc.player && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
            ci.cancel();
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFallFlying()Z")})
    private void tweakeroo_applyCustomDeceleration(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_CUSTOM_FLY_DECELERATION.getBooleanValue() && this == Minecraft.getInstance().player) {
            MiscUtils.handlePlayerDeceleration();
        }
    }

    @Inject(method={"completeUsingItem()V"}, at={@At(value="RETURN")})
    private void tweakeroo_onItemConsumed(CallbackInfo ci) {
        MixinLivingEntity mixinLivingEntity;
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && (mixinLivingEntity = this) instanceof Player) {
            Player player = (Player)mixinLivingEntity;
            PlacementTweaks.onProcessRightClickPost(player, this.getUsedItemHand());
        }
    }

    @Inject(method={"onEffectAdded(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void tweakeroo$onStatusEffectApplied(MobEffectInstance effect, Entity source, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_GAMMA_OVERRIDE.getBooleanValue() && effect.getEffect() == MobEffects.NIGHT_VISION) {
            MiscUtils.toggleGammaOverrideWithMessage();
            this.wasGammaOverriden = true;
        }
    }

    @Inject(method={"onEffectUpdated(Lnet/minecraft/world/effect/MobEffectInstance;ZLnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void tweakeroo$onStatusEffectUpgraded(MobEffectInstance effect, boolean reapplyEffect, Entity source, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_GAMMA_OVERRIDE.getBooleanValue() && effect.getEffect() == MobEffects.NIGHT_VISION) {
            MiscUtils.toggleGammaOverrideWithMessage();
            this.wasGammaOverriden = true;
        }
    }

    @Inject(method={"onEffectsRemoved(Ljava/util/Collection;)V"}, at={@At(value="HEAD")})
    private void tweakeroo$onStatusEffectRemoved(Collection<MobEffectInstance> effects, CallbackInfo ci) {
        if (this.wasGammaOverriden) {
            for (MobEffectInstance entry : effects) {
                if (entry.getEffect() != MobEffects.NIGHT_VISION) continue;
                if (!FeatureToggle.TWEAK_GAMMA_OVERRIDE.getBooleanValue()) {
                    MiscUtils.toggleGammaOverrideWithMessage();
                }
                this.wasGammaOverriden = false;
                break;
            }
        }
    }
}

