/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.screen;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.input.KeyEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen {
    @Shadow
    protected EditBox input;
    @Mutable
    @Shadow
    protected String initial;

    @Inject(method={"removed()V"}, at={@At(value="HEAD")})
    private void tweakeroo_storeChatText(CallbackInfo ci) {
        if (FeatureToggle.TWEAK_CHAT_PERSISTENT_TEXT.getBooleanValue()) {
            MiscUtils.setLastChatText(this.input.getValue());
        }
    }

    @Inject(method={"<init>(Ljava/lang/String;Z)V"}, at={@At(value="RETURN")})
    private void tweakeroo_restoreText(String text, boolean draft, CallbackInfo ci) {
        if (FeatureToggle.TWEAK_CHAT_PERSISTENT_TEXT.getBooleanValue() && !MiscUtils.getLastChatText().isEmpty()) {
            this.initial = MiscUtils.getLastChatText();
        }
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen;handleChatInput(Ljava/lang/String;Z)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", shift=At.Shift.AFTER)})
    private void tweakeroo_onSendMessage(KeyEvent input, CallbackInfoReturnable<Boolean> cir) {
        MiscUtils.setLastChatText("");
    }

    @ModifyConstant(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, constant={@Constant(intValue=-2147483648)})
    private int overrideChatBackgroundColor(int original) {
        if (FeatureToggle.TWEAK_CHAT_BACKGROUND_COLOR.getBooleanValue()) {
            return Configs.Generic.CHAT_BACKGROUND_COLOR.getIntegerValue();
        }
        return original;
    }
}

