/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.mixin.world;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class MixinWorld {
    @Shadow
    @Final
    private boolean isClientSide;

    @Inject(method={"tickBlockEntities()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableBlockEntityTicking(CallbackInfo ci) {
        if (Configs.Disable.DISABLE_TILE_ENTITY_TICKING.getBooleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"guardEntityTick(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void preventEntityTicking(Consumer<T> consumer, T entityIn, CallbackInfo ci) {
        if (Configs.Disable.DISABLE_ENTITY_TICKING.getBooleanValue() && !(entityIn instanceof Player)) {
            ci.cancel();
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void setBlockStateInject(BlockPos pos, BlockState state, int flags, int maxUpdateDepth, CallbackInfoReturnable<Boolean> ci) {
        if (!this.isClientSide) {
            return;
        }
        if (!RenderTweaks.isPositionValidForRendering(pos)) {
            if ((flags & 0x400) != 0) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            RenderTweaks.setFakeBlockState((Level)mc.level, pos, state, null);
            ci.setReturnValue((Object)false);
        }
    }
}

