/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class CameraEntity
extends LocalPlayer {
    @Nullable
    private static CameraEntity camera;
    @Nullable
    private static Entity originalCameraEntity;
    private static Vec3 cameraMotion;
    private static boolean cullChunksOriginal;
    private static boolean sprinting;
    private static boolean originalCameraWasPlayer;

    private CameraEntity(Minecraft mc, ClientLevel world, ClientPacketListener netHandler, StatsCounter stats, ClientRecipeBook recipeBook, Input input, boolean sprinting) {
        super(mc, world, netHandler, stats, recipeBook, input, sprinting);
    }

    public boolean isSpectator() {
        return true;
    }

    public int getId() {
        if (originalCameraEntity != null) {
            return originalCameraEntity.getId();
        }
        return super.getId();
    }

    public static void movementTick() {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue()) {
            Options options = Minecraft.getInstance().options;
            camera.updateLastTickPosition();
            if (options.keySprint.isDown()) {
                sprinting = true;
            } else if (!options.keyUp.isDown() && !options.keyDown.isDown()) {
                sprinting = false;
            }
            cameraMotion = MiscUtils.calculatePlayerMotionWithDeceleration(cameraMotion, 0.15, 0.4);
            double forward = sprinting ? CameraEntity.cameraMotion.x * 3.0 : CameraEntity.cameraMotion.x;
            camera.handleMotion(forward, CameraEntity.cameraMotion.y, CameraEntity.cameraMotion.z);
        }
    }

    private static double getMoveSpeed() {
        double base = 0.07;
        if (FeatureToggle.TWEAK_FLY_SPEED.getBooleanValue()) {
            base = Configs.getActiveFlySpeedConfig().getDoubleValue();
        }
        return base * 10.0;
    }

    private void handleMotion(double forward, double up, double strafe) {
        float yaw = this.getYRot();
        double scale = CameraEntity.getMoveSpeed();
        double xFactor = Math.sin((double)yaw * Math.PI / 180.0);
        double zFactor = Math.cos((double)yaw * Math.PI / 180.0);
        double x = (strafe * zFactor - forward * xFactor) * scale;
        double y = up * scale;
        double z = (forward * zFactor + strafe * xFactor) * scale;
        this.setDeltaMovement(new Vec3(x, y, z));
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    private void updateLastTickPosition() {
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.yHeadRotO = this.yHeadRot;
    }

    public void setCameraRotations(float yaw, float pitch) {
        this.setYRot(yaw);
        this.setXRot(pitch);
        this.yHeadRot = yaw;
    }

    public void updateCameraRotations(float yawChange, float pitchChange) {
        float yaw = this.getYRot() + yawChange * 0.15f;
        float pitch = Mth.clamp((float)(this.getXRot() + pitchChange * 0.15f), (float)-90.0f, (float)90.0f);
        this.setYRot(yaw);
        this.setXRot(pitch);
        this.setCameraRotations(yaw, pitch);
    }

    private static CameraEntity createCameraEntity(Minecraft mc) {
        if (mc.player == null || mc.level == null) {
            throw new RuntimeException("Cannot create CameraEntity from null!");
        }
        LocalPlayer player = mc.player;
        Vec3 entityPos = player.position();
        float yaw = player.getYRot();
        float pitch = player.getXRot();
        if (mc.player.onGround()) {
            mc.player.setDeltaMovement(Vec3.ZERO);
        }
        CameraEntity camera = new CameraEntity(mc, mc.level, player.connection, player.getStats(), player.getRecipeBook(), Input.EMPTY, false);
        camera.noPhysics = true;
        camera.setPosRaw(entityPos.x(), entityPos.y() + 0.125, entityPos.z());
        camera.setYRot(yaw);
        camera.setXRot(pitch);
        camera.setDeltaMovement(Vec3.ZERO);
        return camera;
    }

    public static void updatePositionAtPreset(@Nonnull CameraPreset preset) {
        if (camera != null && CameraEntity.isValidDim(camera.level(), preset.getDim())) {
            camera.setPosRaw(preset.getPos().x(), preset.getPos().y(), preset.getPos().z());
            camera.setYRot(preset.getYaw());
            camera.setXRot(preset.getPitch());
            camera.setDeltaMovement(Vec3.ZERO);
        }
    }

    @ApiStatus.Experimental
    private static CameraEntity createCameraAtPreset(Minecraft mc, @Nonnull CameraPreset preset) {
        if (mc.player == null || mc.level == null) {
            throw new RuntimeException("Cannot create CameraEntity from null!");
        }
        LocalPlayer player = mc.player;
        if (mc.player.onGround()) {
            mc.player.setDeltaMovement(Vec3.ZERO);
        }
        CameraEntity camera = new CameraEntity(mc, mc.level, player.connection, player.getStats(), player.getRecipeBook(), Input.EMPTY, false);
        camera.noPhysics = true;
        camera.setPosRaw(preset.getPos().x(), preset.getPos().y(), preset.getPos().z());
        camera.setYRot(preset.getYaw());
        camera.setXRot(preset.getPitch());
        camera.setDeltaMovement(Vec3.ZERO);
        return camera;
    }

    @Nullable
    public static CameraEntity getCamera() {
        return camera;
    }

    public static void setCameraState(boolean enabled, @Nullable CameraPreset preset) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            ResourceKey dim = mc.level.dimension();
            if (enabled && preset != null && preset.getId() > -1) {
                if (preset.getDim().equals((Object)dim.location())) {
                    CameraEntity.createAndSetCameraAtPreset(mc, preset);
                } else {
                    Tweakeroo.LOGGER.error("freeCam: Recalled preset is in a different Dimension: [{}]", (Object)preset.getDim().toString());
                }
            } else if (enabled) {
                CameraEntity.createAndSetCamera(mc);
            } else {
                CameraEntity.removeCamera(mc);
            }
        }
    }

    public static boolean originalCameraWasPlayer() {
        return originalCameraWasPlayer;
    }

    private static void createAndSetCamera(Minecraft mc) {
        camera = CameraEntity.createCameraEntity(mc);
        CameraEntity.setCamera(mc);
    }

    @ApiStatus.Experimental
    private static void createAndSetCameraAtPreset(Minecraft mc, CameraPreset preset) {
        if (CameraEntity.isValidDim((Level)mc.level, preset.getDim())) {
            camera = CameraEntity.createCameraAtPreset(mc, preset);
            CameraEntity.setCamera(mc);
        }
    }

    private static void setCamera(Minecraft mc) {
        originalCameraEntity = mc.getCameraEntity();
        originalCameraWasPlayer = originalCameraEntity == mc.player;
        cullChunksOriginal = mc.smartCull;
        mc.setCameraEntity((Entity)camera);
        mc.smartCull = false;
        Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.setBooleanValue(false);
    }

    private static void removeCamera(Minecraft mc) {
        if (mc.level != null && camera != null) {
            mc.setCameraEntity((Entity)(originalCameraWasPlayer ? mc.player : originalCameraEntity));
            mc.smartCull = cullChunksOriginal;
            int chunkX = Mth.floor((double)(camera.getX() / 16.0)) >> 4;
            int chunkZ = Mth.floor((double)(camera.getZ() / 16.0)) >> 4;
            CameraUtils.markChunksForRebuildOnDeactivation(chunkX, chunkZ);
        }
        originalCameraEntity = null;
        camera = null;
    }

    private static boolean isValidDim(Level world, ResourceLocation dim) {
        if (world == null) {
            return false;
        }
        return world.dimension().location().equals((Object)dim);
    }

    static {
        cameraMotion = new Vec3(0.0, 0.0, 0.0);
    }
}

