/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class CameraUtils {
    private static float cameraYaw;
    private static float cameraPitch;
    private static boolean freeCameraSpectator;

    public static void setFreeCameraSpectator(boolean isSpectator) {
        freeCameraSpectator = isSpectator;
    }

    public static boolean getFreeCameraSpectator() {
        return freeCameraSpectator;
    }

    public static boolean shouldPreventPlayerInputs() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_INPUTS.getBooleanValue();
    }

    public static boolean shouldPreventPlayerMovement() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue();
    }

    public static float getCameraYaw() {
        return Mth.wrapDegrees((float)cameraYaw);
    }

    public static float getCameraPitch() {
        return Mth.wrapDegrees((float)cameraPitch);
    }

    public static void setCameraYaw(float yaw) {
        cameraYaw = yaw;
    }

    public static void setCameraPitch(float pitch) {
        cameraPitch = pitch;
    }

    public static void setCameraRotations(float yaw, float pitch) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.setCameraRotations(yaw, pitch);
        }
    }

    public static void updateCameraRotations(float yawChange, float pitchChange) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.updateCameraRotations(yawChange, pitchChange);
        }
    }

    public static void markChunksForRebuild(int chunkX, int chunkZ, int lastChunkX, int lastChunkZ) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || chunkX == lastChunkX && chunkZ == lastChunkZ) {
            return;
        }
        int viewDistance = (Integer)mc.options.renderDistance().get();
        if (chunkX != lastChunkX) {
            int minCX = chunkX > lastChunkX ? lastChunkX + viewDistance : chunkX - viewDistance;
            int maxCX = chunkX > lastChunkX ? chunkX + viewDistance : lastChunkX - viewDistance;
            for (int cx = minCX; cx <= maxCX; ++cx) {
                for (int cz = chunkZ - viewDistance; cz <= chunkZ + viewDistance; ++cz) {
                    if (!CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
                }
            }
        }
        if (chunkZ != lastChunkZ) {
            int minCZ = chunkZ > lastChunkZ ? lastChunkZ + viewDistance : chunkZ - viewDistance;
            int maxCZ = chunkZ > lastChunkZ ? chunkZ + viewDistance : lastChunkZ - viewDistance;
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = chunkX - viewDistance; cx <= chunkX + viewDistance; ++cx) {
                    if (!CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
                }
            }
        }
    }

    public static void markChunksForRebuildOnDeactivation(int lastChunkX, int lastChunkZ) {
        Minecraft mc = Minecraft.getInstance();
        int viewDistance = (Integer)mc.options.renderDistance().get();
        Entity entity = EntityUtils.getCameraEntity();
        if (mc.level == null || entity == null) {
            return;
        }
        int chunkX = Mth.floor((double)(entity.getX() / 16.0)) >> 4;
        int chunkZ = Mth.floor((double)(entity.getZ() / 16.0)) >> 4;
        int minCameraCX = lastChunkX - viewDistance;
        int maxCameraCX = lastChunkX + viewDistance;
        int minCameraCZ = lastChunkZ - viewDistance;
        int maxCameraCZ = lastChunkZ + viewDistance;
        int minCX = chunkX - viewDistance;
        int maxCX = chunkX + viewDistance;
        int minCZ = chunkZ - viewDistance;
        int maxCZ = chunkZ + viewDistance;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                if (cx >= minCameraCX && cx <= maxCameraCX && cz >= minCameraCZ && cz <= maxCameraCZ || !CameraUtils.isClientChunkLoaded(mc.level, cx, cz)) continue;
                CameraUtils.markChunkForReRender(mc.levelRenderer, cx, cz);
            }
        }
    }

    public static void markChunkForReRender(LevelRenderer renderer, int chunkX, int chunkZ) {
        for (int cy = 0; cy < 16; ++cy) {
            renderer.setSectionDirty(chunkX, cy, chunkZ);
        }
    }

    public static boolean isClientChunkLoaded(ClientLevel world, int chunkX, int chunkZ) {
        return world.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
    }

    public static String fixPresetName(String in) {
        return in.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(",", "");
    }

    public static boolean addPreset(@Nonnull CameraPreset preset) {
        if (!CameraPresetManager.getInstance().hasPosition(preset)) {
            CameraPresetManager.getInstance().add(preset);
            Tweakeroo.debugLog("CameraUtils#addPreset(): Added new preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean updatePreset(@Nonnull CameraPreset preset) {
        CameraPresetManager.getInstance().update(preset, false);
        Tweakeroo.debugLog("CameraUtils#updatePreset(): Updated preset: {}", preset.toShortString());
        return true;
    }

    public static boolean deletePreset(@Nullable CameraPreset oldPreset) {
        if (oldPreset != null) {
            CameraPresetManager.getInstance().remove(oldPreset.getId(), false);
            Tweakeroo.debugLog("CameraUtils#deletePreset(): Deleted preset: {}", oldPreset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean deletePresetAtPosition(Minecraft mc) {
        CameraPreset preset;
        if (mc.getCameraEntity() != null && (preset = CameraPresetManager.getInstance().getAtPosition(mc.getCameraEntity())) != null) {
            CameraPresetManager.getInstance().remove(preset.getId(), false);
            Tweakeroo.debugLog("CameraUtils#deletePresetAtPosition(): Deleted preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean deleteAllPresets(ResourceKey<Level> dimKey) {
        if (dimKey != null) {
            CameraPresetManager.getInstance().clear(dimKey, false);
            Tweakeroo.debugLog("CameraUtils#deletePresetAtPosition(): Deleted all presets for dimension '{}'", dimKey.location().toString());
            return true;
        }
        return false;
    }

    public static boolean renamePreset(@Nullable CameraPreset preset, String newName) {
        if (preset != null) {
            String oldName = preset.getName();
            preset.setName(CameraUtils.fixPresetName(newName));
            CameraPresetManager.getInstance().update(preset, false);
            Tweakeroo.debugLog("CameraUtils#renamePreset(): Renamed preset: [{}] / '{}' -> '{}'", preset.getId(), oldName, preset.getName());
            return true;
        }
        return false;
    }

    public static boolean recallPreset(@Nonnull CameraPreset preset, Minecraft mc) {
        if (!preset.equals(mc.getCameraEntity()) && mc.level != null && mc.level.dimension().location().equals((Object)preset.getDim())) {
            CameraPresetManager.getInstance().setLastPreset(preset.getId());
            if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
                CameraEntity.updatePositionAtPreset(preset);
            } else {
                FeatureToggle.TWEAK_FREE_CAMERA.setEnabledNoCallback();
                CameraEntity.setCameraState(true, preset);
            }
            Tweakeroo.debugLog("CameraUtils#recallPreset(): Recall preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean cyclePreset(Minecraft mc) {
        if (mc.level != null) {
            ResourceKey dimKey = mc.level.dimension();
            CameraPreset preset = CameraPresetManager.getInstance().cycle((ResourceKey<Level>)dimKey);
            if (preset != null) {
                return CameraUtils.recallPreset(preset, mc);
            }
        }
        return false;
    }
}

