/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.EquipmentUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CachedTagManager;
import fi.dy.masa.tweakeroo.mixin.block.IMixinAbstractBlock;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtils {
    private static final List<EquipmentSlot> REPAIR_MODE_SLOTS = new ArrayList<EquipmentSlot>();
    private static final List<Integer> REPAIR_MODE_SLOT_NUMBERS = new ArrayList<Integer>();
    private static final HashSet<Item> UNSTACKING_ITEMS = new HashSet();
    private static final List<Integer> TOOL_SWITCHABLE_SLOTS = new ArrayList<Integer>();
    private static final List<Integer> TOOL_SWITCH_IGNORED_SLOTS = new ArrayList<Integer>();
    private static final HashMap<EntityType<?>, HashSet<Item>> WEAPON_MAPPING = new HashMap();
    private static boolean needsCache = false;

    public static void setToolSwitchableSlots(String configStr) {
        InventoryUtils.parseSlotsFromString(configStr, TOOL_SWITCHABLE_SLOTS);
    }

    public static void setToolSwitchIgnoreSlots(String configStr) {
        InventoryUtils.parseSlotsFromString(configStr, TOOL_SWITCH_IGNORED_SLOTS);
    }

    public static void parseSlotsFromString(String configStr, Collection<Integer> output) {
        String[] parts = configStr.split(",");
        Pattern patternRange = Pattern.compile("^(?<start>[0-9])-(?<end>[0-9])$");
        output.clear();
        if (configStr.isBlank()) {
            return;
        }
        for (String str : parts) {
            try {
                Matcher matcher = patternRange.matcher(str);
                if (matcher.matches()) {
                    int slotEnd;
                    int slotStart = Integer.parseInt(matcher.group("start")) - 1;
                    if (slotStart > (slotEnd = Integer.parseInt(matcher.group("end")) - 1) || !Inventory.isHotbarSlot((int)slotStart) || !Inventory.isHotbarSlot((int)slotEnd)) continue;
                    for (int slotNum = slotStart; slotNum <= slotEnd; ++slotNum) {
                        if (output.contains(slotNum)) continue;
                        output.add(slotNum);
                    }
                    continue;
                }
                int slotNum = Integer.parseInt(str) - 1;
                if (!Inventory.isHotbarSlot((int)slotNum) || output.contains(slotNum)) continue;
                output.add(slotNum);
            }
            catch (NumberFormatException ignore) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Failed to parse slots from string %s", (Object[])new Object[]{configStr});
            }
        }
    }

    public static void setUnstackingItems(List<String> names) {
        UNSTACKING_ITEMS.clear();
        for (String name : names) {
            try {
                Optional opt = BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)name));
                if (!opt.isPresent() || ((Holder.Reference)opt.get()).value() == Items.AIR) continue;
                UNSTACKING_ITEMS.add((Item)((Holder.Reference)opt.get()).value());
            }
            catch (Exception e) {
                Tweakeroo.LOGGER.warn("Failed to set an unstacking protected item from name '{}'", (Object)name, (Object)e);
            }
        }
    }

    public static void setRepairModeSlots(List<String> names) {
        REPAIR_MODE_SLOTS.clear();
        REPAIR_MODE_SLOT_NUMBERS.clear();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            EquipmentSlot type;
            String name;
            if ((type = (switch (name = iterator.next()) {
                case "mainhand" -> EquipmentSlot.MAINHAND;
                case "offhand" -> EquipmentSlot.OFFHAND;
                case "head" -> EquipmentSlot.HEAD;
                case "chest" -> EquipmentSlot.CHEST;
                case "legs" -> EquipmentSlot.LEGS;
                case "feet" -> EquipmentSlot.FEET;
                default -> null;
            })) == null) continue;
            REPAIR_MODE_SLOTS.add(type);
            int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, null);
            if (slotNum < 0) continue;
            REPAIR_MODE_SLOT_NUMBERS.add(slotNum);
        }
    }

    public static void setWeaponMapping(List<String> mappings) {
        WEAPON_MAPPING.clear();
        for (String mapping : mappings) {
            Optional opt2;
            String[] split = mapping.replaceAll(" ", "").split("=>");
            if (split.length != 2) {
                Tweakeroo.LOGGER.warn("Expected weapon mapping to be `entity_ids => weapon_ids` got '{}'", (Object)mapping);
                continue;
            }
            HashSet<Item> weapons = new HashSet<Item>();
            String entities = split[0].trim();
            String items = split[1].trim();
            if (!items.equals("<ignore>")) {
                for (String itemId : items.split(",")) {
                    try {
                        opt2 = BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)itemId));
                        if (opt2.isPresent()) {
                            weapons.add((Item)((Holder.Reference)opt2.get()).value());
                            continue;
                        }
                    }
                    catch (Exception opt2) {
                        // empty catch block
                    }
                    Tweakeroo.LOGGER.warn("Unable to find item to use as weapon: '{}'", (Object)itemId);
                }
            }
            if (entities.equalsIgnoreCase("<default>")) {
                WEAPON_MAPPING.computeIfAbsent(null, s -> new HashSet()).addAll(weapons);
                continue;
            }
            for (String entity_id : entities.split(",")) {
                try {
                    opt2 = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)entity_id));
                    if (opt2.isPresent()) {
                        WEAPON_MAPPING.computeIfAbsent((EntityType)((Holder.Reference)opt2.get()).value(), s -> new HashSet()).addAll(weapons);
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Tweakeroo.LOGGER.warn("Unable to find entity: '{}'", (Object)entity_id);
            }
        }
    }

    private static boolean isConfiguredRepairSlot(int slotNum, Player player) {
        if (REPAIR_MODE_SLOTS.contains(EquipmentSlot.MAINHAND) && slotNum - 36 == player.getInventory().getSelectedSlot()) {
            return true;
        }
        return REPAIR_MODE_SLOT_NUMBERS.contains(slotNum);
    }

    @Nullable
    private static EquipmentSlot getEquipmentTypeForSlot(int slotNum, Player player) {
        if (REPAIR_MODE_SLOTS.contains(EquipmentSlot.MAINHAND) && slotNum - 36 == player.getInventory().getSelectedSlot()) {
            return EquipmentSlot.MAINHAND;
        }
        return switch (slotNum) {
            case 45 -> EquipmentSlot.OFFHAND;
            case 5 -> EquipmentSlot.HEAD;
            case 6 -> EquipmentSlot.CHEST;
            case 7 -> EquipmentSlot.LEGS;
            case 8 -> EquipmentSlot.FEET;
            default -> null;
        };
    }

    private static int getSlotNumberForEquipmentType(EquipmentSlot type, @Nullable Player player) {
        return switch (type) {
            case EquipmentSlot.MAINHAND -> {
                if (player != null) {
                    yield player.getInventory().getSelectedSlot() + 36;
                }
                yield -1;
            }
            case EquipmentSlot.OFFHAND -> 45;
            case EquipmentSlot.HEAD -> 5;
            case EquipmentSlot.CHEST -> 6;
            case EquipmentSlot.LEGS -> 7;
            case EquipmentSlot.FEET -> 8;
            default -> -1;
        };
    }

    public static void swapHotbarWithInventoryRow(Player player, int row) {
        InventoryMenu container = player.inventoryMenu;
        row = Mth.clamp((int)row, (int)0, (int)2);
        int slot = row * 9 + 9;
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            fi.dy.masa.malilib.util.InventoryUtils.swapSlots((AbstractContainerMenu)container, (int)slot, (int)hotbarSlot);
            ++slot;
        }
    }

    public static void restockNewStackToHand(Player player, InteractionHand hand, ItemStack stackReference, boolean allowHotbar) {
        int slotWithItem;
        if (stackReference.isDamageableItem()) {
            int minDurability = InventoryUtils.getMinDurability(stackReference);
            slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((AbstractContainerMenu)player.inventoryMenu, stackReference, minDurability);
        } else {
            slotWithItem = InventoryUtils.findSlotWithItem((AbstractContainerMenu)player.inventoryMenu, stackReference, allowHotbar, true);
        }
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
        }
    }

    public static void preRestockHand(Player player, InteractionHand hand, boolean allowHotbar) {
        ItemStack stackHand = player.getItemInHand(hand);
        int threshold = Configs.Generic.HAND_RESTOCK_PRE_THRESHOLD.getIntegerValue();
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && Configs.Generic.HAND_RESTOCK_PRE.getBooleanValue() && !stackHand.isEmpty() && stackHand.getCount() <= threshold && stackHand.getMaxStackSize() > threshold && PlacementTweaks.canUseItemWithRestriction(PlacementTweaks.HAND_RESTOCK_RESTRICTION, stackHand) && player.containerMenu == player.inventoryMenu && player.containerMenu.getCarried().isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            InventoryMenu container = player.inventoryMenu;
            int endSlot = allowHotbar ? 44 : 35;
            int currentMainHandSlot = player.getInventory().getSelectedSlot() + 36;
            int currentSlot = hand == InteractionHand.MAIN_HAND ? currentMainHandSlot : 45;
            for (int slotNum = 9; slotNum <= endSlot; ++slotNum) {
                Slot slot;
                ItemStack stackSlot;
                if (slotNum == currentMainHandSlot || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((ItemStack)(stackSlot = (slot = (Slot)container.slots.get(slotNum)).getItem()), (ItemStack)stackHand)) continue;
                int button = stackSlot.getCount() + stackHand.getCount() <= stackHand.getMaxStackSize() ? 0 : 1;
                mc.gameMode.handleInventoryMouseClick(container.containerId, slot.index, button, ClickType.PICKUP, player);
                mc.gameMode.handleInventoryMouseClick(container.containerId, currentSlot, 0, ClickType.PICKUP, player);
                break;
            }
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() && player != null) {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(InteractionHand.MAIN_HAND, (Player)player);
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(InteractionHand.OFF_HAND, (Player)player);
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken(InteractionHand hand, Player player) {
        int minDurability;
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && InventoryUtils.isItemAtLowDurability(stack, minDurability = InventoryUtils.getMinDurability(stack))) {
            InventoryUtils.swapItemWithHigherDurabilityToHand(player, hand, stack, minDurability + 1);
        }
    }

    public static void trySwitchToWeapon(Entity entity) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && mc.level != null && !TOOL_SWITCH_IGNORED_SLOTS.contains(player.getInventory().getSelectedSlot())) {
            InventoryMenu container = player.inventoryMenu;
            if (player.getMainHandItem().is(Items.MACE)) {
                return;
            }
            ItemPickerTest test = FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() ? (currentStack, previous) -> InventoryUtils.isBetterWeaponAndHasDurability(currentStack, previous, entity) : (currentStack, previous) -> InventoryUtils.isBetterWeapon(currentStack, previous, entity);
            int slotNumber = InventoryUtils.findSlotWithBestItemMatch((AbstractContainerMenu)container, test, UniformInt.of((int)36, (int)44), UniformInt.of((int)9, (int)35));
            if (slotNumber != -1 && slotNumber - 36 != player.getInventory().getSelectedSlot()) {
                InventoryUtils.swapToolToHand(slotNumber, mc);
                PlacementTweaks.cacheStackInHand(InteractionHand.MAIN_HAND);
            }
        }
    }

    private static boolean isBetterWeapon(ItemStack testedStack, ItemStack previousWeapon, Entity entity) {
        boolean isWeapon = EquipmentUtils.isAnyWeapon((ItemStack)testedStack);
        if (testedStack.is(Items.MACE)) {
            return false;
        }
        if (previousWeapon.isEmpty() && isWeapon) {
            return true;
        }
        if (!testedStack.isEmpty() && isWeapon) {
            boolean mapping = InventoryUtils.matchesWeaponMapping(testedStack, entity);
            if (!InventoryUtils.matchesWeaponMapping(previousWeapon, entity)) {
                return true;
            }
            if (!mapping || testedStack.is(Items.MACE)) {
                return false;
            }
            return InventoryUtils.isBetterWeaponEach(testedStack, previousWeapon);
        }
        return false;
    }

    private static boolean isBetterWeaponEach(ItemStack testedStack, ItemStack previousWeapon) {
        double prev;
        boolean isRanged = EquipmentUtils.isRangedWeapon((ItemStack)testedStack);
        boolean enchants = Configs.Generic.WEAPON_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterWeaponEnchantments(testedStack, previousWeapon) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousWeapon);
        boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousWeapon);
        double tested = InventoryUtils.getBaseAttackDamage(testedStack);
        if (tested > (prev = InventoryUtils.getBaseAttackDamage(previousWeapon))) {
            return rarity || mats;
        }
        if (tested == prev) {
            return (rarity || mats) && enchants;
        }
        return false;
    }

    private static boolean isBetterWeaponAndHasDurability(ItemStack testedStack, ItemStack previousTool, Entity entity) {
        return InventoryUtils.hasEnoughDurability(testedStack) && InventoryUtils.isBetterWeapon(testedStack, previousTool, entity);
    }

    private static double getBaseAttackDamage(ItemStack stack) {
        Pair pair = EquipmentUtils.getDamageAndSpeedAttributes((ItemStack)stack);
        if ((Double)pair.getLeft() > 0.0) {
            return (Double)pair.getLeft();
        }
        return 0.0;
    }

    protected static boolean matchesWeaponMapping(ItemStack stack, Entity entity) {
        HashSet<Item> weapons = WEAPON_MAPPING.getOrDefault(entity.getType(), WEAPON_MAPPING.get(null));
        return weapons != null && weapons.contains(stack.getItem());
    }

    public static void trySwitchToEffectiveTool(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && mc.level != null && !TOOL_SWITCH_IGNORED_SLOTS.contains(player.getInventory().getSelectedSlot())) {
            BlockState state = mc.level.getBlockState(pos);
            InventoryMenu container = player.inventoryMenu;
            ItemPickerTest test = FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() ? (currentStack, previous) -> InventoryUtils.isBetterToolAndHasDurability(currentStack, previous, state) : (currentStack, previous) -> InventoryUtils.isBetterTool(currentStack, previous, state);
            int slotNumber = InventoryUtils.findSlotWithBestItemMatch((AbstractContainerMenu)container, test, UniformInt.of((int)36, (int)44), UniformInt.of((int)9, (int)35));
            if (slotNumber != -1 && slotNumber - 36 != player.getInventory().getSelectedSlot()) {
                InventoryUtils.swapToolToHand(slotNumber, mc);
            }
        }
    }

    private static boolean isBetterTool(ItemStack testedStack, ItemStack previousTool, BlockState state) {
        boolean isTool = EquipmentUtils.isAnyTool((ItemStack)testedStack);
        boolean isMisc = EquipmentUtils.isMiscTool((ItemStack)testedStack);
        if (previousTool.isEmpty() && isTool && Configs.Generic.TOOL_SWAP_BAMBOO_USES_SWORD_FIRST.getBooleanValue() && !state.is(Blocks.BAMBOO)) {
            return true;
        }
        if (Configs.Generic.TOOL_SWAP_BAMBOO_USES_SWORD_FIRST.getBooleanValue() && state.is(Blocks.BAMBOO)) {
            if (EquipmentUtils.isSword((ItemStack)testedStack)) {
                return InventoryUtils.applyBambooNeedsSwordFirst(testedStack, previousTool);
            }
            if (EquipmentUtils.isSword((ItemStack)previousTool)) {
                return false;
            }
        }
        if (!testedStack.isEmpty() && isMisc && Configs.Generic.TOOL_SWAP_NEEDS_SHEARS_FIRST.getBooleanValue() && CachedTagManager.isNeedsShears(state) && testedStack.is(Items.SHEARS) && !EquipmentUtils.isCorrectTool((ItemStack)testedStack, (BlockState)state)) {
            return InventoryUtils.applyNeedsShearsFirst(testedStack, previousTool, state, isMisc);
        }
        if (!testedStack.isEmpty() && isTool) {
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_FIRST.getBooleanValue() && CachedTagManager.isNeedsSilkTouch(state) || Configs.Generic.TOOL_SWAP_SILK_TOUCH_ORES.getBooleanValue() && CachedTagManager.isOreBlock(state) && EquipmentUtils.isPickAxe((ItemStack)testedStack) && EquipmentUtils.isCorrectTool((ItemStack)testedStack, (BlockState)state)) {
                return InventoryUtils.applySilkTouchFirst(testedStack, previousTool, state, isMisc);
            }
            if (Configs.Generic.TOOL_SWAP_SILK_TOUCH_OVERRIDE.getBooleanValue() && CachedTagManager.isSilkTouchOverride(state)) {
                return InventoryUtils.applySilkTouchFirst(testedStack, previousTool, state, isMisc);
            }
            return InventoryUtils.isBetterToolEach(testedStack, previousTool, state, isMisc, true);
        }
        return EquipmentUtils.isCorrectTool((ItemStack)testedStack, (BlockState)state);
    }

    private static boolean applyBambooNeedsSwordFirst(ItemStack testedStack, ItemStack previousTool) {
        boolean result;
        boolean prevSword = EquipmentUtils.isSword((ItemStack)previousTool);
        boolean enchants = Configs.Generic.WEAPON_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterWeaponEnchantments(testedStack, previousTool) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
        boolean bl = result = mats && enchants;
        if (prevSword) {
            return result;
        }
        return true;
    }

    private static boolean applyNeedsShearsFirst(ItemStack testedStack, ItemStack previousTool, BlockState state, boolean isMisc) {
        if (!isMisc) {
            return false;
        }
        boolean enchants = Configs.Generic.TOOL_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterToolEnchantments(testedStack, previousTool) : true;
        float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
        float prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state);
        boolean prevShears = previousTool.is(Items.SHEARS);
        boolean result = prevShears ? testSpeed >= prevSpeed && enchants : true;
        return result;
    }

    private static boolean applySilkTouchFirst(ItemStack testedStack, ItemStack previousTool, BlockState state, boolean isMisc) {
        boolean prevSilk = EquipmentUtils.hasSilkTouch((ItemStack)previousTool);
        if (EquipmentUtils.hasSilkTouch((ItemStack)testedStack)) {
            float prevSpeed;
            boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
            boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousTool);
            float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
            if (testSpeed > (prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state))) {
                return true;
            }
            if (testSpeed == prevSpeed) {
                return isMisc ? !prevSilk : (prevSilk ? rarity && mats : true);
            }
            if (testSpeed < prevSpeed && !prevSilk) {
                return isMisc ? true : rarity && mats;
            }
        } else if (prevSilk && !EquipmentUtils.hasSilkTouch((ItemStack)testedStack)) {
            return false;
        }
        return InventoryUtils.isBetterToolEach(testedStack, previousTool, state, isMisc, true);
    }

    private static boolean isBetterToolEach(ItemStack testedStack, ItemStack previousTool, BlockState state, boolean isMisc, boolean loop) {
        boolean correct = EquipmentUtils.isCorrectTool((ItemStack)testedStack, (BlockState)state);
        float testSpeed = InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state);
        float prevSpeed = InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state);
        boolean testSilkTouch = EquipmentUtils.hasSilkTouch((ItemStack)testedStack);
        boolean prevSilkTouch = EquipmentUtils.hasSilkTouch((ItemStack)previousTool);
        if (!correct) {
            return false;
        }
        boolean enchants = Configs.Generic.TOOL_SWAP_BETTER_ENCHANTS.getBooleanValue() ? InventoryUtils.hasSameOrBetterToolEnchantments(testedStack, previousTool) : true;
        boolean mats = InventoryUtils.hasTheSameOrBetterMaterial(testedStack, previousTool);
        boolean rarity = InventoryUtils.hasTheSameOrBetterRarity(testedStack, previousTool);
        if (testSpeed > prevSpeed) {
            return isMisc ? correct : (rarity || mats) && correct;
        }
        if (testSpeed == prevSpeed) {
            boolean preferSilk = Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.getBooleanValue();
            Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.setBooleanValue(false);
            boolean result = isMisc ? enchants && correct : (rarity || mats) && enchants && correct;
            boolean prevResult = loop ? InventoryUtils.isBetterToolEach(previousTool, testedStack, state, isMisc, false) : false;
            Configs.Generic.TOOL_SWAP_PREFER_SILK_TOUCH.setBooleanValue(preferSilk);
            if (prevResult && result) {
                if (preferSilk) {
                    return testSilkTouch && !prevSilkTouch;
                }
                if (!testSilkTouch && prevSilkTouch) {
                    return true;
                }
                if (testSilkTouch && !prevSilkTouch) {
                    return false;
                }
            }
            return result;
        }
        return false;
    }

    private static boolean isBetterToolAndHasDurability(ItemStack testedStack, ItemStack previousTool, BlockState state) {
        return InventoryUtils.hasEnoughDurability(testedStack) && InventoryUtils.isBetterTool(testedStack, previousTool, state);
    }

    private static boolean hasTheSameOrBetterRarity(ItemStack testedStack, ItemStack previousTool) {
        return Integer.compare(InventoryUtils.getRarityWeight(testedStack), InventoryUtils.getRarityWeight(previousTool)) >= 0;
    }

    private static int getRarityWeight(ItemStack stack) {
        Rarity rarity = stack.getRarity();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"EPIC", "RARE", "UNCOMMON", "COMMON"}, (Rarity)rarity, n)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case -1: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasTheSameOrBetterMaterial(ItemStack testedStack, ItemStack previousTool) {
        return Integer.compare(InventoryUtils.getMaterialWeight(testedStack), InventoryUtils.getMaterialWeight(previousTool)) >= 0;
    }

    private static int getMaterialWeight(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        if (itemType.contains("netherite")) {
            return 6;
        }
        if (itemType.contains("diamond")) {
            return 5;
        }
        if (itemType.contains("iron")) {
            return 4;
        }
        if (itemType.contains("copper")) {
            return 3;
        }
        if (itemType.contains("stone")) {
            return 2;
        }
        if (itemType.contains("gold")) {
            return 1;
        }
        if (itemType.contains("wood")) {
            return 0;
        }
        return -1;
    }

    private static boolean hasSameOrBetterToolEnchantments(ItemStack testedStack, ItemStack previousTool) {
        int count = 0;
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.MENDING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.UNBREAKING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.EFFICIENCY);
        return (count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.FORTUNE)) >= 0;
    }

    private static boolean hasSameOrBetterWeaponEnchantments(ItemStack testedStack, ItemStack previousTool) {
        int count = 0;
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.MENDING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.UNBREAKING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.LOOTING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.SHARPNESS);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.SMITE);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.BANE_OF_ARTHROPODS);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.POWER);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.IMPALING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.DENSITY);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.SWEEPING_EDGE);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.FIRE_ASPECT);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.PUNCH);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.INFINITY);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.FLAME);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.MULTISHOT);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.QUICK_CHARGE);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.PIERCING);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.RIPTIDE);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.LOYALTY);
        count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.CHANNELING);
        return (count += EquipmentUtils.hasSameOrBetterEnchantment((ItemStack)testedStack, (ItemStack)previousTool, (ResourceKey)Enchantments.BREACH)) >= 0;
    }

    protected static float getBaseBlockBreakingSpeed(ItemStack stack, BlockState state) {
        int effLevel;
        float speed = EquipmentUtils.getMiningSpeed((ItemStack)stack, (BlockState)state);
        if (speed > 1.0f && (effLevel = EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.EFFICIENCY)) > 0) {
            speed += (float)(effLevel * effLevel + 1);
        }
        if (state.requiresCorrectToolForDrops() && !stack.isCorrectToolForDrops(state)) {
            speed /= 3.3333333f;
        }
        return speed;
    }

    protected static boolean hasEnoughDurability(ItemStack stack) {
        return stack.getMaxDamage() - stack.getDamageValue() > InventoryUtils.getMinDurability(stack);
    }

    private static int findSuitableSlot(AbstractContainerMenu container, Predicate<ItemStack> itemTest) {
        return InventoryUtils.findSuitableSlot(container, itemTest, UniformInt.of((int)9, (int)(container.slots.size() - 1)));
    }

    private static int findSuitableSlot(AbstractContainerMenu container, Predicate<ItemStack> itemTest, UniformInt ... ranges) {
        int max = container.slots.size() - 1;
        for (UniformInt range : ranges) {
            int end = Math.min(max, range.getMaxValue());
            for (int slotNumber = range.getMinValue(); slotNumber <= end; ++slotNumber) {
                if (!itemTest.test(container.getSlot(slotNumber).getItem())) continue;
                return slotNumber;
            }
        }
        return -1;
    }

    private static int findSlotWithBestItemMatch(AbstractContainerMenu container, ItemPickerTest itemTest, UniformInt ... ranges) {
        int max = container.slots.size() - 1;
        ItemStack bestMatch = ItemStack.EMPTY;
        int slotNum = -1;
        for (UniformInt range : ranges) {
            int end = Math.min(max, range.getMaxValue());
            for (int slotNumber = range.getMinValue(); slotNumber <= end; ++slotNumber) {
                Slot slot = container.getSlot(slotNumber);
                if (!itemTest.isBetterMatch(slot.getItem(), bestMatch)) continue;
                bestMatch = slot.getItem();
                slotNum = slot.index;
            }
        }
        return slotNum;
    }

    private static int findEmptySlot(AbstractContainerMenu container, Collection<Integer> slotNumbers) {
        int maxSlot = container.slots.size() - 1;
        for (int slotNumber : slotNumbers) {
            if (slotNumber < 0 || slotNumber > maxSlot || container.getSlot(slotNumber).hasItem()) continue;
            return slotNumber;
        }
        return -1;
    }

    private static boolean isItemAtLowDurability(ItemStack stack, int minDurability) {
        return stack.isDamageableItem() && stack.getMaxDamage() - stack.getDamageValue() <= minDurability;
    }

    private static int getMinDurability(ItemStack stack) {
        if (!FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() || Configs.Generic.TOOL_SWAP_ALLOW_UNENCHANTED_TO_BREAK.getBooleanValue() && !stack.isEnchanted()) {
            return 0;
        }
        int minDurability = Configs.Generic.ITEM_SWAP_DURABILITY_THRESHOLD.getIntegerValue();
        if (stack.getMaxDamage() <= 100 && minDurability <= 20 && (double)minDurability / (double)stack.getMaxDamage() > 0.08) {
            minDurability = (int)Math.ceil((double)stack.getMaxDamage() * 0.08);
        }
        return minDurability;
    }

    private static void swapItemWithHigherDurabilityToHand(Player player, InteractionHand hand, ItemStack stackReference, int minDurabilityLeft) {
        InventoryMenu container = player.inventoryMenu;
        int slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((AbstractContainerMenu)container, stackReference, minDurabilityLeft);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_better_durability", (Object[])new Object[0]);
            return;
        }
        slotWithItem = fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((AbstractContainerMenu)container, (boolean)false, (boolean)false);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_off_players_hand", (Object[])new Object[0]);
            return;
        }
        slotWithItem = InventoryUtils.findSuitableSlot((AbstractContainerMenu)container, s -> !s.isDamageableItem());
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_dummy_item", (Object[])new Object[0]);
        }
    }

    public static void repairModeSwapItems(Player player) {
        if (player.containerMenu == player.inventoryMenu) {
            for (EquipmentSlot type : REPAIR_MODE_SLOTS) {
                InventoryUtils.repairModeHandleSlot(player, type);
            }
        }
    }

    private static void repairModeHandleSlot(Player player, EquipmentSlot type) {
        Slot slot;
        int slotRepairableItem;
        int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, player);
        if (slotNum == -1) {
            return;
        }
        ItemStack stack = player.getItemBySlot(type);
        if (!(stack.isEmpty() || stack.isDamageableItem() && stack.isDamaged() && EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.MENDING) > 0 || (slotRepairableItem = InventoryUtils.findRepairableItemNotInRepairableSlot(slot = player.containerMenu.getSlot(slotNum), player)) == -1)) {
            InventoryUtils.swapItemToEquipmentSlot(player, type, slotRepairableItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.repair_mode.swapped_repairable_item_to_slot", (Object[])new Object[]{type.getName()});
        }
    }

    private static int findRepairableItemNotInRepairableSlot(Slot targetSlot, Player player) {
        AbstractContainerMenu containerPlayer = player.containerMenu;
        for (Slot slot : containerPlayer.slots) {
            if (!slot.hasItem() || InventoryUtils.isConfiguredRepairSlot(slot.index, player)) continue;
            ItemStack stack = slot.getItem();
            if (slot.index - 36 == player.getInventory().getSelectedSlot() || !stack.isDamageableItem() || !stack.isDamaged() || !targetSlot.mayPlace(stack) || EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.MENDING) <= 0) continue;
            return slot.index;
        }
        return -1;
    }

    public static void equipBestElytra(Player player) {
        if (player == null || GuiUtils.getCurrentScreen() != null) {
            return;
        }
        AbstractContainerMenu container = player.containerMenu;
        Predicate<ItemStack> filter = s -> s.getItem().equals(Items.ELYTRA) && ((Equippable)s.get(DataComponents.EQUIPPABLE)).canBeEquippedBy(EntityType.PLAYER) && s.getDamageValue() < s.getMaxDamage() - 10;
        int targetSlot = InventoryUtils.findSlotWithBestItemMatch(container, (testedStack, previousBestMatch) -> {
            if (!filter.test(testedStack)) {
                return false;
            }
            if (!filter.test(previousBestMatch)) {
                return true;
            }
            if (EquipmentUtils.getEnchantmentLevel((ItemStack)testedStack, (ResourceKey)Enchantments.UNBREAKING) > EquipmentUtils.getEnchantmentLevel((ItemStack)previousBestMatch, (ResourceKey)Enchantments.UNBREAKING)) {
                return true;
            }
            if (EquipmentUtils.getEnchantmentLevel((ItemStack)testedStack, (ResourceKey)Enchantments.UNBREAKING) < EquipmentUtils.getEnchantmentLevel((ItemStack)previousBestMatch, (ResourceKey)Enchantments.UNBREAKING)) {
                return false;
            }
            return testedStack.getDamageValue() <= previousBestMatch.getDamageValue();
        }, UniformInt.of((int)9, (int)(container.slots.size() - 1)));
        if (targetSlot >= 0) {
            InventoryUtils.swapItemToEquipmentSlot(player, EquipmentSlot.CHEST, targetSlot);
        }
    }

    public static void swapElytraAndChestPlate(@Nullable Player player) {
        if (player == null || GuiUtils.getCurrentScreen() != null) {
            return;
        }
        AbstractContainerMenu container = player.containerMenu;
        ItemStack currentStack = player.getItemBySlot(EquipmentSlot.CHEST);
        Predicate<ItemStack> stackFilterChestPlate = s -> EquipmentUtils.matchArmorSlot((ItemStack)s, (EquipmentSlot)EquipmentSlot.CHEST);
        if (currentStack.isEmpty() || stackFilterChestPlate.test(currentStack)) {
            InventoryUtils.equipBestElytra(player);
        } else {
            Predicate<ItemStack> finalFilter = s -> stackFilterChestPlate.test((ItemStack)s) && s.getDamageValue() < s.getMaxDamage() - 10;
            int targetSlot = InventoryUtils.findSlotWithBestItemMatch(container, (testedStack, previousBestMatch) -> {
                if (!finalFilter.test(testedStack)) {
                    return false;
                }
                if (!finalFilter.test(previousBestMatch)) {
                    return true;
                }
                if (InventoryUtils.getArmorAndArmorToughnessValue(previousBestMatch, 1.0, EquipmentSlotGroup.CHEST) < InventoryUtils.getArmorAndArmorToughnessValue(testedStack, 1.0, EquipmentSlotGroup.CHEST)) {
                    return true;
                }
                if (InventoryUtils.getArmorAndArmorToughnessValue(previousBestMatch, 1.0, EquipmentSlotGroup.CHEST) > InventoryUtils.getArmorAndArmorToughnessValue(testedStack, 1.0, EquipmentSlotGroup.CHEST)) {
                    return false;
                }
                return EquipmentUtils.getEnchantmentLevel((ItemStack)previousBestMatch, (ResourceKey)Enchantments.PROTECTION) <= EquipmentUtils.getEnchantmentLevel((ItemStack)testedStack, (ResourceKey)Enchantments.PROTECTION);
            }, UniformInt.of((int)9, (int)(container.slots.size() - 1)));
            if (targetSlot >= 0) {
                InventoryUtils.swapItemToEquipmentSlot(player, EquipmentSlot.CHEST, targetSlot);
            }
        }
    }

    private static double getArmorAndArmorToughnessValue(ItemStack stack, double base, EquipmentSlotGroup slot) {
        double[] total = new double[]{base};
        stack.forEachModifier(slot, (entry, modifier, consumer) -> {
            if (entry.unwrapKey().orElseThrow() == Attributes.ARMOR || entry.unwrapKey().orElseThrow() == Attributes.ARMOR_TOUGHNESS) {
                switch (modifier.operation()) {
                    case ADD_VALUE: {
                        total[0] = total[0] + modifier.amount();
                        break;
                    }
                    case ADD_MULTIPLIED_BASE: {
                        total[0] = total[0] + modifier.amount() * base;
                        break;
                    }
                    case ADD_MULTIPLIED_TOTAL: {
                        total[0] = total[0] + modifier.amount() * total[0];
                        break;
                    }
                    default: {
                        throw new MatchException(null, null);
                    }
                }
            }
        });
        return total[0];
    }

    public static int findSlotWithItem(AbstractContainerMenu container, ItemStack stackReference, boolean allowHotbar, boolean reverse) {
        int startSlot = reverse ? container.slots.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.slots.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof InventoryMenu;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.slots.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.index, (boolean)false) || !allowHotbar && InventoryUtils.isHotbarSlot(slot) || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((ItemStack)slot.getItem(), (ItemStack)stackReference)) continue;
            return slot.index;
        }
        return -1;
    }

    private static boolean isHotbarSlot(Slot slot) {
        return InventoryUtils.isHotbarSlot(slot.index);
    }

    public static boolean isHotbarSlot(int slot) {
        return slot >= 36 && slot < 36 + Inventory.getSelectionSize();
    }

    public static boolean isOffhandSlot(int slot) {
        return slot == 36 + Inventory.getSelectionSize();
    }

    private static void swapItemToHand(Player player, InteractionHand hand, int slotNumber) {
        AbstractContainerMenu container = player.containerMenu;
        if (slotNumber != -1 && container == player.inventoryMenu) {
            Minecraft mc = Minecraft.getInstance();
            Inventory inventory = player.getInventory();
            if (hand == InteractionHand.MAIN_HAND) {
                int currentHotbarSlot = inventory.getSelectedSlot();
                if (InventoryUtils.isHotbarSlot(slotNumber)) {
                    inventory.setSelectedSlot(slotNumber - 36);
                    mc.getConnection().send((Packet)new ServerboundSetCarriedItemPacket(inventory.getSelectedSlot()));
                } else {
                    mc.gameMode.handleInventoryMouseClick(container.containerId, slotNumber, currentHotbarSlot, ClickType.SWAP, (Player)mc.player);
                }
            } else if (hand == InteractionHand.OFF_HAND) {
                mc.gameMode.handleInventoryMouseClick(container.containerId, slotNumber, 40, ClickType.SWAP, (Player)mc.player);
            }
        }
    }

    public static void swapItemToEquipmentSlot(Player player, EquipmentSlot type, int sourceSlotNumber) {
        if (sourceSlotNumber != -1 && player.containerMenu == player.inventoryMenu) {
            int equipmentSlotNumber = InventoryUtils.getSlotNumberForEquipmentType(type, player);
            InventoryUtils.swapSlots(player, sourceSlotNumber, equipmentSlotNumber);
        }
    }

    public static void swapSlots(Player player, int slotNum, int otherSlot) {
        Minecraft mc = Minecraft.getInstance();
        AbstractContainerMenu container = player.containerMenu;
        mc.gameMode.handleInventoryMouseClick(container.containerId, slotNum, 0, ClickType.SWAP, player);
        mc.gameMode.handleInventoryMouseClick(container.containerId, otherSlot, 0, ClickType.SWAP, player);
        mc.gameMode.handleInventoryMouseClick(container.containerId, slotNum, 0, ClickType.SWAP, player);
    }

    private static void swapToolToHand(int slotNumber, Minecraft mc) {
        LocalPlayer player = mc.player;
        if (slotNumber >= 0 && player.containerMenu == player.inventoryMenu) {
            Inventory inventory = player.getInventory();
            InventoryMenu container = player.inventoryMenu;
            if (InventoryUtils.isHotbarSlot(slotNumber)) {
                inventory.setSelectedSlot(slotNumber - 36);
                mc.getConnection().send((Packet)new ServerboundSetCarriedItemPacket(inventory.getSelectedSlot()));
            } else {
                int selectedSlot = inventory.getSelectedSlot();
                int hotbarSlot = InventoryUtils.getUsableHotbarSlotForTool(selectedSlot, TOOL_SWITCHABLE_SLOTS, (AbstractContainerMenu)container);
                if (Inventory.isHotbarSlot((int)hotbarSlot)) {
                    if (hotbarSlot != selectedSlot) {
                        inventory.setSelectedSlot(hotbarSlot);
                        mc.getConnection().send((Packet)new ServerboundSetCarriedItemPacket(inventory.getSelectedSlot()));
                    }
                    mc.gameMode.handleInventoryMouseClick(container.containerId, slotNumber, hotbarSlot, ClickType.SWAP, (Player)mc.player);
                }
            }
        }
    }

    private static int getUsableHotbarSlotForTool(int currentHotbarSlot, Collection<Integer> validSlots, AbstractContainerMenu container) {
        int first = -1;
        int nonTool = -1;
        if (validSlots.contains(currentHotbarSlot)) {
            ItemStack stack = container.getSlot(currentHotbarSlot + 36).getItem();
            if (stack.isEmpty()) {
                return currentHotbarSlot;
            }
            if (!EquipmentUtils.isRegularTool((ItemStack)stack)) {
                nonTool = currentHotbarSlot;
            }
        }
        for (int hotbarSlot : validSlots) {
            ItemStack stack = container.getSlot(hotbarSlot + 36).getItem();
            if (stack.isEmpty()) {
                return hotbarSlot;
            }
            if (nonTool == -1 && !EquipmentUtils.isRegularTool((ItemStack)stack)) {
                nonTool = hotbarSlot;
            }
            if (first != -1) continue;
            first = hotbarSlot;
        }
        return nonTool >= 0 ? nonTool : first;
    }

    private static int findSlotWithSuitableReplacementToolWithDurabilityLeft(AbstractContainerMenu container, ItemStack stackReference, int minDurabilityLeft) {
        for (Slot slot : container.slots) {
            ItemStack stackSlot = slot.getItem();
            if (!fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.index, (boolean)false) || !ItemStack.isSameItem((ItemStack)stackSlot, (ItemStack)stackReference) || stackSlot.getMaxDamage() - stackSlot.getDamageValue() < minDurabilityLeft || !InventoryUtils.hasSameIshEnchantments(stackReference, stackSlot)) continue;
            return slot.index;
        }
        return -1;
    }

    private static boolean hasSameIshEnchantments(ItemStack stackReference, ItemStack stack) {
        int level = EquipmentUtils.getEnchantmentLevel((ItemStack)stackReference, (ResourceKey)Enchantments.SILK_TOUCH);
        if (level > 0) {
            return EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.SILK_TOUCH) >= level;
        }
        level = EquipmentUtils.getEnchantmentLevel((ItemStack)stackReference, (ResourceKey)Enchantments.FORTUNE);
        if (level > 0) {
            return EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.FORTUNE) >= level;
        }
        return true;
    }

    private static int findSlotWithEffectiveItemWithDurabilityLeft(AbstractContainerMenu container, BlockState state) {
        int slotNum = -1;
        float bestSpeed = -1.0f;
        for (Slot slot : container.slots) {
            int effLevel;
            ItemStack stack;
            if (slot.index <= 8 || !slot.hasItem() || (stack = slot.getItem()).getMaxDamage() - stack.getDamageValue() <= InventoryUtils.getMinDurability(stack)) continue;
            float speed = stack.getDestroySpeed(state);
            if (speed > 1.0f && (effLevel = EquipmentUtils.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.EFFICIENCY)) > 0) {
                speed += (float)(effLevel * effLevel + 1);
            }
            if (!(speed > 1.0f) || slotNum != -1 && !(speed > bestSpeed)) continue;
            slotNum = slot.index;
            bestSpeed = speed;
        }
        return slotNum;
    }

    private static void tryCombineStacksInInventory(Player player, ItemStack stackReference) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        InventoryMenu container = player.inventoryMenu;
        Minecraft mc = Minecraft.getInstance();
        for (Slot slot : container.slots) {
            ItemStack stack;
            if (slot.index < 8 || (stack = slot.getItem()).getCount() >= stack.getMaxStackSize() || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ItemStack)stackReference, (ItemStack)stack)) continue;
            slots.add(slot);
        }
        block1: for (int i = 0; i < slots.size(); ++i) {
            Slot slot1 = (Slot)slots.get(i);
            for (int j = i + 1; j < slots.size(); ++j) {
                Slot slot2 = (Slot)slots.get(j);
                ItemStack stack = slot1.getItem();
                if (stack.getCount() < stack.getMaxStackSize()) {
                    mc.gameMode.handleInventoryMouseClick(container.containerId, slot1.index, 0, ClickType.PICKUP, player);
                    mc.gameMode.handleInventoryMouseClick(container.containerId, slot2.index, 0, ClickType.PICKUP, player);
                    if (!player.getInventory().getSelectedItem().isEmpty()) {
                        mc.gameMode.handleInventoryMouseClick(container.containerId, slot1.index, 0, ClickType.PICKUP, player);
                    }
                    if (slot2.getItem().getCount() >= slot2.getItem().getMaxStackSize()) {
                        slots.remove(j);
                        --j;
                    }
                }
                if (!slot1.hasItem()) continue block1;
            }
        }
    }

    public static boolean canUnstackingItemNotFitInInventory(ItemStack stack, Player player) {
        if (FeatureToggle.TWEAK_ITEM_UNSTACKING_PROTECTION.getBooleanValue() && stack.getCount() > 1 && UNSTACKING_ITEMS.contains(stack.getItem()) && fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((AbstractContainerMenu)player.inventoryMenu, (boolean)false, (boolean)false) == -1) {
            InventoryUtils.tryCombineStacksInInventory(player, stack);
            return fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((AbstractContainerMenu)player.inventoryMenu, (boolean)false, (boolean)false) == -1;
        }
        return false;
    }

    public static void switchToPickedBlock() {
        BlockPos pos;
        BlockState stateTargeted;
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel world = mc.level;
        if (player == null || world == null || player.containerMenu != player.inventoryMenu) {
            return;
        }
        double reach = mc.player.blockInteractionRange();
        boolean isCreative = player.isCreative();
        HitResult trace = player.pick(reach, mc.getDeltaTracker().getGameTimeDeltaPartialTick(false), false);
        if (trace != null && trace.getType() == HitResult.Type.BLOCK && !(stack = ((IMixinAbstractBlock)(stateTargeted = world.getBlockState(pos = ((BlockHitResult)trace).getBlockPos())).getBlock()).tweakeroo_getPickStack((LevelReader)world, pos, stateTargeted, false)).isEmpty() && !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ItemStack)stack, (ItemStack)player.getMainHandItem())) {
            AbstractContainerMenu container = player.containerMenu;
            Inventory inventory = player.getInventory();
            if (isCreative) {
                inventory.addAndPickItem(stack);
                mc.gameMode.handleCreativeModeItemAdd(player.getItemInHand(InteractionHand.MAIN_HAND), 36 + inventory.getSelectedSlot());
            } else {
                int slotNumber = fi.dy.masa.malilib.util.InventoryUtils.findSlotWithItem((AbstractContainerMenu)container, (ItemStack)stack, (boolean)true);
                if (slotNumber != -1) {
                    InventoryUtils.swapItemToHand((Player)player, InteractionHand.MAIN_HAND, slotNumber);
                }
            }
        }
    }

    public static interface ItemPickerTest {
        public boolean isBetterMatch(ItemStack var1, ItemStack var2);
    }
}

