/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.tweakeroo.Tweakeroo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CachedBlockTags {
    private static final CachedBlockTags INSTANCE = new CachedBlockTags();
    private final HashMap<String, Entry> entries = new HashMap();

    public static CachedBlockTags getInstance() {
        return INSTANCE;
    }

    private CachedBlockTags() {
    }

    public void build(String name, @Nonnull List<String> list) {
        if (name.isEmpty()) {
            Tweakeroo.LOGGER.error("CachedBlockTags#build: Invalid list name.");
            return;
        }
        if (list.isEmpty()) {
            Tweakeroo.LOGGER.warn("CachedBlockTags#build: list '{}' is empty.", (Object)name);
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(name, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
    }

    @Nullable
    public Entry get(String name) {
        if (this.entries.containsKey(name)) {
            return this.entries.get(name);
        }
        return null;
    }

    public void clear() {
        this.entries.forEach((name, entry) -> entry.clear());
    }

    public List<String> matchAny(Block block) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(block)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public List<String> matchAny(BlockState state) {
        ArrayList<String> list = new ArrayList<String>();
        this.entries.forEach((name, entry) -> {
            if (entry.contains(state)) {
                list.add((String)name);
            }
        });
        return list;
    }

    public boolean match(String name, Block block) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(block);
        }
        Tweakeroo.LOGGER.warn("CachedBlockTags#match(Block): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public boolean match(String name, BlockState state) {
        Entry entry = this.get(name);
        if (entry != null) {
            return entry.contains(state);
        }
        Tweakeroo.LOGGER.warn("CachedBlockTags#match(State): Invalid tag list '{}'", (Object)name);
        return false;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((name, entry) -> obj.add(name, entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            Entry entry;
            if (!obj.isJsonArray() || (entry = Entry.fromJson(obj.get(key))) == null) continue;
            this.entries.put(key, entry);
        }
    }

    public static class Entry {
        private final HashSet<Holder<Block>> blocks = new HashSet();
        private final HashSet<HolderSet<Block>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertBlock(Block block) {
            this.blocks.add((Holder<Block>)BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
        }

        public void insertTag(TagKey<Block> tag) {
            if (Minecraft.getInstance().level != null) {
                Registry wrapper = Minecraft.getInstance().level.registryAccess().lookupOrThrow(BuiltInRegistries.BLOCK.key());
                wrapper.get(tag).ifPresent(this.tags::add);
            }
        }

        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.substring(1));
                if (id != null) {
                    TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
                    if (tag != null) {
                        this.insertTag((TagKey<Block>)tag);
                    } else {
                        Tweakeroo.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    Tweakeroo.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                ResourceLocation id = ResourceLocation.tryParse((String)entry);
                if (id != null) {
                    Block block = (Block)BuiltInRegistries.BLOCK.getValue(id);
                    if (block != null) {
                        this.insertBlock(block);
                    } else {
                        Tweakeroo.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    Tweakeroo.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                Tweakeroo.LOGGER.warn("CachedBlockTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(Block block) {
            Holder entry = BuiltInRegistries.BLOCK.wrapAsHolder((Object)block);
            for (HolderSet<Block> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return true;
            }
            return this.blocks.contains(entry);
        }

        public boolean contains(BlockState state) {
            return this.contains(state.getBlock());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.blocks.forEach(entry -> list.add(entry.getRegisteredName()));
            this.tags.forEach(entry -> list.add("#" + entry.unwrapKey().toString()));
            return list;
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.blocks.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.getRegisteredName())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.unwrapKey().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.blocks.clear();
            this.tags.clear();
        }
    }
}

