/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.event;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.ActiveMode;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.data.ServerDataSyncer;
import fi.dy.masa.tweakeroo.renderer.InventoryOverlayHandler;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final Minecraft mc = Minecraft.getInstance();

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public void onRenderGameOverlayPostAdvanced(GuiGraphics drawContext, float partialTicks, ProfilerFiller profiler, Minecraft mc) {
        ActiveMode mode;
        if (FeatureToggle.TWEAK_HOTBAR_SWAP.getBooleanValue() && Hotkeys.HOTBAR_SWAP_BASE.getKeybind().isKeybindHeld()) {
            RenderUtils.renderHotbarSwapOverlay(mc, drawContext);
        } else if (FeatureToggle.TWEAK_HOTBAR_SCROLL.getBooleanValue() && Hotkeys.HOTBAR_SCROLL.getKeybind().isKeybindHeld()) {
            RenderUtils.renderHotbarScrollOverlay(mc, drawContext);
        }
        if (FeatureToggle.TWEAK_INVENTORY_PREVIEW.getBooleanValue() && Hotkeys.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
            InventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
        }
        if (FeatureToggle.TWEAK_PLAYER_INVENTORY_PEEK.getBooleanValue() && Hotkeys.PLAYER_INVENTORY_PEEK.getKeybind().isKeybindHeld()) {
            RenderUtils.renderPlayerInventoryOverlay(mc, drawContext);
        }
        if (FeatureToggle.TWEAK_SNAP_AIM.getBooleanValue() && Configs.Generic.SNAP_AIM_INDICATOR.getBooleanValue()) {
            RenderUtils.renderSnapAimAngleIndicator(drawContext);
        }
        if (FeatureToggle.TWEAK_ELYTRA_CAMERA.getBooleanValue() && ((mode = (ActiveMode)Configs.Generic.ELYTRA_CAMERA_INDICATOR.getOptionListValue()) == ActiveMode.ALWAYS || mode == ActiveMode.WITH_KEY && Hotkeys.ELYTRA_CAMERA.getKeybind().isKeybindHeld())) {
            RenderUtils.renderPitchLockIndicator(mc, drawContext);
        }
    }

    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        Item item = stack.getItem();
        if (item instanceof MapItem) {
            if (FeatureToggle.TWEAK_MAP_PREVIEW.getBooleanValue() && (!Configs.Generic.MAP_PREVIEW_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                fi.dy.masa.malilib.render.RenderUtils.renderMapPreview((ItemStack)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue(), (boolean)false, (GuiGraphics)drawContext);
            }
        } else if (stack.getComponents().has(DataComponents.CONTAINER) && InventoryUtils.shulkerBoxHasItems((ItemStack)stack)) {
            if (FeatureToggle.TWEAK_SHULKERBOX_DISPLAY.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                fi.dy.masa.malilib.render.RenderUtils.renderShulkerBoxPreview((ItemStack)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), (GuiGraphics)drawContext);
            }
        } else if (stack.is(Items.ENDER_CHEST) && Configs.Generic.SHULKER_DISPLAY_ENDER_CHEST.getBooleanValue()) {
            if (FeatureToggle.TWEAK_SHULKERBOX_DISPLAY.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                Pair<Entity, CompoundTag> pair;
                PlayerEnderChestContainer inv;
                Level world = WorldUtils.getBestWorld((Minecraft)this.mc);
                if (world == null || this.mc.player == null) {
                    return;
                }
                Player player = world.getPlayerByUUID(this.mc.player.getUUID());
                if (player != null && (inv = (pair = ServerDataSyncer.getInstance().requestEntity(world, player.getId())) != null && pair.getRight() != null && ((CompoundTag)pair.getRight()).contains("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)((CompoundTag)pair.getRight()), (HolderLookup.Provider)world.registryAccess()) : player.getEnderChestInventory()) != null) {
                    ListTag list = inv.createTag((HolderLookup.Provider)world.registryAccess());
                    CompoundTag nbt = new CompoundTag();
                    nbt.put("EnderItems", (Tag)list);
                    fi.dy.masa.malilib.render.RenderUtils.renderNbtItemsPreview((ItemStack)stack, (CompoundTag)nbt, (int)x, (int)y, (boolean)false, (GuiGraphics)drawContext);
                }
            }
        } else if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS) && InventoryUtils.bundleHasItems((ItemStack)stack) && FeatureToggle.TWEAK_BUNDLE_DISPLAY.getBooleanValue() && (!Configs.Generic.BUNDLE_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
            fi.dy.masa.malilib.render.RenderUtils.renderBundlePreview((ItemStack)stack, (int)x, (int)y, (int)Configs.Generic.BUNDLE_DISPLAY_ROW_WIDTH.getIntegerValue(), (boolean)Configs.Generic.BUNDLE_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), (GuiGraphics)drawContext);
        }
    }

    public void onRenderWorldLastAdvanced(Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, FogParameters fog, ProfilerFiller profiler) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            RenderTweaks.render(posMatrix, projMatrix, profiler);
            this.renderOverlays(posMatrix, mc);
        }
    }

    private void renderOverlays(Matrix4f posMatrix, Minecraft mc) {
        Entity entity = mc.getCameraEntity();
        if (FeatureToggle.TWEAK_FLEXIBLE_BLOCK_PLACEMENT.getBooleanValue() && entity != null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK && (Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ROTATION.getKeybind().isKeybindHeld() || Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_OFFSET.getKeybind().isKeybindHeld() || Hotkeys.FLEXIBLE_BLOCK_PLACEMENT_ADJACENT.getKeybind().isKeybindHeld())) {
            BlockHitResult hitResult = (BlockHitResult)mc.hitResult;
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            Color4f color = Configs.Generic.FLEXIBLE_PLACEMENT_OVERLAY_COLOR.getColor();
            fi.dy.masa.malilib.render.RenderUtils.renderBlockTargetingOverlay((Entity)entity, (BlockPos)hitResult.getBlockPos(), (Direction)hitResult.getDirection(), (Vec3)hitResult.getLocation(), (Color4f)color, (Matrix4f)posMatrix, (Minecraft)mc);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        }
    }
}

